/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class DirectoryRenameHandlerBase
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(DirectoryRenameHandlerBase.class);

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.directory.title");
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiDirectory directory;
        if (dataContext == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(0);
        }
        if ((directory = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext))) != null) {
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project = directory.getProject();
            if (Comparing.equal((Object)project.getBaseDir(), (Object)virtualFile)) {
                return false;
            }
            if (ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile)) {
                return true;
            }
        }
        return false;
    }

    protected PsiDirectory adjustForRename(DataContext dataContext, PsiElement element) {
        Module module;
        if (element instanceof PsiDirectoryContainer && (module = (Module)LangDataKeys.MODULE.getData(dataContext)) != null) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories(GlobalSearchScope.moduleScope((Module)module));
            Optional<PsiDirectory> directoryWithPackage = Arrays.stream(directories).filter(this::isSuitableDirectory).findFirst();
            return directoryWithPackage.orElse(null);
        }
        return element instanceof PsiDirectory && this.isSuitableDirectory((PsiDirectory)element) ? (PsiDirectory)element : null;
    }

    protected abstract boolean isSuitableDirectory(PsiDirectory var1);

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(2);
        }
        PsiDirectory element = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext));
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        this.doRename((PsiElement)element, project, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        PsiElement nameSuggestionContext = element;
        LOG.assertTrue((element = this.adjustForRename(dataContext, element)) != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.doRename(element, project, nameSuggestionContext, editor);
    }

    protected abstract void doRename(PsiElement var1, Project var2, PsiElement var3, Editor var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/DirectoryRenameHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

