/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlExtension
extends XmlExtension {
    public static final XmlExtension DEFAULT_EXTENSION = new DefaultXmlExtension();
    private static final Logger LOG = Logger.getInstance(DefaultXmlExtension.class);

    @Override
    public boolean isAvailable(PsiFile file2) {
        return true;
    }

    @Override
    @NotNull
    public List<XmlExtension.TagInfo> getAvailableTagNames(@NotNull XmlFile file2, @NotNull XmlTag context) {
        if (file2 == null) {
            DefaultXmlExtension.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultXmlExtension.$$$reportNull$$$0(1);
        }
        HashSet<String> namespaces = new HashSet<String>(Arrays.asList(context.knownNamespaces()));
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)file2);
        for (XmlSchemaProvider provider : providers) {
            namespaces.addAll(provider.getAvailableNamespaces(file2, null));
        }
        ArrayList nsInfo = new ArrayList();
        List<XmlElementDescriptor> descriptors = TagNameVariantCollector.getTagDescriptors(context, namespaces, nsInfo);
        ArrayList<XmlExtension.TagInfo> set = new ArrayList<XmlExtension.TagInfo>();
        for (int i = 0; i < descriptors.size(); ++i) {
            final XmlElementDescriptor descriptor = descriptors.get(i);
            String qualifiedName = descriptor.getName((PsiElement)context);
            LOG.assertTrue(qualifiedName != null, (Object)(descriptor + " returned null name"));
            int pos = qualifiedName.indexOf(58);
            String name = pos >= 0 ? qualifiedName.substring(pos + 1) : qualifiedName;
            set.add(new XmlExtension.TagInfo(name, (String)nsInfo.get(i)){

                @Override
                @Nullable
                public PsiElement getDeclaration() {
                    return descriptor.getDeclaration();
                }
            });
        }
        ArrayList<XmlExtension.TagInfo> arrayList = set;
        if (arrayList == null) {
            DefaultXmlExtension.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static Set<String> filterNamespaces(Set<String> namespaces, String tagName, XmlFile context) {
        if (tagName == null) {
            return namespaces;
        }
        HashSet<String> set = new HashSet<String>();
        block0: for (String namespace : namespaces) {
            XmlElementDescriptor[] elementDescriptors;
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)context, namespace);
            if (xmlFile == null) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            assert (nsDescriptor != null);
            for (XmlElementDescriptor elementDescriptor : elementDescriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                LOG.assertTrue(elementDescriptor != null, (Object)("Null returned from " + nsDescriptor));
                if (!DefaultXmlExtension.hasTag(elementDescriptor, tagName, new HashSet())) continue;
                set.add(namespace);
                continue block0;
            }
        }
        return set;
    }

    private static boolean hasTag(@NotNull XmlElementDescriptor elementDescriptor, String tagName, Set<? super XmlElementDescriptor> visited) {
        String name;
        if (elementDescriptor == null) {
            DefaultXmlExtension.$$$reportNull$$$0(3);
        }
        if ((name = elementDescriptor.getDefaultName()) == null) {
            LOG.error(elementDescriptor + " returned null as default name");
            return false;
        }
        if (name.equals(tagName)) {
            return true;
        }
        for (XmlElementDescriptor descriptor : elementDescriptor.getElementsDescriptors(null)) {
            if (visited.contains(elementDescriptor)) continue;
            visited.add((XmlElementDescriptor)elementDescriptor);
            if (!DefaultXmlExtension.hasTag(descriptor, tagName, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        String nsDeclarationAttrName = null;
        for (XmlTag t = context; t != null; t = t.getParentTag()) {
            XmlAttribute attribute;
            if (!t.hasNamespaceDeclarations()) continue;
            if (nsDeclarationAttrName == null) {
                String string = nsDeclarationAttrName = namespacePrefix.length() > 0 ? "xmlns:" + namespacePrefix : "xmlns";
            }
            if ((attribute = t.getAttribute(nsDeclarationAttrName)) == null) continue;
            String attrPrefix = attribute.getNamespacePrefix();
            TextRange textRange = TextRange.from((int)(attrPrefix.length() + 1), (int)namespacePrefix.length());
            return new SchemaPrefix(attribute, textRange, namespacePrefix);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/DefaultXmlExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/DefaultXmlExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTagNames";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

