/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAliasImporter {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.PhpAliasImporter");

    public static void insertUseStatement(@NotNull String fqn, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(0);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(1);
        }
        PhpAliasImporter.insertUseStatementWithKeyword(null, fqn, null, scopeForUseOperator);
    }

    public static void insertUseStatement(@NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(2);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(3);
        }
        PhpAliasImporter.insertUseStatementWithKeyword(null, fqn, alias, scopeForUseOperator);
    }

    public static void insertUseStatementWithKeyword(@Nullable String keyword, @NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(4);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(5);
        }
        if (scopeForUseOperator instanceof PhpExpressionCodeFragment) {
            return;
        }
        Project project = scopeForUseOperator.getProject();
        boolean success = PhpAliasImporter.insertInGroupUse(project, keyword, fqn, alias, scopeForUseOperator);
        if (success) {
            return;
        }
        PhpUseList useList = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, fqn, alias);
        List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
        for (PhpUseList anImport : imports) {
            String importedFqn;
            Object declaration;
            PhpReference reference;
            Object[] declarations = anImport.getDeclarations();
            if (ArrayUtil.isEmpty((Object[])declarations) || (reference = (declaration = declarations[0]).getTargetReference()) == null || (importedFqn = reference.getFQN()) == null || !PhpLangUtil.isFqn(importedFqn) || PhpLangUtil.compareFQN(fqn, importedFqn) >= 0) continue;
            anImport.getParent().addBefore((PsiElement)useList, (PsiElement)anImport);
            return;
        }
        if (imports.size() > 0) {
            PhpUseList anImport = imports.get(imports.size() - 1);
            anImport.getParent().addAfter((PsiElement)useList, (PsiElement)anImport);
            return;
        }
        GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)scopeForUseOperator, GroupStatement.class);
        LOG.assertTrue(groupStatement != null, (Object)DebugUtil.psiToString((PsiElement)scopeForUseOperator, (boolean)true));
        if (scopeForUseOperator instanceof PhpNamespace && PhpPsiUtil.getChildOfType((PsiElement)scopeForUseOperator, PhpTokenTypes.opSEMICOLON) != null && PhpPsiUtil.isOfType(groupStatement.getFirstChild(), PhpTokenTypes.chLBRACE)) {
            PhpAliasImporter.findPlaceToInsert(scopeForUseOperator, (PhpPsiElement)groupStatement).insert((PsiElement)useList, (PsiElement)scopeForUseOperator);
        } else {
            PhpPsiElement firstPsiChild = groupStatement.getFirstPsiChild();
            PsiElement openingTag = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.PHP_OPENING_TAG);
            if (firstPsiChild == null) {
                new InsertPlace(openingTag, InsertPlace.InsertElementType.AFTER).insert((PsiElement)useList, (PsiElement)groupStatement);
            } else {
                PsiElement closingTag;
                PsiElement echoTag = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.PHP_ECHO_OPENING_TAG);
                if (PhpAliasImporter.shouldInsertUseStatementInSeparatePhpBlock(echoTag, closingTag = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.PHP_CLOSING_TAG))) {
                    GroupStatement newImportInTags = PhpPsiElementFactory.createFromText(project, GroupStatement.class, useList.getText() + "\n?>\n");
                    assert (newImportInTags != null);
                    groupStatement.addRangeBefore(newImportInTags.getFirstChild(), newImportInTags.getLastChild(), groupStatement.getFirstChild());
                    return;
                }
                if (closingTag != null && echoTag != null && closingTag.getTextOffset() < echoTag.getTextOffset()) {
                    new InsertPlace(closingTag, InsertPlace.InsertElementType.BEFORE).insert((PsiElement)useList, (PsiElement)groupStatement);
                } else {
                    PhpAliasImporter.findPlaceToInsert(scopeForUseOperator, firstPsiChild).insert((PsiElement)useList, (PsiElement)groupStatement);
                }
            }
        }
    }

    private static boolean shouldInsertUseStatementInSeparatePhpBlock(@Nullable PsiElement echoTag, PsiElement closingTag) {
        return echoTag != null && (closingTag == null || echoTag.getTextOffset() < closingTag.getTextOffset());
    }

    private static boolean insertInGroupUse(@NotNull Project project, @Nullable String keyword, @NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        if (project == null) {
            PhpAliasImporter.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(7);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(8);
        }
        if (PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.GROUPED_USE)) {
            List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
            HashMap fqnToGroupUse = ContainerUtil.newHashMap();
            for (PhpUseList phpUseList : imports) {
                PhpNamespaceReference namespaceReference = phpUseList.getNamespaceReference();
                if (namespaceReference == null || !PhpGroupUseElement.getKeyword(null, phpUseList).equals(StringUtil.notNullize((String)keyword))) continue;
                fqnToGroupUse.put(PhpLangUtil.toFQN(namespaceReference.getFullName()), phpUseList);
            }
            String parentFqn = null;
            for (String currentFqn : fqnToGroupUse.keySet()) {
                if (!fqn.startsWith(currentFqn) || currentFqn.length() <= StringUtil.length(parentFqn)) continue;
                parentFqn = currentFqn;
            }
            if (parentFqn != null) {
                PhpUseList phpUseList = (PhpUseList)fqnToGroupUse.get(parentFqn);
                ArrayList uses = ContainerUtil.newArrayList();
                String newName = fqn.substring(parentFqn.length());
                boolean added = false;
                for (PhpUse use : phpUseList.getDeclarations()) {
                    String name = PhpUseImpl.getReferenceText(use);
                    if (!added && PhpLangUtil.compareFQN(PhpLangUtil.toFQN(name), PhpLangUtil.toFQN(newName)) > 0) {
                        added = uses.add(new PhpGroupUseElement(null, newName, alias));
                    }
                    uses.add(new PhpGroupUseElement(use));
                }
                if (!added) {
                    uses.add(new PhpGroupUseElement(null, newName, alias));
                }
                phpUseList.replace((PsiElement)PhpPsiElementFactory.createGroupUseStatementWithKeyword(project, keyword, parentFqn, uses));
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static InsertPlace findPlaceToInsert(@NotNull PhpPsiElement scopeForUseOperator, @NotNull PhpPsiElement firstChild) {
        PhpPsiElement sibling;
        PhpPsiElement anchor;
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(9);
        }
        if (firstChild == null) {
            PhpAliasImporter.$$$reportNull$$$0(10);
        }
        if (PhpPsiUtil.isOfType((PsiElement)(anchor = firstChild), PhpElementTypes.GLOBAL)) {
            sibling = anchor.getNextPsiSibling();
            if (sibling == null) {
                InsertPlace insertPlace = new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.AFTER);
                if (insertPlace == null) {
                    PhpAliasImporter.$$$reportNull$$$0(11);
                }
                return insertPlace;
            }
            anchor = sibling;
        }
        while (PhpPsiUtil.isOfType((PsiElement)anchor, PhpElementTypes.DECLARE) || PhpPsiUtil.isOfType((PsiElement)anchor, PhpElementTypes.HTML)) {
            sibling = anchor.getNextPsiSibling();
            if (sibling == null) {
                InsertPlace insertPlace = new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.AFTER);
                if (insertPlace == null) {
                    PhpAliasImporter.$$$reportNull$$$0(12);
                }
                return insertPlace;
            }
            anchor = sibling;
        }
        if (anchor instanceof PhpDocComment && scopeForUseOperator instanceof PhpFile) {
            PhpPsiElement next = anchor.getNextPsiSibling();
            if (PhpPsiUtil.isOfType((PsiElement)next, PhpElementTypes.HTML)) {
                InsertPlace insertPlace = new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.AFTER);
                if (insertPlace == null) {
                    PhpAliasImporter.$$$reportNull$$$0(13);
                }
                return insertPlace;
            }
            InsertPlace insertPlace = new InsertPlace((PsiElement)next, InsertPlace.InsertElementType.BEFORE);
            if (insertPlace == null) {
                PhpAliasImporter.$$$reportNull$$$0(14);
            }
            return insertPlace;
        }
        InsertPlace insertPlace = new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.BEFORE);
        if (insertPlace == null) {
            PhpAliasImporter.$$$reportNull$$$0(15);
        }
        return insertPlace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpAliasImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpAliasImporter";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findPlaceToInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStatementWithKeyword";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertInGroupUse";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceToInsert";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InsertPlace {
        private final PsiElement myAnchor;
        private final InsertElementType myDirection;

        private InsertPlace(PsiElement anchor, InsertElementType direction) {
            this.myAnchor = anchor;
            this.myDirection = direction;
        }

        public PsiElement insert(@NotNull PsiElement element, @NotNull PsiElement parent) {
            if (element == null) {
                InsertPlace.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                InsertPlace.$$$reportNull$$$0(1);
            }
            if (this.myDirection == InsertElementType.BEFORE) {
                PhpDocComment comment;
                PhpDocComment phpDocComment = comment = this.myAnchor instanceof PhpNamedElement ? ((PhpNamedElement)this.myAnchor).getDocComment() : null;
                if (comment != null) {
                    return comment.getParent().addRangeBefore(element.getPrevSibling(), element, (PsiElement)comment);
                }
                return parent.addBefore(element, this.myAnchor);
            }
            return parent.addRangeAfter(element.getPrevSibling(), element, this.myAnchor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpAliasImporter$InsertPlace";
            objectArray[2] = "insert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum InsertElementType {
            BEFORE,
            AFTER;

        }
    }
}

