/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodHandler;
import org.jetbrains.annotations.Nullable;

public class PhpMoveInstanceMethodHandlerDelegate
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        PsiElement parent = element.getParent();
        return PhpMoveMemberDelegate.extractMemberToMove(element, PhpMoveInstanceMethodHandlerDelegate.isSuitableMethod(parent)) != null;
    }

    private static boolean isSuitableMethod(PsiElement method) {
        return method instanceof Method && !((Method)method).isStatic();
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        Method method;
        if (element instanceof Method && !(method = (Method)element).isStatic()) {
            new PhpMoveInstanceMethodHandler().invoke(project, new PsiElement[]{method}, dataContext);
            return true;
        }
        return false;
    }
}

