/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.key;

import com.projectlibre1.server.data.CommonDataObject;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HasUniqueIdImpl
implements Serializable {
    private static final long serialVersionUID = 939382200022L;
    private static Map uniqueIds = new HashMap();
    protected long uniqueId = -1L;
    protected transient Session session;
    protected transient boolean local;

    public HasUniqueIdImpl(DataObject dataObject, long l) {
        this.setLocal(CommonDataObject.isLocal(l));
        uniqueIds.put(new Long(l), dataObject);
    }

    public HasUniqueIdImpl(boolean bl, DataObject dataObject) {
        this.setLocal(bl);
        this.uniqueId = this.session.getId();
        uniqueIds.put(new Long(this.uniqueId), dataObject);
    }

    protected void finalize() throws Throwable {
        uniqueIds.remove(new Long(this.uniqueId));
        super.finalize();
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean bl) {
        this.local = bl;
        this.session = SessionFactory.getInstance().getSession(bl);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HasUniqueIdImpl)) {
            return false;
        }
        return this.uniqueId == ((HasUniqueIdImpl)object).getUniqueId();
    }

    public boolean renumber(boolean bl) {
        if (this.uniqueId == -1L) {
            return false;
        }
        if (bl && !CommonDataObject.isLocal(this.uniqueId)) {
            return false;
        }
        if (bl && this.local) {
            this.setLocal(false);
        }
        long l = this.uniqueId;
        DataObject dataObject = (DataObject)uniqueIds.remove(new Long(l));
        this.uniqueId = this.session.getId();
        uniqueIds.put(new Long(this.uniqueId), dataObject);
        return true;
    }
}

