#!/usr/bin/env ruby
=begin
= sample of WebUnit( digit.cgi )
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: digit.cgi,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'cgi'
require 'digit'

c = CGI::new( 'html4' )

ruby_url = 'http://www.ruby-lang.org/ja/'
rubyunit_url = 'http://homepage1.nifty.com/markey/ruby/rubyunit/index.html'
webunit_url = 'http://www.jbt.co.jp/user/yuichi/ruby/webunit/index-ja.html'
tail_part = <<-EOS
  - Written in <a href='#{ruby_url}'>Ruby</a> -
   Tested by <a href='#{rubyunit_url}'>RubyUnit</a>
   and <a href='#{webunit_url}'>WebUnit</a> -
EOS

if c.key?( 'boct' ) # 8=>
  digit = Digit::new( c['toct'][0] )
elsif c.key?( 'bhex' ) # 16=>
  digit = Digit::new( c['thex'][0] )
else # 10=>
  digit = Digit::new( c['tdec'][0] )
end

c.out(){
  <<-EOS
    <html>
    <head>
      <title>Digit - WebUnit Sample -</title>
    </head>
    <body>
      <div align=center>
        <hr>
          <form method='post'>
          <table border=0>
            <tr>
              <td>#{ c.text_field( 'toct', digit.to_s( 8 ), 8 ) }</td>
              <td>#{ c.text_field( 'tdec', digit.to_s( 10 ), 8 ) }</td>
              <td>#{ c.text_field( 'thex', digit.to_s( 16 ), 8 ) }</td>
            </tr>
            <tr>
              <td align='center'>#{ c.submit( '8=>', 'boct' ) }</td>
              <td align='center'>#{ c.submit( '10=>', 'bdec' ) }</td>
              <td align='center'>#{ c.submit( '16=>', 'bhex' ) }</td>
            </tr>
          </table>
          </form>
        <hr>
          #{tail_part}
      </div>
    </body>
    </html>
  EOS
}
