/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.components.ServiceManager;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.RepositoryLoader;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class CacheLoader
extends Loader {
    @NotNull
    private final Loader myRepositoryLoader;

    public static Loader getInstance() {
        return (Loader)ServiceManager.getService(Loader.class);
    }

    public CacheLoader() {
        super(SvnRepositoryCache.getInstance());
        this.myRepositoryLoader = new RepositoryLoader(this.myCache);
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander expander) {
        if (node == null) {
            CacheLoader.$$$reportNull$$$0(0);
        }
        if (expander == null) {
            CacheLoader.$$$reportNull$$$0(1);
        }
        SwingUtilities.invokeLater(() -> {
            String error;
            String nodeUrl;
            List<DirectoryEntry> cached;
            if (node == null) {
                CacheLoader.$$$reportNull$$$0(3);
            }
            if (expander == null) {
                CacheLoader.$$$reportNull$$$0(4);
            }
            if ((cached = this.myCache.getChildren(nodeUrl = node.getURL().toString())) != null) {
                this.refreshNode(node, cached, expander);
            }
            if ((error = this.myCache.getError(nodeUrl)) != null) {
                this.refreshNodeError(node, error);
            }
            this.myRepositoryLoader.load(node, expander);
        });
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        NodeLoadState nodeLoadState = NodeLoadState.CACHED;
        if (nodeLoadState == null) {
            CacheLoader.$$$reportNull$$$0(2);
        }
        return nodeLoadState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLoadState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$load$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

