/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class BaseCucumberRunConfigurationUtil {
    public static void inspectFeatureFileOrFolderPath(@NotNull BaseCucumberRunConfiguration conf, boolean isExecution) throws Exception {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        switch (conf.getTestType()) {
            case ALL_IN_FOLDER: {
                BaseCucumberRunConfigurationUtil.inspectFeaturesFolder(conf, isExecution);
                break;
            }
            case TEST_SCRIPT: {
                BaseCucumberRunConfigurationUtil.inspectFeatureFile(conf, isExecution);
                break;
            }
        }
    }

    public static void inspectTagsFilter(BaseCucumberRunConfiguration conf, boolean isExecution) throws Exception {
        String filters = conf.getTagsFilters();
        if (!StringUtil.isEmpty((String)filters) && filters.contains(" ")) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.tags.filter.with.spaces"), (boolean)isExecution);
        }
    }

    private static void inspectFeaturesFolder(@NotNull BaseCucumberRunConfiguration conf, boolean isExecution) throws Exception {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        String folderPath = conf.getTestsFolderPath().trim();
        File folder = new File(folderPath);
        if (StringUtil.isEmpty((String)folderPath)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.folder.not.specified"), (boolean)isExecution);
        }
        if (!folder.exists()) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.folder.not.exists"), (boolean)isExecution);
        }
        if (!folder.isDirectory()) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.folder.not.dir"), (boolean)isExecution);
        }
    }

    private static void inspectFeatureFile(@NotNull BaseCucumberRunConfiguration conf, boolean isExecution) throws Exception {
        String scriptPath;
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(scriptPath = conf.getTestScriptPath().trim()))) {
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.script.not.specified"), (boolean)isExecution);
        }
        for (String pathWithLineNumber : StringUtil.split((String)scriptPath, (String)"\n")) {
            scriptPath = BaseCucumberRunConfigurationUtil.getFilePathFromPathWithLineNumber(pathWithLineNumber);
            VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
            if (script == null || !script.exists()) {
                RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.script.not.exists", (Object[])new Object[]{scriptPath}), (boolean)isExecution);
            }
            if (!script.isDirectory()) continue;
            RunConfigurationUtil.throwExecutionOrRuntimeException((String)RBundle.message((String)"cucumber.run.configuration.test.script.is.dir", (Object[])new Object[]{scriptPath}), (boolean)isExecution);
        }
    }

    public static void copyParams(CucumberRunConfigurationParams fromParams, CucumberRunConfigurationParams toParams) {
        toParams.setTestType(fromParams.getTestType());
        toParams.setTestsFolderPath(fromParams.getTestsFolderPath());
        toParams.setTestScriptPath(fromParams.getTestScriptPath());
        toParams.setTestFileMask(fromParams.getTestFileMask());
        toParams.setFeatureElementNameFilter(fromParams.getFeatureElementNameFilter());
        toParams.setTagsFilter(fromParams.getTagsFilters());
        toParams.setRunnerOptions(fromParams.getRunnerOptions());
        toParams.setRunnerGemVersion(fromParams.getRunnerGemVersion());
        toParams.setBacktraceEnabled(fromParams.isBacktraceEnabled());
        toParams.setVerboseEnabled(fromParams.isVerboseEnabled());
        toParams.setPreloadServer(fromParams.getPreloadServer());
        toParams.setShouldUseCustomCucumberRunner(fromParams.shouldUseCustomCucumberRunner());
        toParams.setCustomCucumberRunnerPath(fromParams.getCustomCucumberRunnerPath());
    }

    public static void initConfigurationTempateDefaultSettings(BaseCucumberRunConfiguration conf) {
        conf.setTestFileMask(CucumberRunConfiguration.DEFAULT_TESTS_SEARCH_MASK);
        conf.setVerboseEnabled(true);
        conf.setRunnerOptions("--color -r features");
        conf.setShouldUseCustomCucumberRunner(false);
    }

    @NotNull
    public static String getFilePathFromPathWithLineNumber(@NotNull String pathWithLineNumber) {
        int i;
        if (pathWithLineNumber == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        for (i = pathWithLineNumber.length() - 1; i >= 0 && Character.isDigit(pathWithLineNumber.charAt(i)); --i) {
        }
        if (i > 0 && pathWithLineNumber.charAt(i) == ':') {
            String string = pathWithLineNumber.substring(0, i);
            if (string == null) {
                BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = pathWithLineNumber;
        if (string == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathWithLineNumber";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathFromPathWithLineNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeatureFileOrFolderPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeaturesFolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeatureFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathFromPathWithLineNumber";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

