/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import javax.swing.JComponent;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.ConfigPanel;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceConfigurable
implements Configurable {
    private ConfigPanel myPanel = null;
    private final Project myProject;

    public PerforceConfigurable(Project project) {
        this.myProject = project;
    }

    public String getDisplayName() {
        return PerforceBundle.message((String)"main.configurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.Perforce";
    }

    public JComponent createComponent() {
        this.myPanel = new ConfigPanel(this.myProject);
        return this.myPanel.getPanel();
    }

    public boolean isModified() {
        if (this.myPanel == null) {
            return false;
        }
        return !this.myPanel.equalsToSettings(this.getSettings());
    }

    public void apply() {
        if (this.myPanel != null) {
            PerforceSettings settings = this.getSettings();
            boolean wasEnabled = settings.ENABLED;
            this.myPanel.applyTo(settings);
            PerforceConnectionManager.getInstance(this.myProject).updateConnections();
            if (settings.ENABLED != wasEnabled) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
            }
        }
    }

    private PerforceSettings getSettings() {
        return PerforceSettings.getSettings(this.myProject);
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.resetFrom(this.getSettings());
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }
}

