/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.RunConfigurationsSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.TopHitSEContributor;
import com.intellij.ide.util.gotoByName.SearchEverywhereConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereManagerImpl
implements SearchEverywhereManager {
    public static final String ALL_CONTRIBUTORS_GROUP_ID = "SearchEverywhereContributor.All";
    private static final String LOCATION_SETTINGS_KEY = "search.everywhere.popup";
    private final Project myProject;
    private final List<SearchEverywhereContributorFactory<?>> myContributorFactories = SearchEverywhereContributor.getProviders();
    private final Map<String, SearchEverywhereContributorFilter<?>> myContributorFilters = new HashMap();
    private JBPopup myBalloon;
    private SearchEverywhereUI mySearchEverywhereUI;
    private Dimension myBalloonFullSize;
    private final SearchHistoryList myHistoryList = new SearchHistoryList();
    private HistoryIterator myHistoryIterator;

    public SearchEverywhereManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void show(@NotNull String selectedContributorID, @Nullable String searchText, @NotNull AnActionEvent initEvent) {
        if (selectedContributorID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(0);
        }
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.isShown()) {
            throw new IllegalStateException("Method should cannot be called whe popup is shown");
        }
        Project project = initEvent.getProject();
        Component contextComponent = (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        List<SearchEverywhereContributor> serviceContributors = Arrays.asList(new TopHitSEContributor(project, contextComponent, s -> this.mySearchEverywhereUI.getSearchField().setText((String)s)), new RecentFilesSEContributor(project, GotoActionBase.getPsiContext(initEvent)), new RunConfigurationsSEContributor(project, contextComponent, () -> this.mySearchEverywhereUI.getSearchField().getText()));
        ArrayList<SearchEverywhereContributor> contributors = new ArrayList<SearchEverywhereContributor>(serviceContributors);
        this.myContributorFactories.forEach(factory -> {
            if (initEvent == null) {
                SearchEverywhereManagerImpl.$$$reportNull$$$0(3);
            }
            SearchEverywhereContributor contributor = factory.createContributor(initEvent);
            this.myContributorFilters.computeIfAbsent(contributor.getSearchProviderId(), s -> {
                if (initEvent == null) {
                    SearchEverywhereManagerImpl.$$$reportNull$$$0(4);
                }
                return factory.createFilter(initEvent);
            });
            contributors.add(contributor);
        });
        Collections.sort(contributors, Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
        Map<String, String> contributorsNames = contributors.stream().collect(Collectors.toMap(c -> c.getSearchProviderId(), c -> c.getGroupName()));
        this.myContributorFilters.computeIfAbsent(ALL_CONTRIBUTORS_GROUP_ID, s -> {
            List ids = ContainerUtil.map((Collection)contributors, c -> c.getSearchProviderId());
            return new PersistentSearchEverywhereContributorFilter<String>(ids, SearchEverywhereConfiguration.getInstance(project), id -> (String)contributorsNames.get(id), id -> null);
        });
        this.mySearchEverywhereUI = this.createView(this.myProject, contributors, this.myContributorFilters);
        this.mySearchEverywhereUI.switchToContributor(selectedContributorID);
        this.myHistoryIterator = this.myHistoryList.getIterator(selectedContributorID);
        boolean suppressHistory = "true".equals(System.getProperty("idea.searchEverywhere.noHistory", "false"));
        if (searchText == null && !suppressHistory) {
            searchText = this.myHistoryIterator.prev();
        }
        if (searchText != null && !searchText.isEmpty()) {
            this.mySearchEverywhereUI.getSearchField().setText(searchText);
            this.mySearchEverywhereUI.getSearchField().selectAll();
        }
        this.myBalloon = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this.mySearchEverywhereUI), (JComponent)this.mySearchEverywhereUI.getSearchField()).setProject(this.myProject).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).setCancelCallback(() -> {
            this.saveSearchText();
            return true;
        }).addUserData((Object)"SIMPLE_WINDOW").setResizable(true).setMovable(true).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)this.myBalloon, (Disposable)this.mySearchEverywhereUI);
        if (project != null) {
            Disposer.register((Disposable)project, (Disposable)this.myBalloon);
        }
        Dimension size = this.mySearchEverywhereUI.getMinimumSize();
        JBInsets.addTo((Dimension)size, (Insets)this.myBalloon.getContent().getInsets());
        this.myBalloon.setMinimumSize(size);
        this.myProject.putUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP, (Object)this.myBalloon);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.saveSize();
            this.myProject.putUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP, null);
            this.mySearchEverywhereUI = null;
            this.myBalloon = null;
            this.myBalloonFullSize = null;
        });
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            this.myBalloonFullSize = DimensionService.getInstance().getSize(LOCATION_SETTINGS_KEY, project);
            Dimension prefSize = this.mySearchEverywhereUI.getPreferredSize();
            this.myBalloon.setSize(prefSize);
        }
        this.calcPositionAndShow(project, this.myBalloon);
    }

    private void calcPositionAndShow(Project project, JBPopup balloon) {
        Window window;
        Component parent;
        Point savedLocation = DimensionService.getInstance().getLocation(LOCATION_SETTINGS_KEY, project);
        if (savedLocation == null && this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT && (parent = UIUtil.findUltimateParent((Component)(window = project != null ? WindowManager.getInstance().suggestParentWindow(project) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()))) != null) {
            JComponent content = balloon.getContent();
            Dimension balloonSize = content.getPreferredSize();
            Point screenPoint = new Point((parent.getSize().width - balloonSize.width) / 2, parent.getHeight() / 4 - balloonSize.height / 2);
            SwingUtilities.convertPointToScreen(screenPoint, parent);
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)screenPoint);
            Insets insets = content.getInsets();
            int bottomEdge = screenPoint.y + this.mySearchEverywhereUI.getExpandedSize().height + insets.bottom + insets.top;
            int shift = bottomEdge - (int)screenRectangle.getMaxY();
            if (shift > 0) {
                screenPoint.y = Integer.max(screenPoint.y - shift, screenRectangle.y);
            }
            RelativePoint showPoint = new RelativePoint(screenPoint);
            balloon.show(showPoint);
            return;
        }
        if (project != null) {
            balloon.showCenteredInCurrentWindow(project);
        } else {
            balloon.showInFocusCenter();
        }
    }

    @Override
    public boolean isShown() {
        return this.mySearchEverywhereUI != null && this.myBalloon != null && !this.myBalloon.isDisposed();
    }

    @Override
    public String getShownContributorID() {
        this.checkIsShown();
        return this.mySearchEverywhereUI.getSelectedContributorID();
    }

    @Override
    public void setShownContributor(@NotNull String contributorID) {
        if (contributorID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(2);
        }
        this.checkIsShown();
        if (!contributorID.equals(this.getShownContributorID())) {
            this.mySearchEverywhereUI.switchToContributor(contributorID);
        }
    }

    @Override
    public boolean isShowNonProjectItems() {
        this.checkIsShown();
        return this.mySearchEverywhereUI.isUseNonProjectItems();
    }

    @Override
    public void setShowNonProjectItems(boolean show) {
        this.checkIsShown();
        this.mySearchEverywhereUI.setUseNonProjectItems(show);
    }

    private SearchEverywhereUI createView(Project project, List<SearchEverywhereContributor> contributors, Map<String, SearchEverywhereContributorFilter<?>> contributorFilters) {
        SearchEverywhereUI view = new SearchEverywhereUI(project, contributors, contributorFilters);
        view.setSearchFinishedHandler(() -> {
            if (this.isShown()) {
                this.myBalloon.cancel();
            }
        });
        view.addViewTypeListener(viewType -> {
            if (!this.isShown()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Dimension minSize = view.getMinimumSize();
                JBInsets.addTo((Dimension)minSize, (Insets)this.myBalloon.getContent().getInsets());
                this.myBalloon.setMinimumSize(minSize);
                if (viewType == BigPopupUI.ViewType.SHORT) {
                    this.myBalloonFullSize = this.myBalloon.getSize();
                    JBInsets.removeFrom((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    this.myBalloon.pack(false, true);
                } else {
                    if (this.myBalloonFullSize == null) {
                        this.myBalloonFullSize = view.getPreferredSize();
                        JBInsets.addTo((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    }
                    this.myBalloonFullSize.height = Integer.max(this.myBalloonFullSize.height, minSize.height);
                    this.myBalloonFullSize.width = Integer.max(this.myBalloonFullSize.width, minSize.width);
                    this.myBalloon.setSize(this.myBalloonFullSize);
                }
            });
        });
        DumbAwareAction.create(__ -> this.showHistoryItem(true)).registerCustomShortcutSet((ShortcutSet)SearchTextField.SHOW_HISTORY_SHORTCUT, (JComponent)((Object)view));
        DumbAwareAction.create(__ -> this.showHistoryItem(false)).registerCustomShortcutSet((ShortcutSet)SearchTextField.ALT_SHOW_HISTORY_SHORTCUT, (JComponent)((Object)view));
        return view;
    }

    private void checkIsShown() {
        if (!this.isShown()) {
            throw new IllegalStateException("Method should be called only when search popup is shown");
        }
    }

    private void saveSearchText() {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        String searchText = this.mySearchEverywhereUI.getSearchField().getText();
        if (!searchText.isEmpty()) {
            this.myHistoryList.saveText(searchText, this.mySearchEverywhereUI.getSelectedContributorID());
        }
    }

    private void saveSize() {
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            DimensionService.getInstance().setSize(LOCATION_SETTINGS_KEY, this.myBalloonFullSize, this.myProject);
        }
    }

    private void showHistoryItem(boolean next) {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        JTextField searchField = this.mySearchEverywhereUI.getSearchField();
        searchField.setText(next ? this.myHistoryIterator.next() : this.myHistoryIterator.prev());
        searchField.selectAll();
    }

    private void updateHistoryIterator() {
        if (!this.isShown()) {
            return;
        }
        String selectedContributorID = this.mySearchEverywhereUI.getSelectedContributorID();
        if (this.myHistoryIterator == null || !this.myHistoryIterator.getContributorID().equals(selectedContributorID)) {
            this.myHistoryIterator = this.myHistoryList.getIterator(selectedContributorID);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedContributorID";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initEvent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorID";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setShownContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$show$3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HistoryIterator {
        private final String contributorID;
        private final List<String> list;
        private int index;

        HistoryIterator(String id, List<String> list2) {
            this.contributorID = id;
            this.list = list2;
            this.index = -1;
        }

        public String getContributorID() {
            return this.contributorID;
        }

        public String next() {
            if (this.list.isEmpty()) {
                return "";
            }
            ++this.index;
            if (this.index >= this.list.size()) {
                this.index = 0;
            }
            return this.list.get(this.index);
        }

        public String prev() {
            if (this.list.isEmpty()) {
                return "";
            }
            --this.index;
            if (this.index < 0) {
                this.index = this.list.size() - 1;
            }
            return this.list.get(this.index);
        }
    }

    private static class SearchHistoryList {
        private static final int HISTORY_LIMIT = 50;
        private final List<HistoryItem> historyList = new ArrayList<HistoryItem>();
        private static final Collector<String, List<String>, List<String>> distinctCollector = Collector.of(() -> new ArrayList(), (lst, str) -> {
            lst.remove(str);
            lst.add(str);
        }, (lst1, lst2) -> {
            lst1.removeAll((Collection<?>)lst2);
            lst1.addAll(lst2);
            return lst1;
        }, new Collector.Characteristics[0]);

        private SearchHistoryList() {
        }

        public HistoryIterator getIterator(String contributorID) {
            List<String> list2 = this.getHistoryForContributor(contributorID);
            return new HistoryIterator(contributorID, list2);
        }

        public void saveText(@NotNull String text, @NotNull String contributorID) {
            if (text == null) {
                SearchHistoryList.$$$reportNull$$$0(0);
            }
            if (contributorID == null) {
                SearchHistoryList.$$$reportNull$$$0(1);
            }
            this.historyList.stream().filter(item -> {
                if (text == null) {
                    SearchHistoryList.$$$reportNull$$$0(5);
                }
                if (contributorID == null) {
                    SearchHistoryList.$$$reportNull$$$0(6);
                }
                return text.equals(item.getSearchText()) && contributorID.equals(item.getContributorID());
            }).findFirst().ifPresent(this.historyList::remove);
            this.historyList.add(new HistoryItem(text, contributorID));
            List<String> list2 = this.filteredHistory(item -> {
                if (contributorID == null) {
                    SearchHistoryList.$$$reportNull$$$0(4);
                }
                return item.getContributorID().equals(contributorID);
            });
            if (list2.size() > 50) {
                this.historyList.stream().filter(item -> {
                    if (contributorID == null) {
                        SearchHistoryList.$$$reportNull$$$0(3);
                    }
                    return item.getContributorID().equals(contributorID);
                }).findFirst().ifPresent(this.historyList::remove);
            }
        }

        private List<String> getHistoryForContributor(String contributorID) {
            if (SearchEverywhereManagerImpl.ALL_CONTRIBUTORS_GROUP_ID.equals(contributorID)) {
                List<String> res2 = this.filteredHistory(item -> true);
                int size = res2.size();
                return size > 50 ? res2.subList(size - 50, size) : res2;
            }
            return this.filteredHistory(item -> item.getContributorID().equals(contributorID));
        }

        @NotNull
        private List<String> filteredHistory(Predicate<HistoryItem> predicate) {
            List<String> list2 = this.historyList.stream().filter(predicate).map(item -> item.getSearchText()).collect(distinctCollector);
            if (list2 == null) {
                SearchHistoryList.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributorID";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filteredHistory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "saveText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$saveText$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$saveText$1";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$saveText$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class HistoryItem {
            private final String searchText;
            private final String contributorID;

            HistoryItem(String searchText, String contributorID) {
                this.searchText = searchText;
                this.contributorID = contributorID;
            }

            public String getSearchText() {
                return this.searchText;
            }

            public String getContributorID() {
                return this.contributorID;
            }
        }
    }
}

