/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.bookmarks.actions.DeleteBookmarkAction;
import com.intellij.ide.bookmarks.actions.EditBookmarkDescriptionAction;
import com.intellij.ide.bookmarks.actions.MoveBookmarkDownAction;
import com.intellij.ide.bookmarks.actions.MoveBookmarkUpAction;
import com.intellij.ide.bookmarks.actions.ToggleSortBookmarksAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterDetailPopupBuilder;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksAction
extends AnAction
implements DumbAware,
MasterDetailPopupBuilder.Delegate {
    private static final String DIMENSION_SERVICE_KEY = "bookmarks";
    private JBPopup myPopup;

    public BookmarksAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BookmarksAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Bookmark bookmark;
        JBPopup popup2;
        Project project;
        if (e == null) {
            BookmarksAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
            return;
        }
        DefaultListModel<BookmarkItem> model = BookmarksAction.buildModel(project);
        final JBList list2 = new JBList(model);
        EditBookmarkDescriptionAction editDescriptionAction = new EditBookmarkDescriptionAction(project, (JList<? extends BookmarkItem>)list2);
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)editDescriptionAction);
        actions.add((AnAction)new DeleteBookmarkAction(project, (JList<? extends BookmarkItem>)list2));
        actions.add((AnAction)new ToggleSortBookmarksAction());
        actions.add((AnAction)new MoveBookmarkUpAction(project, (JList<BookmarkItem>)list2));
        actions.add((AnAction)new MoveBookmarkDownAction(project, (JList<BookmarkItem>)list2));
        this.myPopup = popup2 = new MasterDetailPopupBuilder(project).setList(list2).setDelegate(this).setDetailView(new MyDetailView(project)).setDimensionServiceKey(DIMENSION_SERVICE_KEY).setAddDetailViewToEast(true).setActionsGroup((ActionGroup)actions).setPopupTuner((Consumer<? super IPopupChooserBuilder>)((Consumer)builder2 -> builder2.setCloseOnEnter(false).setCancelOnClickOutside(false))).setDoneRunnable(() -> {
            if (this.myPopup != null) {
                this.myPopup.cancel();
            }
        }).createMasterDetailPopup();
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (BookmarkItem item : list2.getSelectedValuesList()) {
                    if (item == null) continue;
                    BookmarksAction.this.itemChosen(item, project, popup2, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/BookmarksAction$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)list2, (Disposable)popup2);
        editDescriptionAction.setPopup(popup2);
        Disposer.register((Disposable)popup2, () -> {
            if (this.myPopup == popup2) {
                this.myPopup = null;
                editDescriptionAction.setPopup(null);
            }
        });
        Point location = DimensionService.getInstance().getLocation(DIMENSION_SERVICE_KEY, project);
        this.myPopup.getContent().putClientProperty("BookmarkPopup", "TRUE");
        if (location != null) {
            popup2.showInScreenCoordinates((Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow(), location);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
        list2.getEmptyText().setText("No Bookmarks");
        list2.setSelectionMode(2);
        project.getMessageBus().connect((Disposable)popup2).subscribe(BookmarksListener.TOPIC, (Object)new BookmarksListener(){

            @Override
            public void bookmarksOrderChanged() {
                TreeSet selectedValues = new TreeSet(list2.getSelectedValuesList());
                DefaultListModel listModel = BookmarksAction.buildModel(project);
                list2.setModel((ListModel)listModel);
                ListSelectionModel selectionModel = list2.getSelectionModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    if (!selectedValues.contains(listModel.get(i))) continue;
                    selectionModel.addSelectionInterval(i, i);
                }
            }
        });
        BookmarkInContextInfo info = new BookmarkInContextInfo(e.getDataContext(), project).invoke();
        if (info != null && (bookmark = info.getBookmarkAtPlace()) != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                BookmarkItem item = model.getElementAt(i);
                if (item == null || item.getBookmark() != bookmark) continue;
                list2.setSelectedValue((Object)item, true);
                break;
            }
        }
    }

    private static DefaultListModel<BookmarkItem> buildModel(Project project) {
        DefaultListModel<BookmarkItem> model = new DefaultListModel<BookmarkItem>();
        for (Bookmark bookmark : BookmarkManager.getInstance(project).getValidBookmarks()) {
            model.addElement(new BookmarkItem(bookmark));
        }
        return model;
    }

    @Override
    public String getTitle() {
        return "Bookmarks";
    }

    @Override
    public void handleMnemonic(KeyEvent e, Project project, JBPopup popup2) {
        char mnemonic = e.getKeyChar();
        Bookmark bookmark = BookmarkManager.getInstance(project).findBookmarkForMnemonic(mnemonic);
        if (bookmark != null) {
            popup2.cancel();
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> bookmark.navigate(true));
        }
    }

    @Override
    @Nullable
    public JComponent createAccessoryView(Project project) {
        if (!BookmarkManager.getInstance(project).hasBookmarksWithMnemonics()) {
            return null;
        }
        JLabel mnemonicLabel = new JLabel();
        mnemonicLabel.setFont(Bookmark.getBookmarkFont());
        mnemonicLabel.setPreferredSize(new JLabel("W.").getPreferredSize());
        mnemonicLabel.setOpaque(false);
        return mnemonicLabel;
    }

    @Override
    public Object[] getSelectedItemsInTree() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void itemChosen(ItemWrapper item, Project project, JBPopup popup2, boolean withEnterOrDoubleClick) {
        if (item instanceof BookmarkItem && withEnterOrDoubleClick) {
            Bookmark bookmark = ((BookmarkItem)item).getBookmark();
            popup2.cancel();
            bookmark.navigate(true);
        }
    }

    @Override
    public void removeSelectedItemsInTree() {
    }

    static List<Bookmark> getSelectedBookmarks(JList<? extends BookmarkItem> list2) {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (BookmarkItem bookmarkItem : list2.getSelectedValuesList()) {
            if (bookmarkItem != null) {
                answer.add(bookmarkItem.getBookmark());
                continue;
            }
            return Collections.emptyList();
        }
        return answer;
    }

    static boolean notFiltered(JList<BookmarkItem> list2) {
        ListModel<BookmarkItem> model = list2.getModel();
        return !(model instanceof FilteringListModel) || ((FilteringListModel)model).getOriginalModel().getSize() == model.getSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/bookmarks/actions/BookmarksAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDetailView
    extends DetailViewImpl {
        MyDetailView(Project project) {
            super(project);
        }

        @Override
        @NotNull
        protected Editor createEditor(@Nullable Project project, Document document, VirtualFile file2) {
            Editor editor = super.createEditor(project, document, file2);
            editor.setBorder((Border)JBUI.Borders.empty());
            Editor editor2 = editor;
            if (editor2 == null) {
                MyDetailView.$$$reportNull$$$0(0);
            }
            return editor2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/actions/BookmarksAction$MyDetailView", "createEditor"));
        }
    }

    protected static class BookmarkInContextInfo {
        private final DataContext myDataContext;
        private final Project myProject;
        private Bookmark myBookmarkAtPlace;
        private VirtualFile myFile;
        private int myLine;

        public BookmarkInContextInfo(DataContext dataContext, Project project) {
            this.myDataContext = dataContext;
            this.myProject = project;
        }

        public Bookmark getBookmarkAtPlace() {
            return this.myBookmarkAtPlace;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getLine() {
            return this.myLine;
        }

        public BookmarkInContextInfo invoke() {
            this.myBookmarkAtPlace = null;
            this.myFile = null;
            this.myLine = -1;
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(this.myProject);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(this.myDataContext);
            if (editor != null) {
                if (ToolWindowManager.getInstance((Project)this.myProject).isEditorComponentActive()) {
                    Document document = editor.getDocument();
                    this.myLine = editor.getCaretModel().getLogicalPosition().line;
                    this.myFile = FileDocumentManager.getInstance().getFile(document);
                    this.myBookmarkAtPlace = bookmarkManager.findEditorBookmark(document, this.myLine);
                } else {
                    this.myFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myDataContext);
                    if (this.myFile != null) {
                        Document document = editor.getDocument();
                        if (Comparing.equal((Object)this.myFile, (Object)FileDocumentManager.getInstance().getFile(document))) {
                            this.myLine = editor.getCaretModel().getLogicalPosition().line;
                            this.myBookmarkAtPlace = bookmarkManager.findEditorBookmark(document, this.myLine);
                        }
                    }
                }
            }
            if (this.myFile == null) {
                this.myFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myDataContext);
                this.myLine = -1;
                if (this.myBookmarkAtPlace == null && this.myFile != null) {
                    this.myBookmarkAtPlace = bookmarkManager.findFileBookmark(this.myFile);
                }
            }
            return this;
        }
    }
}

