/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingConstants;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTextField
extends JTextComponent
implements SwingConstants {
    private static final long serialVersionUID = 353853209832607592L;
    private static final Action[] actions = new Action[1];
    public static final String notifyAction = "notify-field-accept";
    private int columns;
    private int align;
    private int scrollOffset;
    private Action action;
    private String actionCommand;
    private PropertyChangeListener actionPropertyChangeListener;
    private BoundedRangeModel horizontalVisibility;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public String getUIClassID() {
        return "TextFieldUI";
    }

    public void addActionListener(ActionListener listener) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JTextField.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeActionListener(ActionListener listener) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JTextField.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JTextField.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])this.getListeners(clazz);
    }

    protected void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 0, notifyAction);
        ActionListener[] listeners = this.getActionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].actionPerformed(event);
            ++index;
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public void setHorizontalAlignment(int newAlign) {
        if (this.align == newAlign) {
            return;
        }
        int oldAlign = this.align;
        this.align = newAlign;
        this.firePropertyChange("horizontalAlignment", oldAlign, newAlign);
        this.invalidate();
        this.repaint();
    }

    public void setFont(Font newFont) {
        super.setFont(newFont);
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            size.width = this.columns * this.getColumnWidth();
        }
        return size;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = offset;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), actions);
    }

    public void postActionEvent() {
        String command = this.actionCommand != null ? this.actionCommand : this.getText();
        ActionEvent event = new ActionEvent(this, 0, command);
        ActionListener[] listeners = this.getActionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].actionPerformed(event);
            ++index;
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) {
        if (this.action == newAction) {
            return;
        }
        if (this.action != null) {
            this.removeActionListener(this.action);
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.actionPropertyChangeListener = null;
        }
        Action oldAction = this.action;
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(this.action);
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
        }
        this.firePropertyChange("horizontalAlignment", oldAction, newAction);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent event) {
                String name = event.getPropertyName();
                if (name.equals("enabled")) {
                    boolean enabled = (Boolean)event.getNewValue();
                    JTextField.this.setEnabled(enabled);
                } else if (name.equals("ShortDescription")) {
                    JTextField.this.setToolTipText((String)event.getNewValue());
                }
            }
        };
    }

    protected void configurePropertiesFromAction(Action action) {
        if (action != null) {
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
        } else {
            this.setEnabled(true);
            this.setToolTipText(null);
        }
    }

    protected int getColumnWidth() {
        FontMetrics metrics = this.getToolkit().getFontMetrics(this.getFont());
        return metrics.charWidth('m');
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.horizontalVisibility;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String text) {
        this(null, text, 0);
    }

    public JTextField(int columns) {
        this(null, null, columns);
    }

    public JTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JTextField(Document doc, String text, int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.setDocument(doc == null ? this.createDefaultModel() : doc);
        if (text != null) {
            this.setText(text);
        }
        this.align = 10;
        this.horizontalVisibility = new DefaultBoundedRangeModel();
    }

    static {
        JTextField.actions[0] = new TextAction(notifyAction){

            public final void actionPerformed(ActionEvent event) {
                JTextField textField = (JTextField)event.getSource();
                textField.fireActionPerformed();
            }
        };
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        private static final long serialVersionUID = 8255147276740453036L;

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            return state;
        }

        protected AccessibleJTextField() {
        }
    }
}

