/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import net.sourceforge.napkinlaf.borders.AbstractNapkinBorder;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinWrappedBorder
extends AbstractNapkinBorder {
    private final Border origBorder;
    private final AbstractBorder border;

    public NapkinWrappedBorder(Border origBorder) {
        this.origBorder = origBorder;
        this.border = origBorder instanceof AbstractBorder ? (AbstractBorder)origBorder : null;
    }

    protected Insets doGetBorderInsets(Component c, Insets insets) {
        Insets result = this.origBorder.getBorderInsets(c);
        insets.set(result.top, result.left, result.bottom, result.right);
        return insets;
    }

    public boolean isBorderOpaque() {
        return this.origBorder.isBorderOpaque();
    }

    protected void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.syncWithTheme(this.origBorder, c);
        this.origBorder.paintBorder(c, g, x, y, width, height);
        NapkinUtil.finishGraphics(g, c);
    }

    public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
        return this.border != null ? this.border.getInteriorRectangle(c, x, y, width, height) : super.getInteriorRectangle(c, x, y, width, height);
    }

    public boolean equals(Object obj) {
        return obj instanceof NapkinWrappedBorder && ((NapkinWrappedBorder)obj).origBorder.equals(this.origBorder);
    }

    public int hashCode() {
        return NapkinWrappedBorder.class.hashCode() ^ this.origBorder.hashCode();
    }

    public String toString() {
        return "NapkinWrappedBoreder{" + this.origBorder.toString() + "}";
    }
}

