package TDS::Category;
# $Id: Category.pm,v 1.4.4.1 2001/02/13 00:48:06 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $SpecifiedCategory);

use ObjectTemplate;
@ISA = qw(ObjectTemplate);

use CGI::QueryString;

use TDS::DirInfo;

$SpecifiedCategory = "" unless defined $SpecifiedCategory;

attributes qw(content filename);
################################################################
sub initialize($)
{
    my $self = shift;
    
    $self->content([]);
    $self->filename(GetDataDir() . '/category.dat')
	unless $self->filename;
    $self->SUPER::initialize;
}
sub Read($)
{
    my $self = shift;

    if (open(F, $self->filename)){
	while (<F>){
	    chomp;
	    next if /^$/ || /^\#/;
	    push(@{$self->content}, $_);
	}
	close F;
    }
}
sub AsHTML_Array($;$)
{
    my ($self, $var) = @_;

    my @html;
    
    push(@html, qq(<select name="cat">));
    push(@html, qq(<option value="ALL">$var</option>));
    my $this_category = param('cat') || "";
#    for (@{$self->status->categories}){
    for (@{$self->content}){
	my $selected = ($this_category eq $_) ? 'selected' : '';
	push(@html, qq(<option value="$_" $selected>$_</option>));
    }
    return @html;
}
    

1;

