/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Transient;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AnnotationFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.FieldContact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.FieldDetail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.FieldScanner$FieldKey;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Reflector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

class FieldScanner
extends ContactList {
    private final AnnotationFactory factory;
    private final ContactMap done;
    private final Support support;

    public FieldScanner(Detail detail, Support support) {
        this.factory = new AnnotationFactory(detail, support);
        this.done = new ContactMap();
        this.support = support;
        this.scan(detail);
    }

    private void scan(Detail detail) {
        DefaultType defaultType = detail.getOverride();
        DefaultType defaultType2 = detail.getAccess();
        Class clazz = detail.getSuper();
        if (clazz != null) {
            this.extend(clazz, defaultType);
        }
        this.extract(detail, defaultType2);
        this.extract(detail);
        this.build();
    }

    private void extend(Class clazz, DefaultType defaultType) {
        ContactList contactList = this.support.getFields(clazz, defaultType);
        if (contactList != null) {
            this.addAll(contactList);
        }
    }

    private void extract(Detail detail) {
        List list = detail.getFields();
        for (FieldDetail fieldDetail : list) {
            Annotation[] annotationArray = fieldDetail.getAnnotations();
            Field field = fieldDetail.getField();
            for (Annotation annotation : annotationArray) {
                this.scan(field, annotation, annotationArray);
            }
        }
    }

    private void extract(Detail detail, DefaultType defaultType) {
        List list = detail.getFields();
        if (defaultType == DefaultType.FIELD) {
            for (FieldDetail fieldDetail : list) {
                Annotation[] annotationArray = fieldDetail.getAnnotations();
                Field field = fieldDetail.getField();
                Class<?> clazz = field.getType();
                if (this.isStatic(field) || this.isTransient(field)) continue;
                this.process(field, clazz, annotationArray);
            }
        }
    }

    private void scan(Field field, Annotation annotation, Annotation[] annotationArray) {
        if (annotation instanceof Attribute) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementList) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementArray) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementMap) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Element) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Version) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Text) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Transient) {
            this.remove(field, annotation);
        }
    }

    private void process(Field field, Class clazz, Annotation[] annotationArray) {
        Class[] classArray = Reflector.getDependents(field);
        Annotation annotation = this.factory.getInstance(clazz, classArray);
        if (annotation != null) {
            this.process(field, annotation, annotationArray);
        }
    }

    private void process(Field field, Annotation annotation, Annotation[] annotationArray) {
        FieldContact fieldContact = new FieldContact(field, annotation, annotationArray);
        FieldScanner$FieldKey fieldScanner$FieldKey = new FieldScanner$FieldKey(field);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.insert(fieldScanner$FieldKey, fieldContact);
    }

    private void insert(Object object, Contact contact) {
        Contact contact2 = (Contact)this.done.remove(object);
        if (contact2 != null && this.isText(contact)) {
            contact = contact2;
        }
        this.done.put(object, contact);
    }

    private boolean isText(Contact contact) {
        Annotation annotation = contact.getAnnotation();
        return annotation instanceof Text;
    }

    private void remove(Field field, Annotation annotation) {
        this.done.remove(new FieldScanner$FieldKey(field));
    }

    private void build() {
        for (Contact contact : this.done) {
            this.add(contact);
        }
    }

    private boolean isStatic(Field field) {
        int n = field.getModifiers();
        return Modifier.isStatic(n);
    }

    private boolean isTransient(Field field) {
        int n = field.getModifiers();
        return Modifier.isTransient(n);
    }
}

