/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.d.la;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuitesBundle {
    private final CoverageSuite[] mySuites;
    private final CoverageEngine myEngine;
    private Set<Module> myProcessedModules;
    private CachedValue<GlobalSearchScope> myCachedValue;
    private SoftReference<ProjectData> myData = new SoftReference(null);
    private static final Logger LOG;
    private static final long a;

    public CoverageSuitesBundle(CoverageSuite suite) {
        this(new CoverageSuite[]{suite});
    }

    public CoverageSuitesBundle(CoverageSuite[] suites) {
        this.mySuites = suites;
        LOG.assertTrue(this.mySuites.length > 0);
        this.myEngine = this.mySuites[0].getCoverageEngine();
        for (CoverageSuite coverageSuite : suites) {
            CoverageEngine coverageEngine = coverageSuite.getCoverageEngine();
            LOG.assertTrue(Comparing.equal((Object)coverageEngine, (Object)this.myEngine));
        }
    }

    public boolean isValid() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            if (coverageSuite.isValid()) continue;
            return false;
        }
        return true;
    }

    public Project getProject() {
        return this.mySuites[0].getProject();
    }

    public long getLastCoverageTimeStamp() {
        long l2 = 0L;
        for (CoverageSuite coverageSuite : this.mySuites) {
            l2 = Math.max(l2, coverageSuite.getLastCoverageTimeStamp());
        }
        return l2;
    }

    public boolean isCoverageByTestApplicable() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            if (!coverageSuite.isCoverageByTestApplicable()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoverageByTestEnabled() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            if (!coverageSuite.isCoverageByTestEnabled()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProjectData getCoverageData() {
        ProjectData projectData = (ProjectData)this.myData.get();
        if (projectData != null) {
            return projectData;
        }
        ProjectData projectData2 = new ProjectData();
        for (CoverageSuite coverageSuite : this.mySuites) {
            ProjectData projectData3 = coverageSuite.getCoverageData(null);
            if (projectData3 == null) continue;
            projectData2.merge((CoverageData)projectData3);
        }
        this.myData = new SoftReference((Object)projectData2);
        return projectData2;
    }

    public boolean isTrackTestFolders() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            if (!coverageSuite.isTrackTestFolders()) continue;
            return true;
        }
        return false;
    }

    public boolean isTracingEnabled() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            if (!coverageSuite.isTracingEnabled()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myEngine;
        if (coverageEngine == null) {
            CoverageSuitesBundle.a(0);
        }
        return coverageEngine;
    }

    public LineMarkerRendererWithErrorStripe getLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            CoverageSuitesBundle.a(1);
        }
        return this.myEngine.getLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public CoverageAnnotator getAnnotator(@NotNull Project project) {
        if (project == null) {
            CoverageSuitesBundle.a(2);
        }
        return this.myEngine.getCoverageAnnotator(project);
    }

    public CoverageSuite @NotNull [] getSuites() {
        if (this.mySuites == null) {
            CoverageSuitesBundle.a(3);
        }
        return this.mySuites;
    }

    public boolean contains(CoverageSuite suite) {
        return ArrayUtilRt.find((Object[])this.mySuites, (Object)suite) > -1;
    }

    public void setCoverageData(ProjectData projectData) {
        this.myData = new SoftReference((Object)projectData);
    }

    public void restoreCoverageData() {
        this.myData = new SoftReference(null);
        for (CoverageSuite coverageSuite : this.mySuites) {
            coverageSuite.restoreCoverageData();
        }
    }

    public String getPresentableName() {
        long l2 = a ^ 0x319AE06E9072L;
        return StringUtil.join((Object[])this.mySuites, coverageSuite -> coverageSuite.getPresentableName(), (String)", ");
    }

    public boolean isModuleChecked(Module module) {
        return this.myProcessedModules != null && this.myProcessedModules.contains(module);
    }

    public void checkModule(Module module) {
        if (this.myProcessedModules == null) {
            this.myProcessedModules = new HashSet<Module>();
        }
        this.myProcessedModules.add(module);
    }

    @Nullable
    public RunConfigurationBase getRunConfiguration() {
        for (CoverageSuite coverageSuite : this.mySuites) {
            RunConfigurationBase runConfigurationBase;
            if (!(coverageSuite instanceof BaseCoverageSuite) || (runConfigurationBase = ((BaseCoverageSuite)coverageSuite).getConfiguration()) == null) continue;
            return runConfigurationBase;
        }
        return null;
    }

    public GlobalSearchScope getSearchScope(Project project) {
        if (this.myCachedValue == null) {
            this.myCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)this.a(project), new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}), false);
        }
        return (GlobalSearchScope)this.myCachedValue.getValue();
    }

    private GlobalSearchScope a(Project project) {
        Object[] objectArray = (Module[])Arrays.stream(this.mySuites).filter(coverageSuite -> coverageSuite instanceof BaseCoverageSuite).map(coverageSuite -> ((BaseCoverageSuite)coverageSuite).getConfiguration()).filter(runConfigurationBase -> runConfigurationBase instanceof ModuleBasedConfiguration).map(runConfigurationBase -> ((ModuleBasedConfiguration)runConfigurationBase).getConfigurationModule().getModule()).toArray(Module[]::new);
        if (objectArray.length == 0 || ArrayUtil.find((Object[])objectArray, null) > -1) {
            return this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScopesCore.projectProductionScope((Project)project);
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])Arrays.stream(objectArray).map(module -> GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)this.isTrackTestFolders())).toArray(GlobalSearchScope[]::new)));
    }

    static {
        a = la.a(-4968120778115796187L, -5047085608731381275L, MethodHandles.lookup().lookupClass()).a(270653638309947L);
        LOG = Logger.getInstance(CoverageSuitesBundle.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x206C36FA141EL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEngine";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

