/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import a.d.la;
import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuiteChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String LOCAL = "Local";
    private final Project myProject;
    private final CheckboxTree mySuitesTree;
    private final CoverageDataManager myCoverageManager;
    private final CheckedTreeNode myRootNode;
    private CoverageEngine myEngine;
    private static final long a = la.a(8614653573205747139L, -3813137838313556807L, MethodHandles.lookup().lookupClass()).a(60136005472583L);

    public CoverageSuiteChooserDialog(Project project) {
        long l2 = a ^ 0x60A42E322A9DL;
        super(project, true);
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance(project);
        this.myRootNode = new CheckedTreeNode((Object)"");
        this.b();
        this.mySuitesTree = new CheckboxTree(new SuitesRenderer(), this.myRootNode){

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, treePath -> {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof CoverageSuite) {
                        return ((CoverageSuite)object).getPresentableName();
                    }
                    return object.toString();
                });
            }
        };
        this.mySuitesTree.getEmptyText().appendText(CoverageBundle.message("no.coverage.suites.configured", new Object[0]));
        this.mySuitesTree.setRootVisible(false);
        this.mySuitesTree.setShowsRootHandles(false);
        TreeUtil.installActions((JTree)this.mySuitesTree);
        TreeUtil.expandAll((JTree)this.mySuitesTree);
        TreeUtil.promiseSelectFirst((JTree)this.mySuitesTree);
        this.mySuitesTree.setMinimumSize(new Dimension(25, -1));
        this.setOKButtonText(CoverageBundle.message("coverage.data.show.selected.button", new Object[0]));
        this.init();
        this.setTitle(CoverageBundle.message("choose.coverage.suite.to.display", new Object[0]));
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.mySuitesTree);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuitesTree;
    }

    protected JComponent createNorthPanel() {
        long l2 = a ^ 0x46D6994E3E4L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new AddExternalSuiteAction(this));
        defaultActionGroup.add((AnAction)new DeleteSuiteAction(this));
        defaultActionGroup.add((AnAction)new SwitchEngineAction());
        return ActionManager.getInstance().createActionToolbar("CoverageSuiteChooser", (ActionGroup)defaultActionGroup, true).getComponent();
    }

    protected void doOKAction() {
        List<CoverageSuite> list2 = this.a();
        this.myCoverageManager.chooseSuitesBundle(list2.isEmpty() ? null : new CoverageSuitesBundle(list2.toArray(new CoverageSuite[0])));
        ((CoverageDataManagerImpl)this.myCoverageManager).addRootsToWatch(list2);
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        long l2 = a ^ 0x7EE7CFD7477CL;
        CoverageEngine coverageEngine = null;
        for (CoverageSuite coverageSuite : this.a()) {
            if (coverageEngine == null) {
                coverageEngine = coverageSuite.getCoverageEngine();
                continue;
            }
            if (Comparing.equal((Object)coverageEngine, (Object)coverageSuite.getCoverageEngine())) continue;
            List<ValidationInfo> list2 = Collections.singletonList(new ValidationInfo(CoverageBundle.message("cannot.show.coverage.reports.from.different.engines", new Object[0]), (JComponent)this.mySuitesTree));
            if (list2 == null) {
                CoverageSuiteChooserDialog.a(0);
            }
            return list2;
        }
        List list3 = super.doValidateAll();
        if (list3 == null) {
            CoverageSuiteChooserDialog.a(1);
        }
        return list3;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoCoverageAction(this), this.getCancelAction()};
        if (actionArray == null) {
            CoverageSuiteChooserDialog.a(2);
        }
        return actionArray;
    }

    private Set<CoverageEngine> a() {
        HashSet<CoverageEngine> hashSet = new HashSet<CoverageEngine>();
        for (CoverageSuite coverageSuite : this.myCoverageManager.getSuites()) {
            hashSet.add(coverageSuite.getCoverageEngine());
        }
        return hashSet;
    }

    private static String a(CoverageRunner coverageRunner) {
        long l2 = a ^ 0x530CBD2FF693L;
        return CoverageBundle.message("coverage.data.runner.name", coverageRunner.getPresentableName());
    }

    @Nullable
    private static CoverageRunner a(VirtualFile virtualFile) {
        for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
            for (String string : coverageRunner.getDataFileExtensions()) {
                if (!Comparing.strEqual((String)virtualFile.getExtension(), (String)string)) continue;
                return coverageRunner;
            }
        }
        return null;
    }

    private List<CoverageSuite> a() {
        ArrayList<CoverageSuite> arrayList = new ArrayList<CoverageSuite>();
        TreeUtil.treeNodeTraverser((TreeNode)this.myRootNode).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(treeNode -> {
            Object object;
            if (treeNode instanceof CheckedTreeNode && ((CheckedTreeNode)treeNode).isChecked() && (object = ((CheckedTreeNode)treeNode).getUserObject()) instanceof CoverageSuite) {
                arrayList.add((CoverageSuite)object);
            }
            return true;
        });
        return arrayList;
    }

    private void b() {
        long l2 = a ^ 0x5249FD18009L;
        this.myRootNode.removeAllChildren();
        HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> hashMap = new HashMap<CoverageRunner, Map<String, List<CoverageSuite>>>();
        CoverageSuiteChooserDialog.a(hashMap, this.myCoverageManager.getSuites(), this.myEngine);
        CoverageSuitesBundle coverageSuitesBundle = this.myCoverageManager.getCurrentSuitesBundle();
        ArrayList<CoverageRunner> arrayList = new ArrayList<CoverageRunner>(hashMap.keySet());
        arrayList.sort((coverageRunner, coverageRunner2) -> coverageRunner.getPresentableName().compareToIgnoreCase(coverageRunner2.getPresentableName()));
        for (CoverageRunner coverageRunner3 : arrayList) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.a(coverageRunner3));
            Map<String, List<CoverageSuite>> map = hashMap.get(coverageRunner3);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(CoverageBundle.message("remote.suites.node", new Object[0]));
            if (map.size() == 1) {
                object2 = map.keySet().iterator().next();
                Object object3 = defaultMutableTreeNode;
                if (!Comparing.strEqual((String)object2, (String)DefaultCoverageFileProvider.class.getName())) {
                    object3 = defaultMutableTreeNode2;
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                List<CoverageSuite> list2 = map.get(object2);
                list2.sort((coverageSuite, coverageSuite2) -> coverageSuite.getPresentableName().compareToIgnoreCase(coverageSuite2.getPresentableName()));
                for (Object object : list2) {
                    CheckedTreeNode checkedTreeNode = new CheckedTreeNode(object);
                    checkedTreeNode.setChecked((coverageSuitesBundle != null && coverageSuitesBundle.contains((CoverageSuite)object) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    ((DefaultMutableTreeNode)object3).add((MutableTreeNode)checkedTreeNode);
                }
            } else {
                object2 = new DefaultMutableTreeNode(LOCAL);
                defaultMutableTreeNode.add((MutableTreeNode)object2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                for (String string : map.keySet()) {
                    Object object;
                    Object object3 = Comparing.strEqual((String)string, (String)DefaultCoverageFileProvider.class.getName()) ? object2 : defaultMutableTreeNode2;
                    object = map.get(string).iterator();
                    while (object.hasNext()) {
                        CoverageSuite coverageSuite3 = (CoverageSuite)object.next();
                        CheckedTreeNode checkedTreeNode = new CheckedTreeNode((Object)coverageSuite3);
                        checkedTreeNode.setChecked((coverageSuitesBundle != null && coverageSuitesBundle.contains(coverageSuite3) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                        ((DefaultMutableTreeNode)object3).add((MutableTreeNode)checkedTreeNode);
                    }
                }
            }
            this.myRootNode.add((MutableTreeNode)defaultMutableTreeNode);
        }
    }

    private static void a(HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> hashMap, CoverageSuite[] coverageSuiteArray, CoverageEngine coverageEngine) {
        for (CoverageSuite coverageSuite : coverageSuiteArray) {
            String string;
            List<CoverageSuite> list2;
            CoverageFileProvider coverageFileProvider;
            if (coverageEngine != null && coverageSuite.getCoverageEngine() != coverageEngine || (coverageFileProvider = coverageSuite.getCoverageDataFileProvider()) instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)((DefaultCoverageFileProvider)coverageFileProvider).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName()) && !coverageFileProvider.ensureFileExists()) continue;
            CoverageRunner coverageRunner = coverageSuite.getRunner();
            Map<String, List<CoverageSuite>> map = hashMap.get(coverageRunner);
            if (map == null) {
                map = new HashMap<String, List<CoverageSuite>>();
                hashMap.put(coverageRunner, map);
            }
            if ((list2 = map.get(string = coverageFileProvider instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)coverageFileProvider).getSourceProvider() : coverageFileProvider.getClass().getName())) == null) {
                list2 = new ArrayList<CoverageSuite>();
                map.put(string, list2);
            }
            list2.add(coverageSuite);
        }
    }

    private void a() {
        ((DefaultTreeModel)this.mySuitesTree.getModel()).reload();
        TreeUtil.expandAll((JTree)this.mySuitesTree);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x3C6D1E14494FL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SwitchEngineAction
    extends ComboBoxAction {
        private static final long a = la.a(3570826759205880159L, -4057154541261808165L, MethodHandles.lookup().lookupClass()).a(88338828041658L);

        private SwitchEngineAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            for (final CoverageEngine coverageEngine : CoverageSuiteChooserDialog.this.a()) {
                defaultActionGroup.add(new AnAction(coverageEngine.getPresentableText()){
                    private static final long a = la.a(-4396249863539385537L, 8971478059889923414L, MethodHandles.lookup().lookupClass()).a(65475999863189L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            1.a(0);
                        }
                        CoverageSuiteChooserDialog.this.myEngine = coverageEngine;
                        CoverageSuiteChooserDialog.this.b();
                        CoverageSuiteChooserDialog.this.a();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x60F8758D33AFL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
            if (defaultActionGroup2 == null) {
                SwitchEngineAction.a(0);
            }
            return defaultActionGroup2;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SwitchEngineAction.a(1);
            }
            super.update(e10);
            e10.getPresentation().setVisible(CoverageSuiteChooserDialog.this.a().size() > 1);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x158A27596224L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DeleteSuiteAction
    extends AnAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(5929538875847419799L, 3839326266088362072L, MethodHandles.lookup().lookupClass()).a(270462837907617L);

        DeleteSuiteAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x21FD466524F1L;
            this.this$0 = coverageSuiteChooserDialog;
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)coverageSuiteChooserDialog.mySuitesTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            CheckedTreeNode[] checkedTreeNodeArray;
            if (e10 == null) {
                DeleteSuiteAction.a(0);
            }
            for (CheckedTreeNode checkedTreeNode : checkedTreeNodeArray = (CheckedTreeNode[])this.this$0.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null)) {
                CoverageSuite coverageSuite;
                Object object = checkedTreeNode.getUserObject();
                if (!(object instanceof CoverageSuite) || !(coverageSuite = (CoverageSuite)object).canRemove()) continue;
                this.this$0.myCoverageManager.removeCoverageSuite(coverageSuite);
                TreeUtil.removeLastPathComponent((JTree)this.this$0.mySuitesTree, (TreePath)new TreePath(checkedTreeNode.getPath()));
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                DeleteSuiteAction.a(1);
            }
            CheckedTreeNode[] checkedTreeNodeArray = (CheckedTreeNode[])this.this$0.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation = e10.getPresentation();
            presentation.setEnabled(false);
            for (CheckedTreeNode checkedTreeNode : checkedTreeNodeArray) {
                CoverageSuite coverageSuite;
                Object object = checkedTreeNode.getUserObject();
                if (!(object instanceof CoverageSuite) || !(coverageSuite = (CoverageSuite)object).canRemove()) continue;
                presentation.setEnabled(true);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x5B0D4A53829DL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$DeleteSuiteAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddExternalSuiteAction
    extends AnAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(-6437114240815740264L, -2523154378781038869L, MethodHandles.lookup().lookupClass()).a(13234368769503L);

        AddExternalSuiteAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x4D71CD7F66F5L;
            this.this$0 = coverageSuiteChooserDialog;
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), CommonBundle.message((String)"button.add", (Object[])new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)coverageSuiteChooserDialog.mySuitesTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            VirtualFile virtualFile;
            long l2 = a ^ 0x33392A56C9A7L;
            if (e10 == null) {
                AddExternalSuiteAction.a(0);
            }
            if ((virtualFile = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    return CoverageSuiteChooserDialog.a(file) != null;
                }
            }, (Project)this.this$0.myProject, null)) != null) {
                TreeNode treeNode;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                CoverageRunner coverageRunner = CoverageSuiteChooserDialog.a(virtualFile);
                if (coverageRunner == null) {
                    Messages.showErrorDialog((Project)this.this$0.myProject, (String)CoverageBundle.message("no.coverage.runner.available.for", virtualFile.getName()), (String)CommonBundle.getErrorTitle());
                    return;
                }
                CoverageSuite coverageSuite = this.this$0.myCoverageManager.addExternalCoverageSuite(virtualFile.getName(), virtualFile.getTimeStamp(), coverageRunner, new DefaultCoverageFileProvider(virtualFile.getPath()));
                String string = CoverageSuiteChooserDialog.a(coverageRunner);
                DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.this$0.myRootNode, (Object)string);
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                    this.this$0.myRootNode.add((MutableTreeNode)defaultMutableTreeNode);
                }
                if (defaultMutableTreeNode.getChildCount() > 0 && !((treeNode = defaultMutableTreeNode.getChildAt(0)) instanceof CheckedTreeNode)) {
                    if (CoverageSuiteChooserDialog.LOCAL.equals(((DefaultMutableTreeNode)treeNode).getUserObject())) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                    } else {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.LOCAL);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                    }
                }
                treeNode = new CheckedTreeNode((Object)coverageSuite);
                treeNode.setChecked(true);
                defaultMutableTreeNode.add((MutableTreeNode)treeNode);
                TreeUtil.sort((DefaultMutableTreeNode)defaultMutableTreeNode, (object, object2) -> {
                    if (object instanceof CheckedTreeNode && object2 instanceof CheckedTreeNode) {
                        Object object3 = ((CheckedTreeNode)object).getUserObject();
                        Object object4 = ((CheckedTreeNode)object2).getUserObject();
                        if (object3 instanceof CoverageSuite && object4 instanceof CoverageSuite) {
                            String string = ((CoverageSuite)object3).getPresentableName();
                            String string2 = ((CoverageSuite)object4).getPresentableName();
                            return string.compareToIgnoreCase(string2);
                        }
                    }
                    return 0;
                });
                this.this$0.a();
                TreeUtil.selectNode((JTree)this.this$0.mySuitesTree, (TreeNode)treeNode);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x10121E5892B5L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$AddExternalSuiteAction", "actionPerformed"));
        }
    }

    private class NoCoverageAction
    extends DialogWrapper.DialogWrapperAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(6870634211313478573L, 1941392929314575996L, MethodHandles.lookup().lookupClass()).a(50851640633409L);

        NoCoverageAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x92AF90BBBB2L;
            this.this$0 = coverageSuiteChooserDialog;
            super((DialogWrapper)coverageSuiteChooserDialog, CoverageBundle.message("coverage.data.no.coverage.button", new Object[0]));
        }

        protected void doAction(ActionEvent e10) {
            this.this$0.myCoverageManager.chooseSuitesBundle(null);
            this.this$0.close(0);
        }
    }

    private static class SuitesRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private SuitesRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object;
            if (value instanceof CheckedTreeNode) {
                Object object2 = ((CheckedTreeNode)value).getUserObject();
                if (object2 instanceof CoverageSuite) {
                    CoverageSuite coverageSuite = (CoverageSuite)object2;
                    this.getTextRenderer().append(coverageSuite.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String string = " (" + DateFormatUtil.formatPrettyDateTime((long)coverageSuite.getLastCoverageTimeStamp()) + ")";
                    this.getTextRenderer().append(string, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
                this.getTextRenderer().append((String)object);
            }
        }
    }
}

