/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.debugger.BasicDebuggerTest;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrDebuggingFixture<EXECUTION_FIXTURE extends CidrExecutionFixture<?>>
extends Assert {
    public static final Key<ArrayDeque<DebuggerState>> DEBUG_STATE_LOGS_KEY = Key.create((String)"DEBUG_STATE_LOGS_KEY");
    @Language(value="RegExp")
    public static final String HEX_ADDRESS_PATTERN_STRING = "0x\\p{XDigit}+";
    public static final int TIMEOUT = 60000;
    public static final int EVAL_TIMEOUT = 120000;
    public static final float EPSF = 0.001f;
    public static final double EPSD = 1.0E-5;
    protected EXECUTION_FIXTURE myExecutionFixture;
    protected boolean myDestroyPreviousProcessOnStart;
    protected XDebugSession mySession;
    protected CidrDebugProcess myDebugProcess;
    private final List<CidrDebugProcess> myAllProcesses;
    protected DebuggerDriver myDriver;
    protected DebuggerDriverConfiguration myDriverConfiguration;
    protected final EventDispatcher<DebuggerDriver.Handler> myDriverHandlerEventDispatcher;
    protected boolean isStarted;
    private final Disposable myDisposable;

    protected CidrDebuggingFixture(@NotNull EXECUTION_FIXTURE fixture) {
        if (fixture == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(0);
        }
        this.myDestroyPreviousProcessOnStart = true;
        this.myAllProcesses = new ArrayList<CidrDebugProcess>();
        this.myDriverHandlerEventDispatcher = EventDispatcher.create(DebuggerDriver.Handler.class);
        this.myDisposable = Disposer.newDisposable();
        this.myExecutionFixture = fixture;
    }

    public void setDestroyPreviousProcessOnStart(boolean destroyPreviousProcessOnStart) {
        this.myDestroyPreviousProcessOnStart = destroyPreviousProcessOnStart;
    }

    @NotNull
    public CidrToolEnvironment getEnvironment() {
        return new CidrToolEnvironment();
    }

    @NotNull
    public File getGdbserverExecutable() {
        throw new UnsupportedOperationException("Implement this method to enable remote debugging tests");
    }

    @NotNull
    protected String toAppEnvPath(@NotNull String path) {
        if (path == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(1);
        }
        String string = path;
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public abstract DebuggerDriverConfiguration createDriverConfiguration(@Nullable Function.Mono<GeneralCommandLine> var1);

    @NotNull
    protected abstract ArchitectureType getArchitectureType();

    public CidrDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public XDebugSession getSession() {
        return this.mySession;
    }

    public DebuggerDriver getDriver() {
        return this.myDriver;
    }

    public DebuggerDriverConfiguration getDriverConfiguration() {
        return this.myDriverConfiguration;
    }

    public void setUp() {
    }

    public abstract boolean supportsOCDebugging();

    public boolean supportsInputOutputOnWindows() {
        return true;
    }

    public static boolean shouldRunTest(DebuggerDriverKind driverKind, String testName, Class testClass) {
        String property = System.getProperty("cidr.test.disable" + driverKind.name());
        if ("true".equalsIgnoreCase(property)) {
            return false;
        }
        if ("nonBasic".equalsIgnoreCase(property)) {
            Method method = ReflectionUtil.getMethod((Class)testClass, (String)testName, (Class[])new Class[0]);
            return method != null && method.getAnnotation(BasicDebuggerTest.class) != null;
        }
        return true;
    }

    public BlockingQueue<DebuggerState> startDebugSession(XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(null, false, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(parameters, null, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(parameters, null, false, listeners);
    }

    protected BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)config -> config.setProgramParameters(parameters)), outputListener, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable Consumer<CidrRunConfiguration> configurator, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(configurator, null, false, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(((CidrExecutionFixture)((Object)this.myExecutionFixture)).createRunConfiguration(((CidrExecutionFixture)((Object)this.myExecutionFixture)).getConfigurationType(), configurator), null, outputListener, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSessionWithListener(@Nullable String parameters) throws Exception {
        return this.startDebugSession(parameters, false, new XDebugSessionListener[0]);
    }

    protected BlockingQueue<DebuggerState> startDebugSession(@NotNull RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget executionTarget, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        if (settings == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(3);
        }
        return this.doStartDebugSession(outputListener, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).startRunDebug((CidrRunProfile)((CidrRunConfiguration)settings.getConfiguration()), executionTarget, true, muteBreakpoints ? ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).DEBUG_STARTER_MUTED_BREAKS : ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).DEBUG_STARTER, (XDebugSessionListener[])ArrayUtil.append((Object[])listeners, (Object)listener))), true);
    }

    @NotNull
    private BlockingQueue<DebuggerState> doStartDebugSession(final @Nullable Consumer<Pair<String, Key>> outputListener, ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception> starter, boolean startNotify) throws Exception {
        ((CidrExecutionFixture)((Object)this.myExecutionFixture)).disposeSession();
        this.disposeSession(this.myDestroyPreviousProcessOnStart);
        ArrayDeque<DebuggerState> stateLog = new ArrayDeque<DebuggerState>();
        Pair<XDebugSessionListener, BlockingQueue<DebuggerState>> pair = this.createStateListener(stateLog);
        WriteAction.runAndWait(() -> this.configureDebugSessionSettings());
        this.mySession = (XDebugSession)starter.convert((Object)((XDebugSessionListener)pair.first));
        this.myDebugProcess = (CidrDebugProcess)this.mySession.getDebugProcess();
        this.myDebugProcess.putUserData(DEBUG_STATE_LOGS_KEY, stateLog);
        this.myDriver = this.myDebugProcess.getDriverInTests();
        ProcessHandler handler = this.myDebugProcess.getProcessHandler();
        if (outputListener != null) {
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    outputListener.consume((Object)Pair.create((Object)event.getText(), (Object)outputType));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (startNotify) {
            handler.startNotify();
        }
        this.validateDebugSessionDriver(this.myDriver);
        BlockingQueue blockingQueue = (BlockingQueue)pair.second;
        if (blockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(4);
        }
        return blockingQueue;
    }

    protected void configureDebugSessionSettings() {
    }

    protected abstract void validateDebugSessionDriver(@NotNull DebuggerDriver var1);

    public void startRerunDebugSession() {
        this.doStartRerunDebugSession();
        this.validateDebugSessionDriver(this.myDebugProcess.getDriverInTests());
    }

    protected void doStartRerunDebugSession() {
        throw new UnsupportedOperationException();
    }

    public BlockingQueue<DebuggerState> attachDebugSession(Project project2, @NotNull ProcessInfo processInfo) throws Exception {
        if (processInfo == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(5);
        }
        return this.doStartDebugSession(null, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> this.doAttachDebugSession(project2, processInfo, (XDebugSessionListener)listener)), false);
    }

    protected XDebugSession doAttachDebugSession(Project project2, ProcessInfo processInfo, XDebugSessionListener ... listeners) throws ExecutionException {
        return (XDebugSession)WriteAction.computeAndWait(() -> {
            CidrLocalAttachDebugger debugger = this.getLocalAttachDebugger(project2);
            return debugger.doAttachDebugSession(project2, processInfo, null, listeners);
        });
    }

    @NotNull
    protected CidrLocalAttachDebugger getLocalAttachDebugger(@NotNull Project project2) {
        if (project2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    public BlockingQueue<DebuggerState> createRemoteDebugSession(Project project2, @NotNull CidrRemoteDebugParameters params, XDebugSessionListener ... listeners) throws Exception {
        if (params == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(7);
        }
        return this.doStartDebugSession(null, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> this.doConnectRemoteDebugSession(project2, params, (XDebugSessionListener[])ArrayUtil.append((Object[])listeners, (Object)listener))), true);
    }

    @NotNull
    protected XDebugSession doConnectRemoteDebugSession(Project project2, CidrRemoteDebugParameters params, XDebugSessionListener ... listeners) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Pair<XDebugSessionListener, BlockingQueue<DebuggerState>> createStateListener(final ArrayDeque<DebuggerState> stateLog) {
        final LinkedBlockingQueue stateQueue = new LinkedBlockingQueue();
        XDebugSessionListener listener = new XDebugSessionListener(){

            public void sessionPaused() {
                this.postState(DebuggerState.PAUSED);
            }

            public void sessionResumed() {
                this.postState(DebuggerState.RESUMED);
            }

            public void sessionStopped() {
                this.postState(DebuggerState.STOPPED);
            }

            private void postState(@NotNull DebuggerState state) {
                if (state == null) {
                    2.$$$reportNull$$$0(0);
                }
                stateQueue.add(state);
                stateLog.add(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$2", "postState"));
            }
        };
        return Pair.create((Object)listener, stateQueue);
    }

    public void waitForDebuggerAndSwingEvents() throws InterruptedException {
        this.myDriver.waitHandlerProcessed();
        XDebuggerAssertions.waitForSwing();
    }

    public void checkStoppedOnBreakpoint(BlockingQueue<DebuggerState> state, VirtualFile file2, int line) throws InterruptedException, IOException {
        this.checkStoppedOnBreakpoint(state, file2, line, 60000L, null);
    }

    public void checkStoppedOnBreakpoint(BlockingQueue<DebuggerState> state, VirtualFile file2, int line, @Nullable Long timeout, @Nullable Consumer<? super XDebugSession> additionalChecks) throws InterruptedException, IOException {
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.PAUSED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.mySession, (VirtualFile)file2, (int)line);
        if (additionalChecks != null) {
            additionalChecks.consume((Object)this.mySession);
        }
        this.mySession.resume();
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.RESUMED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.STOPPED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        CidrDebuggingFixture.assertEquals((long)0L, (long)state.size());
    }

    private static void destroyProcess(CidrDebugProcess process) {
        ProcessHandler h = process.getProcessHandler();
        h.destroyProcess();
        if (!CidrExecutionFixture.waitFor(h)) {
            new Throwable("Cannot stop debugger process").printStackTrace();
        }
        XDebuggerAssertions.disposeDebugSession((XDebugSession)process.getSession());
        ArrayDeque log = (ArrayDeque)process.getUserData(DEBUG_STATE_LOGS_KEY);
        if (log != null) {
            DebuggerState s;
            DebuggerState debuggerState = s = log.size() > 0 ? (DebuggerState)log.poll() : null;
            while (s != null && s != DebuggerState.STOPPED) {
                s = log.size() > 0 ? (DebuggerState)log.poll() : null;
            }
            log.clear();
        }
    }

    public boolean waitForProcessHandler() {
        if (this.myDebugProcess != null) {
            return CidrExecutionFixture.waitFor(this.myDebugProcess.getProcessHandler());
        }
        return ((CidrExecutionFixture)((Object)this.myExecutionFixture)).waitForProcessHandler();
    }

    public void disposeSession(boolean destroyProcess) {
        if (this.myDebugProcess != null) {
            if (destroyProcess) {
                CidrDebuggingFixture.destroyProcess(this.myDebugProcess);
            } else {
                this.myAllProcesses.add(this.myDebugProcess);
            }
            this.myDebugProcess = null;
            this.myDriver = null;
        }
    }

    public void tearDown() {
        this.disposeSession(true);
        Disposer.dispose((Disposable)this.myDisposable);
        for (CidrDebugProcess each : this.myAllProcesses) {
            CidrDebuggingFixture.destroyProcess(each);
        }
        this.myAllProcesses.clear();
        this.clearBreakpoints();
    }

    protected void clearBreakpoints() {
        Object projectFixture = ((CidrExecutionFixture)((Object)this.myExecutionFixture)).getProjectFixture();
        if (((CidrProjectFixture)projectFixture).isProjectInitialized()) {
            Project project2 = ((CidrProjectFixture)projectFixture).getProject();
            XDebuggerAssertions.removeAllBreakpoints((Project)project2);
        }
    }

    @Contract(value="_, _, !null -> !null; _, _, null ->  null")
    protected <T> BlockingQueue<? extends T> startDriver(@Nullable DebuggerDriver.Handler handler, @Nullable Function.Mono<GeneralCommandLine> driverCommandLineConfigurator, @Nullable Function<DriverEvent, T> eventFilter) throws ExecutionException {
        this.stopDebugDriver();
        if (handler != null) {
            this.addDriverHandler(handler);
        }
        this.myDriverConfiguration = this.createDriverConfiguration(driverCommandLineConfigurator);
        this.myDriver = this.createDriver(this.myDriverConfiguration);
        this.myDriver.setRedirectOutputToFiles(true);
        this.myDriver.getProcessHandler().startNotify();
        this.isStarted = true;
        return this.spyOnDriverEvents(event -> {
            Object result = eventFilter == null ? null : eventFilter.apply((DriverEvent)event);
            CidrDebuggerLog.LOG.debug((result == null ? "\u25cb" : "\u25cf") + " " + event + (String)(result == null || result == event ? "" : " \u25b6\u25b6\u25b6 " + result));
            return result;
        }, eventFilter == null ? null : new LinkedBlockingQueue());
    }

    protected void stopDebugDriver() throws ExecutionException {
        if (this.myDriver != null && this.isStarted) {
            BaseProcessHandler processHandler = this.myDriver.getProcessHandler();
            processHandler.destroyProcess();
            if (!processHandler.waitFor(3000L)) {
                CidrDebuggerLog.LOG.warn("cannot destroy driver process, killing...");
                Process process = processHandler.getProcess();
                if (OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                    if (!processHandler.waitFor(1000L)) {
                        CidrDebuggerLog.LOG.warn("cannot kill driver process.");
                    }
                }
            }
            this.isStarted = false;
            this.myDriver.checkErrors();
        }
    }

    @NotNull
    protected DebuggerDriver createDriver(@NotNull DebuggerDriverConfiguration configuration2) throws ExecutionException {
        if (configuration2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(8);
        }
        DebuggerDriver debuggerDriver = configuration2.createDriver((DebuggerDriver.Handler)this.myDriverHandlerEventDispatcher.getMulticaster(), this.getArchitectureType());
        if (debuggerDriver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(9);
        }
        return debuggerDriver;
    }

    protected void addDriverHandler(@NotNull DebuggerDriver.Handler handler) {
        if (handler == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(10);
        }
        this.myDriverHandlerEventDispatcher.addListener((EventListener)handler, this.myDisposable);
    }

    @NotNull
    protected <T> BlockingQueue<T> spyOnDriverEvents(@NotNull Function<DriverEvent, T> filter) {
        if (filter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(11);
        }
        BlockingQueue<T> blockingQueue = this.spyOnDriverEvents(filter, new LinkedBlockingQueue());
        if (blockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(12);
        }
        return blockingQueue;
    }

    @Contract(value="_, !null -> !null; _,  null ->  null")
    protected <T> BlockingQueue<T> spyOnDriverEvents(final @NotNull Function<DriverEvent, T> filter, final @Nullable BlockingQueue<T> stopPlaces) {
        if (filter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(13);
        }
        this.addDriverHandler(new CidrDebuggerTestCase.NullHandler(){

            private void handleDriverEvent(@NotNull DriverEvent event) {
                Object result;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((result = filter.apply(event)) != null && stopPlaces != null) {
                    stopPlaces.add(result);
                }
            }

            public void handleRunning() {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.RUNNING));
            }

            public void handleTargetFinished(int code, @Nullable String description) {
                this.handleDriverEvent(new DriverFinishedEvent(DriverEvent.Kind.FINISHED, code, description));
            }

            public void handleTargetTerminated() {
                this.handleDriverEvent(new DriverFinishedEvent(DriverEvent.Kind.TERMINATED, -1));
            }

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.handleDriverEvent(new DriverCodepointEvent(DriverEvent.Kind.BREAKPOINT, stopPlace, breakpointNumber));
            }

            public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.handleDriverEvent(new DriverCodepointEvent(DriverEvent.Kind.WATCHPOINT, stopPlace, watchpointNumber));
            }

            @Override
            public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (signal == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (meaning == null) {
                    3.$$$reportNull$$$0(5);
                }
                this.handleDriverEvent(new DriverSuspendEvent(DriverEvent.Kind.SIGNAL, stopPlace, signal, meaning));
            }

            public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (exceptionAddress == null) {
                    3.$$$reportNull$$$0(7);
                }
                if (description == null) {
                    3.$$$reportNull$$$0(8);
                }
                this.handleDriverEvent(new DriverExceptionEvent(DriverEvent.Kind.EXCEPTION, stopPlace, description, exceptionAddress, exceptionFile, exceptionHash, exceptionLine));
            }

            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(9);
                }
                this.handleDriverEvent(new DriverSuspendEvent(DriverEvent.Kind.INTERRUPTED, stopPlace));
            }

            public void handleExited(int code) {
                this.handleDriverEvent(new DriverFinishedEvent(DriverEvent.Kind.DEBUGGER_EXITED, code));
            }

            public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(10);
                }
                this.handleDriverEvent(new DriverBreakpointChangedEvent(DriverEvent.Kind.BREAKPOINT_UPDATED, breakpoint));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stopPlace";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signal";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "meaning";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exceptionAddress";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "breakpoint";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleDriverEvent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleBreakpoint";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleWatchpoint";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleSignal";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleException";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInterrupted";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleBreakpointUpdated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return stopPlaces;
    }

    @NotNull
    protected BlockingQueue<String> spyOnOutputLines() {
        final LinkedBlockingQueue<String> linesQueue = new LinkedBlockingQueue<String>();
        final StringBuilder lineBuilder = new StringBuilder();
        this.addDriverHandler(new CidrDebuggerTestCase.NullHandler(){

            public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
                if (text == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    4.$$$reportNull$$$0(1);
                }
                String[] lines = text.split("(?<=\\n)", -1);
                assert (lines.length > 0);
                if (lines.length > 1) {
                    lines[0] = lineBuilder.append(lines[0]).toString();
                    lineBuilder.setLength(0);
                    linesQueue.addAll(Arrays.asList(lines).subList(0, lines.length - 1));
                }
                lineBuilder.append(lines[lines.length - 1]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$4";
                objectArray[2] = "handleDebuggerOutput";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedBlockingQueue<String> linkedBlockingQueue = linesQueue;
        if (linkedBlockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(14);
        }
        return linkedBlockingQueue;
    }

    public String getConsoleText(ConsoleViewImpl consoleView) {
        this.myDebugProcess.getDriverInTests().waitHandlerProcessed();
        return XDebuggerTestUtil.getConsoleText((ConsoleViewImpl)consoleView);
    }

    public String getConsoleText() {
        return this.getConsoleText((ConsoleViewImpl)this.mySession.getConsoleView());
    }

    public void assertConsoleTextMatches(@RegExp String pattern) {
        this.assertConsoleTextMatches(pattern, 32);
    }

    public void assertConsoleTextMatches(@RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCase.assertMatches(this.getConsoleText(), pattern, flags);
    }

    public void assertConsoleTextEndsWith(String text) {
        String consoleText = this.getConsoleText();
        CidrDebuggingFixture.assertTrue((String)consoleText, (boolean)consoleText.endsWith(text));
    }

    public String getDebuggerConsoleText() {
        return this.getConsoleText((ConsoleViewImpl)this.myDebugProcess.getDebuggerConsole());
    }

    public void assertDebuggerConsoleTextMatches(@RegExp String pattern) {
        this.assertDebuggerConsoleTextMatches(pattern, 32);
    }

    public void assertDebuggerConsoleTextMatches(@RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCase.assertMatches(this.getDebuggerConsoleText(), pattern, flags);
    }

    public List<XStackFrame> collectFrames() {
        return XDebuggerTestUtil.collectFrames((XDebugSession)this.getSession());
    }

    public List<XStackFrame> collectFrames(@Nullable XExecutionStack stack) {
        return XDebuggerTestUtil.collectFrames((XExecutionStack)stack, (XDebugSession)this.getSession());
    }

    protected XStackFrame getMainFunctionFrame(List<XStackFrame> frames) {
        return this.findMainFunctionFrame(frames, true);
    }

    @Contract(value="_, true -> !null")
    protected CidrStackFrame findMainFunctionFrame(List<XStackFrame> frames, boolean makeAssertion) {
        return this.findFrame(frames, "main", makeAssertion);
    }

    @NotNull
    public CidrStackFrame findFrame(List<XStackFrame> frames, String functionName) {
        CidrStackFrame cidrStackFrame = this.findFrame(frames, functionName, true);
        if (cidrStackFrame == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(15);
        }
        return cidrStackFrame;
    }

    @NotNull
    public CidrStackFrame findFrameMatching(List<XStackFrame> frames, @RegExp String functionName) {
        CidrStackFrame cidrStackFrame = this.findFrameMatching(frames, functionName, true);
        if (cidrStackFrame == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(16);
        }
        return cidrStackFrame;
    }

    @Contract(value="_, _, true -> !null")
    public CidrStackFrame findFrameMatching(List<XStackFrame> frames, @RegExp String functionName, boolean makeAssertion) {
        for (XStackFrame eachFrame : frames) {
            LLFrame frame = ((CidrStackFrame)eachFrame).getFrame();
            if (!frame.getFunction().matches(functionName)) continue;
            return (CidrStackFrame)eachFrame;
        }
        if (makeAssertion) {
            CidrDebuggingFixture.fail((String)("'" + functionName + "' frame not found among:\n" + StringUtil.join(frames, (String)"\n")));
        }
        return null;
    }

    @Contract(value="_, _, true -> !null")
    public CidrStackFrame findFrame(List<XStackFrame> frames, String functionName, boolean makeAssertion) {
        for (XStackFrame eachFrame : frames) {
            LLFrame frame = ((CidrStackFrame)eachFrame).getFrame();
            if (!functionName.equals(frame.getFunction())) continue;
            return (CidrStackFrame)eachFrame;
        }
        if (makeAssertion) {
            CidrDebuggingFixture.fail((String)("'" + functionName + "' frame not found among:\n" + StringUtil.join(frames, (String)"\n")));
        }
        return null;
    }

    public static void assertVarCollectingError(XStackFrame frame, String expectedError) {
        Pair result = XDebuggerAssertions.collectChildrenWithError((XValueContainer)frame);
        CidrDebuggingFixture.assertEquals((Object)expectedError, (Object)result.second);
        UsefulTestCase.assertEmpty((Collection)result.first);
    }

    public static void assertFramePresentationMatches(XStackFrame stackFrame, @Nullable @RegExp String expected) {
        CidrTestCase.assertMatches(CidrDebuggingFixture.computeFramePresentation(stackFrame), expected);
    }

    @NotNull
    public static String computeFramePresentation(XStackFrame stackFrame) {
        String string = XDebuggerAssertions.getFramePresentation((XStackFrame)stackFrame);
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void assertBreakpoint(LLBreakpoint b, int id, String file2, int line) {
        CidrDebuggingFixture.assertBreakpoint(b, id, file2, line, null, null);
    }

    protected static void assertBreakpoint(LLBreakpoint b, int id, String file2, int line, @NotNull List<LLBreakpointLocation> locations, @Nullable String condition) {
        if (locations == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(18);
        }
        CidrDebuggingFixture.assertEquals((Object)new LLBreakpoint(id, file2, line, locations, condition), (Object)b);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull Address address) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(19);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(20);
        }
        if (address == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(21);
        }
        CidrDebuggingFixture.assertEquals((Object)location.getId(), (Object)id);
        CidrDebuggingFixture.assertEquals((Object)location.getAddress(), (Object)address);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull LLBreakpointLocation.FileLocation fileLocation) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(22);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(23);
        }
        if (fileLocation == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(24);
        }
        CidrDebuggingFixture.assertEquals((Object)location.getId(), (Object)id);
        CidrDebuggingFixture.assertEquals((Object)location.getFileLocation(), (Object)fileLocation);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull String file2, int line) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(25);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(27);
        }
        CidrDebuggingFixture.assertBreakpointLocation(location, id, new LLBreakpointLocation.FileLocation(file2, line));
    }

    public static void assertResultList(DebuggerDriver.ResultList<?> result, int expectedSize, boolean hasMore) {
        UsefulTestCase.assertSize(expectedSize, result.list);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)result.hasMore);
    }

    public static void assertResultList(DebuggerDriver.ResultList<?> result, int expectedSizeMin, int expectedSizeMax, boolean hasMore) {
        int size = result.list.size();
        TestCase.assertTrue((String)("Size : " + size), (size >= expectedSizeMin && size <= expectedSizeMax ? 1 : 0) != 0);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)result.hasMore);
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean mayHaveChildren, @Nullable Ref<Integer> childrenCount, @Nullable Boolean isStruct, @Nullable Boolean isValid) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(28);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(29);
        }
        LLValueData data = driver.getData(val);
        String message = val.toString() + " = " + data;
        if (name != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)name, (Object)val.getName());
        }
        if (type != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)type, (Object)val.getType());
        }
        if (mayHaveChildren != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)mayHaveChildren, (Object)data.mayHaveChildren());
        }
        if (childrenCount != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)childrenCount.get(), (Object)driver.getChildrenCount(val));
        }
        if (isStruct != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)isStruct, (Object)(val.getTypeClass() == LLValue.TypeClass.CLASS_STRUCT ? 1 : 0));
        }
        if (isValid != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)isValid, (Object)val.isValid());
        }
        if (value != null) {
            if ("float".equals(type)) {
                CidrDebuggingFixture.assertEquals((String)message, (float)Float.parseFloat(value), (float)Float.parseFloat(data.getValue()), (float)0.001f);
            } else if ("double".equals(type)) {
                CidrDebuggingFixture.assertEquals((String)message, (double)Double.parseDouble(value), (double)Double.parseDouble(data.getValue()), (double)1.0E-5);
            } else {
                CidrDebuggingFixture.assertEquals((String)message, (Object)value, (Object)data.getValue());
            }
        }
    }

    public static void assertLLValuePresentableValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String expected) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(30);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(31);
        }
        LLValueData data = driver.getData(val);
        String message = val.toString() + " = " + data;
        CidrDebuggingFixture.assertEquals((String)message, (Object)expected, (Object)data.getPresentableValue());
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean mayHaveChildren, int childrenCount) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(32);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(33);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value, mayHaveChildren, (Ref<Integer>)Ref.create((Object)childrenCount));
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean mayHaveChildren, @Nullable Ref<Integer> childrenCount) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(34);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(35);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value, mayHaveChildren, childrenCount, null, true);
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean mayHaveChildren, int childrenCount, boolean isStruct) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(36);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(37);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value, mayHaveChildren, (Ref<Integer>)Ref.create((Object)childrenCount), isStruct, true);
    }

    public static void assertLLValues(DebuggerDriver.ResultList<LLValue> childrenResult, boolean hasMore, String ... expectedNames) {
        UsefulTestCase.assertOrderedEquals(ContainerUtil.map((Collection)childrenResult.list, value -> value.getName()), expectedNames);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)childrenResult.hasMore);
    }

    public static void assertUnorderedLLValues(DebuggerDriver.ResultList<LLValue> childrenResult, boolean hasMore, String ... expectedNames) {
        CidrDebuggingFixture.assertUnorderedLLValues(childrenResult.list, expectedNames);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)childrenResult.hasMore);
    }

    public static void assertUnorderedLLValues(List<LLValue> list, String ... expectedNames) {
        UsefulTestCase.assertSameElements(ContainerUtil.map(list, value -> value.getName()), expectedNames);
    }

    public Pair<XValue, String> evaluate(String expression) {
        return XDebuggerTestUtil.evaluate((XDebugSession)this.getSession(), (String)expression, (long)120000L);
    }

    @NotNull
    public static XValue findVar(Collection<XValue> vars, String name) {
        XValue xValue = XDebuggerTestUtil.findVar(vars, (String)name);
        if (xValue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(38);
        }
        return xValue;
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        String message = frame.toString();
        if (frameNum != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid frame number for " + message), (long)frameNum.intValue(), (long)frame.getIndex());
        }
        if (fileName != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid file name for " + message), (Object)fileName, (Object)frame.getFile());
        }
        if (lineNum != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid line for " + message), (long)lineNum.intValue(), (long)frame.getLine());
        }
        if (funcPattern != null) {
            CidrDebuggingFixture.assertTrue((String)("Invalid frame func name  for " + message + "\nExpected: " + funcPattern + "\nActual: " + frame.getFunction() + "\n"), (boolean)frame.getFunction().matches(funcPattern));
        }
        if (hasProgramCounter) {
            CidrDebuggingFixture.assertFalse((String)("Missing program counter for " + message), (boolean)frame.getProgramCounter().isNull());
        } else {
            CidrDebuggingFixture.assertTrue((String)("Program counter should not be specified for " + message), (boolean)frame.getProgramCounter().isNull());
        }
    }

    public List<XExecutionStack> collectThreads() {
        return XDebuggerTestUtil.collectThreads((XDebugSession)this.getSession());
    }

    @NotNull
    protected XExecutionStack getMainThread(List<XExecutionStack> threads) {
        if (SystemInfo.isMac) {
            for (XExecutionStack each : threads) {
                if (this.findMainFunctionFrame(this.collectFrames(each), false) == null) continue;
                XExecutionStack xExecutionStack = each;
                if (xExecutionStack == null) {
                    CidrDebuggingFixture.$$$reportNull$$$0(39);
                }
                return xExecutionStack;
            }
        }
        for (XExecutionStack each : threads) {
            if (!each.getDisplayName().contains("com.apple.main-thread")) continue;
            XExecutionStack xExecutionStack = each;
            if (xExecutionStack == null) {
                CidrDebuggingFixture.$$$reportNull$$$0(40);
            }
            return xExecutionStack;
        }
        CidrDebuggingFixture.fail((String)("Main thread not found in " + threads));
        throw new RuntimeException();
    }

    public static LLValue findVariable(String name, Collection<LLValue> vars) {
        for (LLValue each : vars) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    public static <T> T waitFor(BlockingQueue<T> q) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, 60000L);
    }

    public static <T> T waitFor(BlockingQueue<T> q, Long timeout) throws InterruptedException {
        return timeout == null ? CidrExecutionFixture.waitFor(q, 60000L) : CidrExecutionFixture.waitFor(q, (long)timeout);
    }

    public static <T> T waitFor(BlockingQueue<T> q, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, timeout);
    }

    public static <T> T waitFor(FutureResult<T> f) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, 60000L);
    }

    public static boolean waitFor(Semaphore s) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, 60000L);
    }

    public static boolean waitFor(Semaphore s, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, timeout);
    }

    public static <T> T waitFor(FutureResult<T> f, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, timeout);
    }

    public static boolean waitFor(ProcessHandler p) {
        return CidrExecutionFixture.waitFor(p, 60000L);
    }

    public static boolean waitFor(ProcessHandler p, long timeout) {
        return CidrExecutionFixture.waitFor(p, timeout);
    }

    @NotNull
    public static String waitOrDrainUntilLine(@NotNull BlockingQueue<String> lines, @NotNull Pattern pattern) throws InterruptedException {
        if (lines == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(41);
        }
        if (pattern == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(42);
        }
        return CidrDebuggingFixture.waitOrDrainUntilLine(lines, pattern, 60000);
    }

    @NotNull
    public static String waitOrDrainUntilLine(@NotNull BlockingQueue<String> lines, @NotNull Pattern pattern, int timeout) throws InterruptedException {
        String line;
        if (lines == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(43);
        }
        if (pattern == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(44);
        }
        do {
            line = CidrDebuggingFixture.waitFor(lines, (long)timeout);
            TestCase.assertNotNull((String)("Timed out waiting for line matching: " + pattern), (Object)line);
        } while (!pattern.matcher(line).matches());
        String string = line;
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static <T, R> R waitForEvent(@NotNull BlockingQueue<? extends T> events, @NotNull Function<T, R> filter) throws InterruptedException {
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(46);
        }
        if (filter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(47);
        }
        return CidrDebuggingFixture.waitForEvent(events, filter, 60000L);
    }

    @NotNull
    protected static <T, R> R waitForEvent(@NotNull BlockingQueue<? extends T> events, @NotNull Function<T, R> filter, long timeout) throws InterruptedException {
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(48);
        }
        if (filter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(49);
        }
        T event = CidrExecutionFixture.waitFor(events, timeout);
        TestCase.assertNotNull((String)("Expected " + filter + ": timed out"), event);
        return CidrDebuggingFixture.assertEvent(event, filter);
    }

    @NotNull
    public static <T, R> R assertEvent(@NotNull T event, @NotNull Function<T, R> filter) {
        R result;
        if (event == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(50);
        }
        if (filter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(51);
        }
        if ((result = filter.apply(event)) == null) {
            TestCase.fail((String)("Expected " + filter + ": got " + event));
        }
        R r = result;
        if (r == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(52);
        }
        return r;
    }

    public static <T> void assertNoMoreEvents(@NotNull BlockingQueue<T> events, long timeout) throws InterruptedException {
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(53);
        }
        T event = CidrExecutionFixture.waitFor(events, timeout);
        TestCase.assertNull((String)"No more driver events expected", event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 11: 
            case 13: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLocation";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 46: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toAppEnvPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartDebugSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnDriverEvents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnOutputLines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findFrame";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findFrameMatching";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFramePresentation";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findVar";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainThread";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "waitOrDrainUntilLine";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "assertEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toAppEnvPath";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startDebugSession";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachDebugSession";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAttachDebugger";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteDebugSession";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDriverHandler";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "spyOnDriverEvents";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "assertBreakpoint";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "assertBreakpointLocation";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "assertLLValue";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertLLValuePresentableValue";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "waitOrDrainUntilLine";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "waitForEvent";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "assertEvent";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "assertNoMoreEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DriverFinishedEvent
    extends DriverEvent {
        public final int exitCode;

        public DriverFinishedEvent(@NotNull DriverEvent.Kind<? extends DriverFinishedEvent> kind, int exitCode) {
            if (kind == null) {
                DriverFinishedEvent.$$$reportNull$$$0(0);
            }
            this(kind, exitCode, null);
        }

        public DriverFinishedEvent(@NotNull DriverEvent.Kind<? extends DriverFinishedEvent> kind, int exitCode, @Nullable String description) {
            if (kind == null) {
                DriverFinishedEvent.$$$reportNull$$$0(1);
            }
            super(kind, null, description);
            this.exitCode = exitCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverFinishedEvent", "<init>"));
        }
    }

    public static class DriverBreakpointChangedEvent
    extends DriverEvent {
        @NotNull
        public final LLBreakpoint breakpoint;

        public DriverBreakpointChangedEvent(@NotNull DriverEvent.Kind<? extends DriverBreakpointChangedEvent> kind, @NotNull LLBreakpoint breakpoint) {
            if (kind == null) {
                DriverBreakpointChangedEvent.$$$reportNull$$$0(0);
            }
            if (breakpoint == null) {
                DriverBreakpointChangedEvent.$$$reportNull$$$0(1);
            }
            super(kind);
            this.breakpoint = breakpoint;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.breakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "breakpoint";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverBreakpointChangedEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverCodepointEvent
    extends DriverSuspendEvent {
        public final int number;

        public DriverCodepointEvent(@NotNull DriverEvent.Kind<? extends DriverCodepointEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, int number) {
            if (kind == null) {
                DriverCodepointEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverCodepointEvent.$$$reportNull$$$0(1);
            }
            super(kind, stopPlace);
            this.number = number;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverCodepointEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverExceptionEvent
    extends DriverSuspendEvent {
        @Nullable
        public final Address exceptionAddress;
        @Nullable
        public final String exceptionFile;
        @Nullable
        public final DebuggerSourceFileHash exceptionHash;
        public final int exceptionLine;

        public DriverExceptionEvent(@NotNull DriverEvent.Kind<? extends DriverExceptionEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable String description, @Nullable Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine) {
            if (kind == null) {
                DriverExceptionEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverExceptionEvent.$$$reportNull$$$0(1);
            }
            super(kind, stopPlace, null, description);
            this.exceptionAddress = exceptionAddress;
            this.exceptionFile = exceptionFile;
            this.exceptionHash = exceptionHash;
            this.exceptionLine = exceptionLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverExceptionEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverSuspendEvent
    extends DriverEvent {
        @NotNull
        public final DebuggerDriver.StopPlace stopPlace;

        public DriverSuspendEvent(@NotNull DriverEvent.Kind<? extends DriverSuspendEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace) {
            if (kind == null) {
                DriverSuspendEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverSuspendEvent.$$$reportNull$$$0(1);
            }
            this(kind, stopPlace, null, null);
        }

        public DriverSuspendEvent(@NotNull DriverEvent.Kind<? extends DriverSuspendEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable String name, @Nullable String description) {
            if (kind == null) {
                DriverSuspendEvent.$$$reportNull$$$0(2);
            }
            if (stopPlace == null) {
                DriverSuspendEvent.$$$reportNull$$$0(3);
            }
            super(kind, name, description);
            this.stopPlace = stopPlace;
        }

        @Override
        public String toString() {
            return super.toString() + "@" + this.stopPlace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverSuspendEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverEvent {
        @NotNull
        public final Kind<?> kind;
        @NotNull
        public final String name;
        @Nullable
        public final String description;

        public DriverEvent(@NotNull Kind<?> kind) {
            if (kind == null) {
                DriverEvent.$$$reportNull$$$0(0);
            }
            this(kind, null, null);
        }

        public DriverEvent(@NotNull Kind<?> kind, @Nullable String name, @Nullable String description) {
            if (kind == null) {
                DriverEvent.$$$reportNull$$$0(1);
            }
            this.kind = kind;
            this.name = (String)ObjectUtils.notNull((Object)name, (Object)kind.name);
            this.description = description;
        }

        public String toString() {
            String info = StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{this.name.equals(this.kind.name) ? null : this.name, this.description == null ? null : " @" + this.description}), (String)": ");
            return this.kind + (String)(info.isEmpty() ? "" : " (" + info + ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverEvent", "<init>"));
        }

        public static class Kind<T extends DriverEvent>
        implements Filter<DriverEvent, T> {
            public static final Kind<DriverEvent> RUNNING = new Kind("RUNNING");
            public static final Kind<DriverFinishedEvent> FINISHED = new Kind("FINISHED");
            public static final Kind<DriverFinishedEvent> TERMINATED = new Kind("TERMINATED");
            public static final Kind<DriverCodepointEvent> BREAKPOINT = new Kind("BREAKPOINT");
            public static final Kind<DriverCodepointEvent> WATCHPOINT = new Kind("WATCHPOINT");
            public static final Kind<DriverSuspendEvent> SIGNAL = new Kind("SIGNAL");
            public static final Kind<DriverExceptionEvent> EXCEPTION = new Kind("EXCEPTION");
            public static final Kind<DriverSuspendEvent> INTERRUPTED = new Kind("INTERRUPTED");
            public static final Kind<DriverFinishedEvent> DEBUGGER_EXITED = new Kind("DEBUGGER_EXITED");
            public static final Kind<DriverBreakpointChangedEvent> BREAKPOINT_UPDATED = new Kind("BREAKPOINT_UPDATED");
            @NotNull
            private final String name;

            public Kind(@NotNull String name) {
                if (name == null) {
                    Kind.$$$reportNull$$$0(0);
                }
                this.name = name;
            }

            @SafeVarargs
            @NotNull
            public static <T extends DriverEvent> Filter<T, T> anyOf(final Kind<? extends T> ... eventKinds) {
                if (eventKinds == null) {
                    Kind.$$$reportNull$$$0(1);
                }
                return new Filter<T, T>(){

                    @Override
                    public T apply(@Nullable DriverEvent event) {
                        return event != null && ArrayUtil.contains(event.kind, (Object[])eventKinds) ? event : null;
                    }

                    public String toString() {
                        return Arrays.toString(eventKinds);
                    }
                };
            }

            @Override
            public T apply(@Nullable DriverEvent event) {
                return (T)(event != null && event.kind == this ? event : null);
            }

            public String toString() {
                return this.name;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "eventKinds";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverEvent$Kind";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "anyOf";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface Filter<T, R>
    extends Function<T, R> {
        @Override
        @NotNull
        default public <V> Filter<T, V> andThen(@NotNull Function<? super R, ? extends V> after2) {
            if (after2 == null) {
                Filter.$$$reportNull$$$0(0);
            }
            Filter filter = t -> {
                Object result = this.apply(t);
                return result == null ? null : after2.apply((R)result);
            };
            if (filter == null) {
                Filter.$$$reportNull$$$0(1);
            }
            return filter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "after";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$Filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$Filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "andThen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "andThen";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DebuggerState implements Function<DebuggerState, DebuggerState>
    {
        PAUSED,
        RESUMED,
        STOPPED;


        @Override
        public DebuggerState apply(DebuggerState state) {
            return state == this ? state : null;
        }
    }
}

