/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.impl.util.CssCompatibilityData;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.BrowserCompatibilityForm;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssBrowserCompatibilityForPropertiesInspection
extends CssBaseInspection {
    public boolean myCheckChrome = true;
    public int myChromeVersion = 71;
    public boolean myCheckEdge = true;
    public int myEdgeVersion = 18;
    public boolean myCheckFirefox = true;
    public int myFirefoxVersion = 64;
    public boolean myCheckIE = true;
    public int myIEVersion = 11;
    public boolean myCheckOpera = true;
    public int myOperaVersion = 57;
    public boolean myCheckSafari = true;
    public int mySafariVersion = 12;

    @Nullable
    public JComponent createOptionsPanel() {
        return new BrowserCompatibilityForm(this).getMainPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(0);
        }
        if (!(this.myCheckChrome || this.myCheckEdge || this.myCheckFirefox || this.myCheckIE || this.myCheckOpera || this.myCheckSafari)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                String dialectName;
                if (!(declaration.getParent() instanceof CssBlock) || !(declaration.getParent().getParent() instanceof CssRuleset)) {
                    return;
                }
                if (declaration.isCustomProperty()) {
                    return;
                }
                PsiElement propertyNameElement = declaration.getPropertyNameElement();
                if (propertyNameElement == null) {
                    return;
                }
                if (!CssInspectionsUtil.isPureCssPropertyName(propertyNameElement)) {
                    return;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                    return;
                }
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)declaration);
                if (descriptorProvider != null && descriptorProvider.skipCssPropertyCheck(declaration)) {
                    return;
                }
                if (!(descriptorProvider != null && descriptorProvider.providesClassicCss() || (dialectName = (String)CssDialectMappings.getInstance(declaration.getProject()).getMapping(declaration.getContainingFile().getVirtualFile())) == null || dialectName.equals(CssDialect.CLASSIC.getName()))) {
                    return;
                }
                String propertyName = declaration.getPropertyName();
                if (descriptorProvider != null) {
                    propertyName = descriptorProvider.restoreFullPropertyName(propertyName, propertyNameElement);
                }
                CssBrowserCompatibilityForPropertiesInspection.this.checkProperty(holder, propertyNameElement, propertyName);
            }
        };
    }

    private void checkProperty(@NotNull ProblemsHolder holder, @NotNull PsiElement propertyNameElement, @NotNull String propertyName) {
        if (holder == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(2);
        }
        if (propertyNameElement == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(3);
        }
        if (propertyName == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(4);
        }
        if (CssPropertyUtil.isVendorSpecificElement(propertyName)) {
            return;
        }
        BrowserVersion[] browsers = CssCompatibilityData.getBrowsersDataForProperty((String)propertyName);
        if (browsers.length == 0) {
            holder.registerProblem(propertyNameElement, CssBundle.message((String)"no.mdn.data.for.property", (Object[])new Object[]{propertyName}), new LocalQuickFix[0]);
            return;
        }
        ArrayList incompatible = new ArrayList();
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckChrome, this.myChromeVersion, BrowserVersion.Browser.CHROME, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckEdge, this.myEdgeVersion, BrowserVersion.Browser.EDGE, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckFirefox, this.myFirefoxVersion, BrowserVersion.Browser.FIREFOX, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckIE, this.myIEVersion, BrowserVersion.Browser.IE, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckOpera, this.myOperaVersion, BrowserVersion.Browser.OPERA, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckSafari, this.mySafariVersion, BrowserVersion.Browser.SAFARI, browsers));
        if (!incompatible.isEmpty()) {
            holder.registerProblem(propertyNameElement, CssBundle.message((String)"property.not.supported.by.some.browsers", (Object[])new Object[]{propertyName, StringUtil.join(incompatible, (String)", ")}), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static String getBrowserTextIfIncompatible(boolean check, int versionToCheck, BrowserVersion.Browser browser, BrowserVersion[] browserVersions) {
        if (!check) {
            return null;
        }
        BrowserVersion browserVersion = (BrowserVersion)ContainerUtil.find((Object[])browserVersions, b -> b.getBrowser() == browser);
        if (browserVersion == null) {
            return browser.getPresentableName() + " " + versionToCheck;
        }
        String supportedSinceVersion = browserVersion.getVersion();
        if (supportedSinceVersion.isEmpty() || supportedSinceVersion.equals("true")) {
            return null;
        }
        if (StringUtil.compareVersionNumbers((String)String.valueOf(versionToCheck), (String)supportedSinceVersion) < 0) {
            return browser.getPresentableName() + " " + versionToCheck;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssBrowserCompatibilityForPropertiesInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssBrowserCompatibilityForPropertiesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

