/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.formatter.CoffeeScriptQuoteHandler;

public class CoffeeScriptBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE != file.getFileType() || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (c == '`' && offset < editor.getDocument().getTextLength()) {
            CoffeeScriptQuoteHandler quoteHandler;
            HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
            char nextChar = editor.getDocument().getText().charAt(offset);
            if (c == nextChar && (quoteHandler = new CoffeeScriptQuoteHandler()).isOpeningQuote(iterator, offset)) {
                editor.getDocument().deleteString(offset, offset + 1);
            }
        }
        return false;
    }
}

