/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.CsBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoffeeScriptIntroduceHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
        List<PsiElement> expressions;
        if (project == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(0);
        }
        if ((expressions = CoffeeScriptIntroduceHandler.collectExpressions(editor, file)).size() == 0) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
        } else if (expressions.size() == 1) {
            PsiElement element = expressions.get(0);
            if (element != null) {
                this.processIntroduce(editor, element);
            }
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<PsiElement>(){

                public void pass(PsiElement selectedValue) {
                    SmartPsiElementPointer myElementPointer = SmartPointerManager.getInstance((Project)selectedValue.getProject()).createSmartPsiElementPointer(selectedValue);
                    CoffeeScriptIntroduceHandler.this.processIntroduce(editor, myElementPointer);
                }
            }, grExpression -> grExpression.getText());
        }
    }

    private static List<PsiElement> collectExpressions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(2);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (editor.getSelectionModel().hasSelection()) {
            PsiElement element1 = file.findElementAt(editor.getSelectionModel().getSelectionStart());
            PsiElement element2 = file.findElementAt(editor.getSelectionModel().getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = element1.getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = element2.getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
            if (element1 != null && element2 != null) {
                result.add((PsiElement)CoffeeScriptIntroduceHandler.getSelectedExpression(element1, element2));
            }
        } else {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (element != null) {
                while (element != null && element.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !(element instanceof JSBlockStatement)) {
                    if (!(!(element instanceof JSExpression) || element instanceof JSObjectLiteralExpression && element.getParent() != null && element.getParent().getParent() != null && element.getParent().getParent().getParent() instanceof JSClass)) {
                        result.add(element);
                    }
                    element = element.getParent();
                }
            }
        }
        return result;
    }

    private void processIntroduce(Editor editor, @NotNull SmartPsiElementPointer elementPointer) {
        PsiElement element;
        if (elementPointer == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(3);
        }
        if ((element = elementPointer.getElement()) == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
            return;
        }
        this.processIntroduce(editor, element);
    }

    @Nullable
    public static JSExpression getSelectedExpression(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent;
        if (element1 == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(5);
        }
        if ((parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) == null) {
            return null;
        }
        if (parent instanceof JSExpression) {
            return (JSExpression)parent;
        }
        return (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSExpression.class);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            CoffeeScriptIntroduceHandler.$$$reportNull$$$0(7);
        }
    }

    protected abstract void processIntroduce(@NotNull Editor var1, @NotNull PsiElement var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementPointer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectExpressions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntroduce";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

