/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs2.impl.VirtualFileProvider;
import org.apache.commons.vfs2.impl.VirtualFileSystem;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.jetbrains.annotations.NotNull;

public class DefaultFileSystemManager
implements FileSystemManager {
    private final Map<String, FileProvider> providers = new HashMap<String, FileProvider>();
    private final ArrayList<Object> components = new ArrayList();
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class<?> fileObjectDecorator;
    private Constructor<?> fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private TemporaryFileStore tempFileStore;
    private VirtualFileProvider vfsProvider;
    private boolean init;
    private final boolean resolveAsBefore = Boolean.getBoolean("org.apache.commons.vfs2.impl.DefaultFileSystemManager.oldResolve");

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.addProvider(new String[]{urlScheme}, provider);
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        for (String scheme : urlSchemes) {
            if (!this.providers.containsKey(scheme)) continue;
            throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", (Object)scheme);
        }
        this.setupComponent(provider);
        for (String scheme : urlSchemes) {
            this.providers.put(scheme, provider);
        }
        if (provider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)provider;
        }
    }

    @Override
    public boolean hasProvider(String scheme) {
        return this.providers.containsKey(scheme);
    }

    public void setDefaultProvider(FileProvider provider) throws FileSystemException {
        this.setupComponent(provider);
        this.defaultProvider = provider;
    }

    @Override
    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy fileCacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = fileCacheStrategy;
    }

    @Override
    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    @Override
    public Class<?> getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    @Override
    public Constructor<?> getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class<?> fileObjectDecorator) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(fileObjectDecorator)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)fileObjectDecorator.getName());
        }
        try {
            this.fileObjectDecoratorConst = fileObjectDecorator.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException e) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)fileObjectDecorator.getName(), (Throwable)e);
        }
        this.fileObjectDecorator = fileObjectDecorator;
    }

    @Override
    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator replicator) throws FileSystemException {
        this.setupComponent(replicator);
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore tempFileStore) throws FileSystemException {
        this.setupComponent(tempFileStore);
        this.tempFileStore = tempFileStore;
    }

    @Override
    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    private void closeComponent(Object component) {
        if (component != null && this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.close();
            }
            this.components.remove(component);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.vfsProvider = new VirtualFileProvider();
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        for (FileProvider provider : this.providers.values()) {
            this.closeComponent(provider);
        }
        this.providers.clear();
        this.closeComponent(this.vfsProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.closeComponent(this.filesCache);
        this.closeComponent(this.defaultProvider);
        if (!this.components.isEmpty()) {
            this.log.warn((Object)("DefaultFilesystemManager.close: not all components are closed: " + this.components.toString()));
        }
        this.components.clear();
        this.vfsProvider = null;
        this.defaultProvider = null;
        this.baseFile = null;
        this.fileObjectDecorator = null;
        this.fileObjectDecoratorConst = null;
        this.localFileProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.filesCache = null;
        this.fileCacheStrategy = null;
        this.fileContentInfoFactory = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        for (FileProvider fileProvider : this.providers.values()) {
            AbstractFileProvider provider = (AbstractFileProvider)fileProvider;
            provider.freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject baseFile) {
        this.baseFile = baseFile;
    }

    public void setBaseFile(File baseFile) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(baseFile);
    }

    @Override
    public FileObject getBaseFile() {
        return this.baseFile;
    }

    @Override
    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri);
    }

    @Override
    public FileObject resolveFile(String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri, fileSystemOptions);
    }

    @Override
    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        FileObject baseFileObj = this.getLocalFileProvider().findLocalFile(baseFile);
        return this.resolveFile(baseFileObj, uri);
    }

    @Override
    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, baseFile == null ? null : baseFile.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.findFile(baseFile, uri, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.findLocalFile(uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", scheme, uri);
            }
            return this.defaultProvider.findFile(baseFile, uri, fileSystemOptions);
        }
        if (baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", (Object)uri);
        }
        return baseFile.resolveFile(uri);
    }

    @Override
    public FileName resolveName(FileName root, @NotNull String path) throws FileSystemException {
        return this.resolveName(root, path, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileName resolveName(FileName base, String name, NameScope scope) throws FileSystemException {
        String fullPath;
        String scheme;
        StringBuilder buffer = new StringBuilder(name);
        UriParser.fixSeparators(buffer);
        String string = scheme = this.resolveAsBefore ? UriParser.extractScheme(buffer.toString()) : null;
        if (name.length() == 0 || scheme == null && buffer.charAt(0) != '/') {
            buffer.insert(0, '/');
            buffer.insert(0, base.getPath());
        }
        FileType fileType = UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!AbstractFileName.checkName(base.getPath(), resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", (Object)name);
        }
        if (scheme != null) {
            fullPath = resolvedPath;
        } else {
            scheme = base.getScheme();
            fullPath = base.getRootURI() + resolvedPath;
        }
        FileProvider provider = this.providers.get(scheme);
        if (provider != null) {
            return provider.parseUri(base, fullPath);
        }
        if (scheme != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(base, fullPath);
        }
        return ((AbstractFileName)base).createName(resolvedPath, fileType);
    }

    @Override
    public FileName resolveChildName(FileName base, @NotNull String name) throws FileSystemException {
        String fullPath;
        String scheme;
        NameScope scope = NameScope.CHILD;
        StringBuilder buffer = new StringBuilder(name);
        if (this.resolveAsBefore) {
            UriParser.fixSeparators(buffer);
        }
        String string = scheme = this.resolveAsBefore ? UriParser.extractScheme(buffer.toString()) : null;
        if (name.length() == 0 || scheme == null && buffer.charAt(0) != '/') {
            buffer.insert(0, '/');
            buffer.insert(0, base.getPath());
        }
        FileType fileType = UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!AbstractFileName.checkName(base.getPath(), resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", (Object)name);
        }
        if (scheme != null) {
            fullPath = resolvedPath;
        } else {
            scheme = base.getScheme();
            fullPath = base.getRootURI() + resolvedPath;
        }
        FileProvider provider = this.providers.get(scheme);
        if (provider != null) {
            return this.resolveAsBefore ? provider.parseUri(base, fullPath) : provider.parseChildUri(base, fullPath);
        }
        if (scheme != null && this.defaultProvider != null) {
            return this.resolveAsBefore ? this.defaultProvider.parseUri(base, fullPath) : this.defaultProvider.parseChildUri(base, fullPath);
        }
        return ((AbstractFileName)base).createName(resolvedPath, fileType);
    }

    @Override
    public FileName resolveURI(String uri) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.parseUri(null, uri);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.parseUri(null, uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", scheme, uri);
            }
            return this.defaultProvider.parseUri(null, uri);
        }
        if (this.baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", (Object)uri);
        }
        return this.resolveName(this.baseFile.getName(), uri, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", scheme, file);
        }
        return provider.createFileSystem(scheme, file, file.getFileSystem().getFileSystemOptions());
    }

    @Override
    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootFile);
    }

    @Override
    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootUri);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    @Override
    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    @Override
    public void closeFileSystem(FileSystem filesystem) {
        this.getFilesCache().clear(filesystem);
        this._closeFileSystem(filesystem);
    }

    public void _closeFileSystem(FileSystem filesystem) {
        FileProvider provider = this.providers.get(filesystem.getRootName().getScheme());
        if (provider != null) {
            ((AbstractFileProvider)provider).closeFileSystem(filesystem);
        } else if (filesystem instanceof VirtualFileSystem) {
            this.vfsProvider.closeFileSystem(filesystem);
        }
    }

    @Override
    public boolean tryCloseFileSystem(FileSystem filesystem) {
        if (this._tryCloseFileSystem(filesystem)) {
            this.getFilesCache().clear(filesystem);
            return true;
        }
        return false;
    }

    private boolean _tryCloseFileSystem(FileSystem filesystem) {
        FileProvider provider = this.providers.get(filesystem.getRootName().getScheme());
        if (provider != null) {
            return ((AbstractFileProvider)provider).tryCloseFileSystem(filesystem);
        }
        if (filesystem instanceof VirtualFileSystem) {
            this.vfsProvider.closeFileSystem(filesystem);
        }
        return true;
    }

    @Override
    public String[] getSchemes() {
        String[] schemes = new String[this.providers.size()];
        this.providers.keySet().toArray(schemes);
        return schemes;
    }

    @Override
    public Collection<Capability> getProviderCapabilities(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", (Object)scheme);
        }
        return provider.getCapabilities();
    }

    @Override
    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", (Object)scheme);
        }
        return provider.getConfigBuilder();
    }

    @Override
    public FileObject resolveFile(URI uri) throws FileSystemException {
        return this.resolveFile(this.baseFile, uri.toString(), null);
    }

    @Override
    public FileObject resolveFile(URL url) throws FileSystemException {
        try {
            return this.resolveFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public FileSystem findOrCreateFileSystem(String uri, FileSystemOptions fileSystemOptions, boolean cachedOnly) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.findOrCreateFileSystem(uri, fileSystemOptions, cachedOnly);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.findOrCreateFileSystem(uri, fileSystemOptions, cachedOnly);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", scheme, uri);
            }
            return this.defaultProvider.findOrCreateFileSystem(uri, fileSystemOptions, cachedOnly);
        }
        throw new FileSystemException("vfs.impl/find-rel-file.error", (Object)uri);
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            FileProvider provider = (FileProvider)DefaultFileSystemManager.this.providers.get(protocol);
            if (provider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

