/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssue;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssueKt;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue;", "Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "dependencyName", "", "failureMessage", "projectPath", "isOfflineMode", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "description", "getDescription", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "DisableOfflineAndReimport", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class UnresolvedDependencySyncIssue
extends UnresolvedDependencyIssue {
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;
    @NotNull
    private final String description;

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public UnresolvedDependencySyncIssue(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        super(dependencyName);
        this.quickFixes = isOfflineMode ? CollectionsKt.listOf((Object)new DisableOfflineAndReimport(projectPath)) : CollectionsKt.emptyList();
        this.description = this.buildDescription(failureMessage, isOfflineMode, "Disable offline mode and reload the project");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue$DisableOfflineAndReimport;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "projectPath", "", "(Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle.common"})
    public final class DisableOfflineAndReimport
    implements BuildIssueQuickFix {
        @NotNull
        private final String id;
        private final String projectPath;

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
            gradleSettings.setOfflineWork(false);
            CompletableFuture completableFuture = UnresolvedDependencyIssueKt.access$tryRerun(dataContext);
            if (completableFuture == null) {
                ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
                Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
                completableFuture = ReimportQuickFix.Companion.requestImport(project, this.projectPath, projectSystemId);
            }
            return completableFuture;
        }

        public DisableOfflineAndReimport(String projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.id = "disable_offline_mode";
        }
    }
}

