/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.execution.tasks;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.CompDBWorkspace;
import com.jetbrains.cidr.cpp.compdb.execution.tasks.CompDBCompileTaskRunner;
import com.jetbrains.cidr.cpp.compdb.execution.tasks.CompDBExternalTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/execution/tasks/CompDBProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "task", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "intellij.clion.compdb"})
public final class CompDBProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        CompDBWorkspace compDBWorkspace = CompDBWorkspace.Companion.getInstance(project);
        if (compDBWorkspace == null) {
            return false;
        }
        CompDBWorkspace workspace = compDBWorkspace;
        return workspace.isInitialized() && this.canRun(projectTask);
    }

    public boolean canRun(@NotNull ProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleFilesBuildTask) {
            boolean bl;
            block6: {
                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"task.files");
                VirtualFile[] virtualFileArray2 = virtualFileArray;
                boolean bl2 = false;
                if (virtualFileArray2.length == 0) {
                    return false;
                }
                VirtualFile[] virtualFileArray3 = ((ModuleFilesBuildTask)task).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"task.files");
                VirtualFile[] $this$any$iv = virtualFileArray3;
                boolean $i$f$any = false;
                VirtualFile[] virtualFileArray4 = $this$any$iv;
                int n = virtualFileArray4.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = virtualFileArray4[i];
                    boolean bl3 = false;
                    VirtualFile virtualFile = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                    if (!(virtualFile.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)it.getName()) && !OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)CompDBUtilKt.getID(), (Module)((ModuleFilesBuildTask)task).getModule());
        }
        if (projectTask instanceof ModuleBuildTask) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)CompDBUtilKt.getID(), (Module)((ModuleBuildTask)task).getModule())) {
                return false;
            }
            return CompDBExternalTaskRunner.INSTANCE.canExecute(task);
        }
        return false;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = (CidrTaskRunner)new CompDBCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = CompDBExternalTaskRunner.INSTANCE;
        } else if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = CompDBExternalTaskRunner.INSTANCE;
        } else {
            CompDBLog.INSTANCE.getLOG().error("Unexpected project task type: " + task.getPresentableName());
            return null;
        }
        return cidrTaskRunner;
    }

    public CompDBProjectTaskRunner() {
        String string = CompDBUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ID.id");
        this.buildSystemId = string;
    }
}

