/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteRoot;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.dialects.sqlite.model.properties.SqliteGeneratedColumnKind;
import com.intellij.database.dialects.sqlite.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J1\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0&H\u0002\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u0018\u0010)\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0014\u00105\u001a\u0004\u0018\u0001062\b\u00103\u001a\u0004\u0018\u00010,H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020>2\u0006\u0010\u0005\u001a\u00020BH\u0002J\u0014\u0010C\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002\u00a8\u0006D"}, d2={"Lcom/intellij/database/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "buildColumn", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "name", "", "src", "Lcom/intellij/database/model/families/Family;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "fixName", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getConflictResolution", "Lcom/intellij/database/dialects/sqlite/model/properties/SqliteOnConflictAlgorithm;", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "isDesc", "", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "isIdentity", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "skipUnsignificant", "intellij.database.dialects.sqlite"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof SqliteTable) {
            this.buildTable((SqliteTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTableColumn) {
            this.buildColumn((SqliteTableColumn)obj2, source, context);
        } else if (basicModElement instanceof SqliteVirtualTable) {
            this.buildVirtualTable((SqliteVirtualTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTrigger) {
            this.buildTrigger((BasicModTrigger)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(SqliteTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        boolean bl;
        BasicElement basicElement;
        void $this$stubbed$iv;
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var7_7 = $this$stubbed$iv;
        if (var7_7 instanceof SqliteTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var7_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteTable)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteTable)object);
        } else {
            basicElement = null;
        }
        SqliteTable sqliteTable = (SqliteTable)basicElement;
        if (sqliteTable != null) {
            bl = sqliteTable.isWithoutRowId();
        } else {
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateTableStatement)) {
                dasObject2 = null;
            }
            PsiElement psiElement = (PsiElement)((SqlCreateTableStatement)dasObject2);
            IElementType iElementType = SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE");
            bl = this.findChild(psiElement, iElementType) != null;
        }
        obj2.setWithoutRowId(bl);
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ SqliteObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                return (CompositeText)((object = (SqlCreateViewStatement)dasObject) != null && (object = this.this$0.wholeStatement((SqlTableDefinition)object)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = sqliteObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    @Override
    protected void buildCheck(@NotNull BasicModCheck obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteCheck)) {
            super.buildCheck(obj2, source, context);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteCheck)obj2, source, context);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildCheckFromConstraintDefinition(SqliteCheck obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
        SqliteCheck stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        if (!context.isIntrospector()) {
            super.buildCheck(obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_7 = $this$stubbed$iv;
        if (var8_7 instanceof SqliteCheck) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteCheck)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteCheck)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteCheck)basicElement) != null) {
            sqliteOnConflictAlgorithm = stubbed.getOnConflict();
        } else {
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlConditionDefinition)) {
                dasObject2 = null;
            }
            sqliteOnConflictAlgorithm = this.getConflictResolution((PsiElement)((SqlConditionDefinition)dasObject2));
        }
        obj2.setOnConflict(sqliteOnConflictAlgorithm);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumn(SqliteTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        block20: {
            Object object;
            SqliteTableColumn sqliteTableColumn;
            block22: {
                String collationName;
                block21: {
                    Object it;
                    void this_$iv;
                    SqlObjectBuilderImpl $this$stubbed$iv;
                    Object object2;
                    block19: {
                        SqliteTableColumn stubbed;
                        BasicElement basicElement;
                        if (!context.isIntrospector()) {
                            this.buildTyped((BasicModTypedElement)obj2, source, context);
                        }
                        object2 = source;
                        SqlObjectBuilderImpl this_$iv2 = this;
                        boolean $i$f$stubbed = false;
                        SqlObjectBuilderImpl sqlObjectBuilderImpl = $this$stubbed$iv;
                        if (sqlObjectBuilderImpl instanceof SqliteTableColumn) {
                            basicElement = (BasicElement)$this$stubbed$iv;
                        } else if (sqlObjectBuilderImpl instanceof SqlStubbedElement) {
                            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                            if (!(stubElement instanceof SqlDefinitionStub)) {
                                stubElement = null;
                            }
                            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
                            Object object3 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                            if (!(object3 instanceof SqliteTableColumn)) {
                                object3 = null;
                            }
                            basicElement = (BasicElement)((SqliteTableColumn)object3);
                        } else {
                            basicElement = null;
                        }
                        if ((stubbed = (SqliteTableColumn)basicElement) == null) break block19;
                        obj2.setCollation(stubbed.getCollation());
                        obj2.setSequenceIdentity(stubbed.getSequenceIdentity());
                        obj2.setGeneratedKind(stubbed.getGeneratedKind());
                        if (stubbed.getGeneratedKind() != SqliteGeneratedColumnKind.NONE) {
                            obj2.setDefaultExpression(stubbed.getDefaultExpression());
                        }
                        break block20;
                    }
                    collationName = null;
                    $this$stubbed$iv = this;
                    DasObject dasObject = source;
                    if (!(dasObject instanceof SqlColumnDefinition)) {
                        dasObject = null;
                    }
                    PsiElement el$iv = (PsiElement)((SqlColumnDefinition)dasObject);
                    boolean $i$f$forEachChild = false;
                    void var9_12 = this_$iv;
                    PsiElement psiElement = el$iv;
                    PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
                    boolean $i$f$forEachSibling = false;
                    for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it2 = tmp$iv$iv;
                        boolean bl = false;
                        if (it2 instanceof LeafPsiElement) continue;
                        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it2);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION)) {
                            SqlExpression collationRef;
                            PsiElement psiElement2 = it2;
                            if (!(psiElement2 instanceof SqlConstraintDefinition)) {
                                psiElement2 = null;
                            }
                            SqlConstraintDefinition sqlConstraintDefinition = (SqlConstraintDefinition)psiElement2;
                            SqlExpression sqlExpression = collationRef = sqlConstraintDefinition != null ? (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION) : null;
                            collationName = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION)) {
                            obj2.setOnNullConflict(this.getConflictResolution(it2));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE)) continue;
                        boolean isStored = SqlImplUtil.getChildOfType((PsiElement)it2, (IElementType)SqliteTypes.SQLITE_STORED) != null;
                        obj2.setGeneratedKind(isStored ? SqliteGeneratedColumnKind.STORED : SqliteGeneratedColumnKind.VIRTUAL);
                        SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)it2, SqlExpression.class);
                        obj2.setDefaultExpression(sqlExpression != null ? sqlExpression.getText() : null);
                    }
                    if (StringsKt.equals((String)"binary", (String)collationName, (boolean)true)) {
                        collationName = null;
                    }
                    object2 = obj2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object this_$iv$iv = object2;
                    SqliteTableColumn sqliteTableColumn2 = obj2;
                    boolean bl3 = false;
                    boolean bl4 = it instanceof BasicDataObject;
                    sqliteTableColumn = sqliteTableColumn2;
                    object = !bl4 ? object2 : null;
                    if (object == null || (object = (BasicModModel)object.getModel()) == null) break block21;
                    object2 = object;
                    bl = false;
                    bl2 = false;
                    it = object2;
                    sqliteTableColumn2 = sqliteTableColumn;
                    boolean bl5 = false;
                    Object object4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
                    BasicRoot basicRoot = object4.getRoot();
                    if (basicRoot == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.sqlite.model.SqliteRoot");
                    }
                    SqliteRoot sqliteRoot = (SqliteRoot)basicRoot;
                    Object object5 = sqliteRoot != null ? sqliteRoot.getCollations() : null;
                    Intrinsics.checkNotNullExpressionValue(object5, (String)"(it.root as SqliteRoot)?.collations");
                    String string = this.fixName(collationName, (Family)object5);
                    sqliteTableColumn = sqliteTableColumn2;
                    object = string;
                    if (object != null) break block22;
                }
                object = collationName;
            }
            sqliteTableColumn.setCollation((String)object);
            obj2.setSequenceIdentity(source instanceof SqlColumnDefinition && this.isIdentity((SqlColumnDefinition)source) ? SequenceIdentity.UNKNOWN : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIdentity(SqlColumnDefinition obj2) {
        List refs;
        SqlReferenceList refList;
        PsiElement psiElement;
        block7: {
            void el$iv;
            void this_$iv;
            PsiElement psiElement2;
            PsiElement this_$iv2;
            block6: {
                PsiElement psiElement3 = (PsiElement)obj2;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
                if (this.findChild(psiElement3, (IElementType)sqlCompositeElementType) != null) {
                    return true;
                }
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                PsiElement el$iv2 = obj2.getParent();
                boolean $i$f$findChild2 = false;
                void var7_8 = this_$iv2;
                PsiElement psiElement4 = el$iv2;
                PsiElement element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlTableKeyDefinition)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            this_$iv2 = (PsiElement)((SqlTableKeyDefinition)psiElement2);
            boolean $i$f$findChild = false;
            void $i$f$findChild2 = this_$iv;
            void v4 = el$iv;
            PsiElement element$iv$iv = v4 != null ? v4.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlReferenceList)) continue;
                psiElement = tmp$iv$iv;
                break block7;
            }
            psiElement = null;
        }
        SqlReferenceList sqlReferenceList = refList = (SqlReferenceList)psiElement;
        List list = refs = sqlReferenceList != null ? sqlReferenceList.getReferenceList() : null;
        if (refs == null || refs.size() != 1) {
            return false;
        }
        PsiElement psiElement5 = (PsiElement)refs.get(0);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
        if (this.findSibling(psiElement5, (IElementType)sqlCompositeElementType) == null) {
            return false;
        }
        Object e2 = refs.get(0);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"refs[0]");
        String string = this.extractName((PsiElement)e2);
        if (string == null) {
            string = "";
        }
        return StringsKt.equals((String)string, (String)obj2.getName(), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteVirtualTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqliteVirtualTable stubbed;
        BasicElement basicElement;
        SqlObjectBuilderImpl $this$stubbed$iv;
        if (!context.isIntrospector()) {
            this.buildNamedElement((BasicModNamedElement)obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = $this$stubbed$iv;
        if (sqlObjectBuilderImpl instanceof SqliteVirtualTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (sqlObjectBuilderImpl instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteVirtualTable)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteVirtualTable)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteVirtualTable)basicElement) != null) {
            obj2.setArguments(stubbed.getArguments());
            obj2.setModule(stubbed.getModule());
        } else {
            List list;
            PsiElement psiElement;
            SqlClause moduleClause;
            PsiElement element$iv$iv;
            block16: {
                PsiElement psiElement2;
                boolean bl;
                PsiElement it$iv;
                PsiElement tmp$iv$iv;
                boolean $i$f$findSibling;
                boolean $i$f$findChild;
                block15: {
                    void this_$iv2;
                    $this$stubbed$iv = this;
                    DasObject dasObject2 = source;
                    if (!(dasObject2 instanceof SqlCreateStatement)) {
                        dasObject2 = null;
                    }
                    PsiElement el$iv = (PsiElement)((SqlCreateStatement)dasObject2);
                    $i$f$findChild = false;
                    void var9_12 = this_$iv2;
                    PsiElement psiElement3 = el$iv;
                    element$iv$iv = psiElement3 != null ? psiElement3.getFirstChild() : null;
                    $i$f$findSibling = false;
                    for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        it$iv = tmp$iv$iv;
                        bl = false;
                        if (!(it$iv instanceof SqlClause)) continue;
                        psiElement2 = tmp$iv$iv;
                        break block15;
                    }
                    psiElement2 = null;
                }
                moduleClause = (SqlClause)psiElement2;
                SqlObjectBuilderImpl this_$iv3 = this;
                $i$f$findChild = false;
                SqlObjectBuilderImpl this_$iv$iv = this_$iv3;
                PsiElement psiElement4 = (PsiElement)moduleClause;
                element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement = tmp$iv$iv;
                    break block16;
                }
                psiElement = null;
            }
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)psiElement;
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteVirtualTable sqliteVirtualTable = obj2;
            if (moduleArguments != null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SqlClause[] $i$f$findChild = moduleArguments;
                SqliteVirtualTable sqliteVirtualTable2 = sqliteVirtualTable;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var13_19 = $this$mapTo$iv$iv;
                int n = ((void)var13_19).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var17_24 = item$iv$iv = var13_19[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v10 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"it");
                    String string = v10.getText();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                sqliteVirtualTable = sqliteVirtualTable2;
                list = collection;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj2.setModule(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null);
        }
    }

    @Override
    protected void buildKey(@NotNull BasicModKey obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj2 instanceof SqliteKey)) {
            super.buildKey(obj2, source, context);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteKey)obj2, (SqlTableKeyDefinition)source, context);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildKeyFromTableKeyDefinition(SqliteKey obj2, SqlTableKeyDefinition source, SqlObjectBuilder.Context context) {
        SqliteKey stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, (DasObject)source, context);
        }
        if (!context.isStubBuilder()) {
            obj2.setPrimary(source.isPrimary());
        }
        DasObject dasObject = (DasObject)source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_7 = $this$stubbed$iv;
        if (var8_7 instanceof SqliteKey) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteKey)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteKey)object);
        } else {
            basicElement = null;
        }
        obj2.setOnConflict((stubbed = (SqliteKey)basicElement) != null ? stubbed.getOnConflict() : this.getConflictResolution((PsiElement)source));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildTrigger(@NotNull BasicModTrigger obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        SqliteTrigger stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteTrigger)) {
            super.buildTrigger(obj2, source, context);
            return;
        }
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof SqliteTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteTrigger)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteTrigger)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteTrigger)basicElement) != null) {
            ((SqliteTrigger)obj2).setColNames(stubbed.getColNames());
            ((SqliteTrigger)obj2).setEvents(stubbed.getEvents());
            ((SqliteTrigger)obj2).setTurn(stubbed.getTurn());
            ((SqliteTrigger)obj2).setCondition(stubbed.getCondition());
        } else {
            SqlWhenClause whenClause;
            PsiElement element;
            SqlNameElement name2;
            TrigTurn turn = null;
            TrigEvent event = null;
            List<String> cols2 = null;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateTriggerStatement)) {
                dasObject2 = null;
            }
            SqlCreateTriggerStatement sqlCreateTriggerStatement = (SqlCreateTriggerStatement)dasObject2;
            SqlNameElement sqlNameElement = name2 = sqlCreateTriggerStatement != null ? sqlCreateTriggerStatement.getNameElement() : null;
            PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
            if (afterName instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
                ASTNode aSTNode = element.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
                IElementType iElementType = aSTNode.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"element.node.elementType");
                IElementType type = iElementType;
                event = this.getEvent(type);
                if (event == null) {
                    turn = this.getTurn(type);
                    PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                    if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                        ASTNode aSTNode2 = element.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"element.node");
                        IElementType iElementType2 = aSTNode2.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"element.node.elementType");
                        event = this.getEvent(iElementType2);
                        cols2 = this.getColumns(nextClause);
                    }
                } else {
                    cols2 = this.getColumns(afterName);
                }
            }
            turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
            DasObject dasObject3 = source;
            if (!(dasObject3 instanceof SqlCreateTriggerStatement)) {
                dasObject3 = null;
            }
            SqlWhenClause sqlWhenClause = whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)((SqlCreateTriggerStatement)dasObject3)), SqlWhenClause.class);
            SqlExpression whenExpr = sqlWhenClause != null ? sqlWhenClause.getExpression() : null;
            SqlExpression sqlExpression = whenExpr;
            ((SqliteTrigger)obj2).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            ((SqliteTrigger)obj2).setTurn(turn);
            SqliteTrigger sqliteTrigger = (SqliteTrigger)obj2;
            List<String> list = cols2;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            sqliteTrigger.setColNames(list);
            ((SqliteTrigger)obj2).setEvents(event == null ? SetsKt.emptySet() : SetsKt.setOf((Object)event));
        }
        this.assignSources((BasicModSourceAware)obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ SqliteObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateTriggerStatement)) {
                    dasObject = null;
                }
                return (CompositeText)((object = (SqlCreateTriggerStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = sqliteObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIndex(@NotNull BasicModIndex obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        block18: {
            SqlTableColumnsList columnsList;
            SqlReferenceExpression tableRef;
            SqliteIndex stubbed;
            BasicElement basicElement;
            void $this$stubbed$iv;
            Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(obj2 instanceof SqliteIndex)) {
                super.buildIndex(obj2, source, context);
                return;
            }
            if (!context.isIntrospector()) {
                this.buildNamedElement((BasicModNamedElement)obj2, source, context);
            }
            DasObject dasObject = source;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$stubbed = false;
            void var8_8 = $this$stubbed$iv;
            if (var8_8 instanceof SqliteIndex) {
                basicElement = (BasicElement)$this$stubbed$iv;
            } else if (var8_8 instanceof SqlStubbedElement) {
                StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                if (!(stubElement instanceof SqlDefinitionStub)) {
                    stubElement = null;
                }
                SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
                Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                if (!(object instanceof SqliteIndex)) {
                    object = null;
                }
                basicElement = (BasicElement)((SqliteIndex)object);
            } else {
                basicElement = null;
            }
            if ((stubbed = (SqliteIndex)basicElement) != null) {
                ((SqliteIndex)obj2).setCondition(stubbed.getCondition());
            } else {
                DasObject dasObject2 = source;
                if (!(dasObject2 instanceof SqlCreateIndexStatement)) {
                    dasObject2 = null;
                }
                SqlWhereClause where2 = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)((SqlCreateIndexStatement)dasObject2)), SqlWhereClause.class);
                SqlExpression whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where2), SqlExpression.class);
                SqlExpression sqlExpression = whereExpr;
                ((SqliteIndex)obj2).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            }
            if (context.isStubBuilder()) {
                return;
            }
            DasObject dasObject3 = source;
            if (!(dasObject3 instanceof SqlCreateIndexStatement)) {
                dasObject3 = null;
            }
            SqlCreateIndexStatement sqlCreateIndexStatement = (SqlCreateIndexStatement)dasObject3;
            SqlReferenceExpression sqlReferenceExpression = tableRef = sqlCreateIndexStatement != null ? sqlCreateIndexStatement.getTargetReference() : null;
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlTableColumnsList)) {
                object = null;
            }
            SqlTableColumnsList sqlTableColumnsList = columnsList = (SqlTableColumnsList)object;
            Object columns = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
            SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns), SqlExpression.class);
            if (columnExprs == null) break block18;
            ArrayList<Object> newNames = new ArrayList<Object>(columnExprs.length);
            boolean bl = false;
            LinkedHashSet newRev = new LinkedHashSet();
            for (SqlExpression expr : columnExprs) {
                boolean curRev;
                block22: {
                    block19: {
                        Object object2;
                        ArrayList<Object> arrayList;
                        block21: {
                            block20: {
                                void it;
                                curRev = false;
                                if (!(expr instanceof SqlReferenceExpression)) break block19;
                                arrayList = newNames;
                                object2 = ((SqliteIndex)obj2).getTable();
                                if (object2 == null || (object2 = object2.getColumns()) == null) break block20;
                                ModPositioningNamingFamily<? extends SqliteTableColumn> modPositioningNamingFamily = object2;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                ModPositioningNamingFamily<? extends SqliteTableColumn> modPositioningNamingFamily2 = modPositioningNamingFamily;
                                ArrayList<Object> arrayList2 = arrayList;
                                boolean bl4 = false;
                                String string = ((SqlReferenceExpression)expr).getName();
                                void v14 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it");
                                String string2 = this.fixName(string, (Family)v14);
                                arrayList = arrayList2;
                                object2 = string2;
                                if (object2 != null) break block21;
                            }
                            String string = ((SqlReferenceExpression)expr).getName();
                            object2 = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expr.name");
                        }
                        arrayList.add(object2);
                        curRev = this.isDesc((SqlReferenceExpression)expr);
                        break block22;
                    }
                    SqlExpression sqlExpression = expr;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expr");
                    newNames.add(sqlExpression.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            ((SqliteIndex)obj2).setColNames(newNames);
            ((SqliteIndex)obj2).setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type = PsiTreeUtilKt.getElementType((PsiElement)tmp);
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name2, Family<?> src2) {
        Object object = this.findObject(name2, src2);
        if (object == null || (object = object.getName()) == null) {
            object = name2;
        }
        return object;
    }

    private final <T extends BasicElement> T findObject(String name2, Family<T> src2) {
        Object v1;
        block2: {
            if (name2 == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = (Iterable)src2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                BasicElement basicElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
                if (!StringsKt.equals((String)name2, (String)basicElement.getName(), (boolean)true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return (T)((BasicElement)v1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $this$mapTo$iv$iv;
            SqlReferenceExpression[] $this$map$iv = sqlReferenceExpressionArray;
            boolean $i$f$map = false;
            SqlReferenceExpression[] sqlReferenceExpressionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                String string = v1.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        SqliteOnConflictAlgorithm algo;
        block3: {
            SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"SqliteTypes.SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.getDeepestLast(onConflict)");
            PsiElement how = psiElement2;
            String text = how.getText();
            SqliteOnConflictAlgorithm[] $this$firstOrNull$iv = SqliteOnConflictAlgorithm.values();
            boolean $i$f$firstOrNull = false;
            SqliteOnConflictAlgorithm[] sqliteOnConflictAlgorithmArray = $this$firstOrNull$iv;
            int n = sqliteOnConflictAlgorithmArray.length;
            for (int j = 0; j < n; ++j) {
                SqliteOnConflictAlgorithm element$iv;
                SqliteOnConflictAlgorithm it = element$iv = sqliteOnConflictAlgorithmArray[j];
                boolean bl = false;
                if (!StringsKt.equals((String)it.toString(), (String)text, (boolean)true)) continue;
                sqliteOnConflictAlgorithm = element$iv;
                break block3;
            }
            sqliteOnConflictAlgorithm = algo = null;
        }
        if (algo == SqliteOnConflictAlgorithm.ABORT) {
            return null;
        }
        return algo;
    }
}

