/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.model;

import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J:\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/sqlite/model/SqliteDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeSqliteCheck", "chk", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "describeSqliteColumn", "col", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "describeSqliteIndex", "index", "Lcom/intellij/database/dialects/sqlite/model/SqliteIndex;", "describeSqliteIndexingItems", "describeSqliteKey", "key", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "describeSqliteTable", "table", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "describeSqliteVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "presentSqliteIndexColumn", "column", "descendants", "", "collation", "i", "", "intellij.database.dialects.sqlite"})
public final class SqliteDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof SqliteVirtualTable ? this.describeSqliteVirtualTable((SqliteVirtualTable)e2, context) : (basicElement instanceof SqliteTable ? this.describeSqliteTable((SqliteTable)e2, context) : (basicElement instanceof SqliteTableColumn ? this.describeSqliteColumn((SqliteTableColumn)e2, context) : (basicElement instanceof SqliteCheck ? this.describeSqliteCheck((SqliteCheck)e2, context) : (basicElement instanceof SqliteKey ? this.describeSqliteKey((SqliteKey)e2, context) : (basicElement instanceof SqliteIndex ? this.describeSqliteIndex((SqliteIndex)e2, context) : super.content(e2, context))))));
    }

    private final String describeSqliteVirtualTable(SqliteVirtualTable table, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = SqliteVirtualTable.TEMPORARY;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = SqliteVirtualTable.MODULE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = SqliteVirtualTable.ARGUMENTS;
        bl = false;
        collection.add(object);
        String res2 = "virtual table ";
        if (table.isTemporary()) {
            res2 = "temp " + res2;
        }
        if (table.getModule() != null) {
            res2 = res2 + table.getModule();
        }
        res2 = res2 + "(" + StringUtil.join((Collection)table.getArguments(), (String)",") + ")";
        return res2;
    }

    private final String describeSqliteTable(SqliteTable table, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<Boolean> basicMetaPropertyId = SqliteTable.WITHOUT_ROW_ID;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        String res2 = this.describeTable((BasicTable)table, context);
        if (table.isWithoutRowId()) {
            res2 = res2 + " without rowid";
        }
        return res2;
    }

    private final String describeSqliteColumn(SqliteTableColumn col, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = SqliteTableColumn.ON_NULL_CONFLICT;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = SqliteTableColumn.COLLATION;
        bl = false;
        collection.add(object);
        String res2 = this.describeColumn((BasicLikeColumn)col, context);
        if (col.getOnNullConflict() != null) {
            res2 = res2 + " on conflict " + (Object)((Object)col.getOnNullConflict());
        }
        if (col.getCollation() != null) {
            res2 = res2 + " collate " + col.getCollation();
        }
        return res2;
    }

    private final String describeSqliteCheck(SqliteCheck chk, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = SqliteCheck.ON_CONFLICT;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        String res2 = this.describeCheck((BasicCheck)chk, context);
        if (chk.getOnConflict() != null) {
            res2 = res2 + " on conflict " + (Object)((Object)chk.getOnConflict());
        }
        return res2;
    }

    private final String describeSqliteKey(SqliteKey key2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = SqliteKey.ON_CONFLICT;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        String res2 = this.describeKey((BasicKey)key2, context);
        if (key2.getOnConflict() != null) {
            res2 = res2 + " on conflict " + StringUtil.toLowerCase((String)String.valueOf((Object)key2.getOnConflict()));
        }
        return res2;
    }

    private final String describeSqliteIndex(SqliteIndex index2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<List<String>> basicMetaPropertyId = SqliteIndex.CONDITION;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = SqliteIndex.UNIQUE;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = SqliteIndex.COL_NAMES;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = SqliteIndex.REVERSE_COL_NAMES;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = SqliteIndex.COLUMN_COLLATIONS;
        bl = false;
        collection.add(basicMetaPropertyId);
        String inner = this.describeSqliteIndexingItems(index2);
        String condition = index2.getCondition();
        String d = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        if (condition != null) {
            d = d + " when " + condition;
        }
        return d;
    }

    @NotNull
    public final String describeSqliteIndexingItems(@NotNull SqliteIndex index2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        List list = index2.getColNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"index.colNames");
        List names2 = list;
        Set set = index2.getReverseColNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"index.reverseColNames");
        Set ds = set;
        List<String> list2 = index2.getColumnCollations();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"index.columnCollations");
        List<String> col = list2;
        Object object = names2;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = ", ";
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = null;
            CharSequence charSequence3 = null;
            Function1 function1 = (Function1)new Function1<IndexedValue<? extends String>, CharSequence>(this, index2, ds, col){
                final /* synthetic */ SqliteDescriptionService this$0;
                final /* synthetic */ SqliteIndex $index;
                final /* synthetic */ Set $ds;
                final /* synthetic */ List $col;

                @NotNull
                public final CharSequence invoke(@NotNull IndexedValue<String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return SqliteDescriptionService.access$presentSqliteIndexColumn(this.this$0, this.$index, (String)it.getValue(), this.$ds, (String)CollectionsKt.getOrNull((List)this.$col, (int)it.getIndex()), it.getIndex());
                }
                {
                    this.this$0 = sqliteDescriptionService;
                    this.$index = sqliteIndex;
                    this.$ds = set;
                    this.$col = list;
                    super(1);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)names2), (CharSequence)object, charSequence3, charSequence2, (int)n, charSequence, (Function1)function1, (int)30, null);
        } else {
            string = "???";
        }
        String representation2 = string;
        return representation2;
    }

    private final String presentSqliteIndexColumn(SqliteIndex index2, String column2, Set<String> descendants, String collation, int i2) {
        String res2 = this.presentIndexColumn((BasicIndex)index2, column2, descendants, i2);
        if (StringUtil.isNotEmpty((String)collation)) {
            res2 = res2 + " collate " + collation;
        }
        return res2;
    }

    public static final /* synthetic */ String access$presentSqliteIndexColumn(SqliteDescriptionService $this, SqliteIndex index2, String column2, Set descendants, String collation, int i2) {
        return $this.presentSqliteIndexColumn(index2, column2, descendants, collation, i2);
    }
}

