/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.exasol.ExaDialect;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J*\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/exasol/refactoring/ExaExtractVariableHelper;", "Lcom/intellij/sql/refactoring/SqlExtractVariableHelper;", "()V", "addDeclaration", "Lcom/intellij/psi/PsiElement;", "declaration", "block", "anchor", "createDeclaration", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "type", "Lcom/intellij/database/model/DataType;", "expressionText", "createInitializerDeclaration", "text", "isTypeStrict", "", "intellij.database.dialects.exasol"})
public final class ExaExtractVariableHelper
extends SqlExtractVariableHelper {
    @NotNull
    public static final ExaExtractVariableHelper INSTANCE;

    public boolean isTypeStrict() {
        return true;
    }

    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name2, @NotNull DataType type, @NotNull String expressionText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)expressionText, (String)"expressionText");
        DdlBuilder ddlBuilder = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().type(type);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"createBuilder(project)\n \u2026space()\n      .type(type)");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createBuilder(project)\n \u2026pe(type)\n      .statement");
        String varText = string;
        String statementText = "create function foo() as " + varText + "; begin end";
        SqlStatement dummyFunction = SqlPsiElementFactory.createStatementFromText((String)statementText, (SqlLanguageDialect)((SqlLanguageDialect)this.getDialect()), (Project)project, null);
        return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dummyFunction), SqlVariableDefinition.class);
    }

    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name2, @NotNull String text) {
        SqlStatement dummyFunction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DdlBuilder ddlBuilder = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().symbol(":=").space().plain(text);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"createBuilder(project)\n \u2026pace()\n      .plain(text)");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createBuilder(project)\n \u2026in(text)\n      .statement");
        String initText = string;
        String statementText = "create function foo() as begin " + initText + "; end";
        SqlStatement sqlStatement = dummyFunction = SqlPsiElementFactory.createStatementFromText((String)statementText, (SqlLanguageDialect)((SqlLanguageDialect)this.getDialect()), (Project)project, null);
        return PsiTreeUtil.getChildOfType((PsiElement)(sqlStatement != null ? sqlStatement.getLastChild() : null), SqlStatement.class);
    }

    @Nullable
    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block, @NotNull PsiElement anchor2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)anchor2, (String)"anchor");
        PsiElement parent2 = block.getParent();
        PsiElement addedVar = parent2.addBefore(declaration, block);
        PsiElement psiElement = SqlPsiElementFactory.createLeafFromText((Project)declaration.getProject(), (SqlLanguageDialect)((SqlLanguageDialect)this.getDialect()), (String)";");
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SqlPsiElementFactory.cre\u2026on.project, dialect, \";\")");
        PsiElement semi = psiElement;
        parent2.addAfter(semi, addedVar);
        parent2.addBefore(SqlPsiElementFactory.newLine((Project)block.getProject()), addedVar);
        return addedVar;
    }

    private ExaExtractVariableHelper() {
        super((SqlLanguageDialectEx)ExaDialect.INSTANCE);
    }

    static {
        ExaExtractVariableHelper exaExtractVariableHelper;
        INSTANCE = exaExtractVariableHelper = new ExaExtractVariableHelper();
    }
}

