/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PgDateTimeLanguageHelper;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends SqlLanguageDialectEx {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    @Nullable
    protected SqlExpression getQualifier(@NotNull PsiElement element) {
        SqlReferenceExpression ref2;
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        return (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class)) == null ? null : ref2.getQualifierExpression();
    }

    public static boolean inPl(PsiElement element) {
        return SqlFileElementType.isInPl((PsiElement)element);
    }

    public final ReservedEntity getNewTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias;
    }

    public final ReservedEntity getOldTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias;
    }

    public final Map<String, ReservedEntity> getTriggerStringImplicits() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerStringImplicits;
    }

    public final ReservedEntity getTriggerNArgsColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerNArgsColumn;
    }

    public final ReservedEntity getTriggerArgVColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerArgVColumn;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"dpn", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"bigint", (String)"bigint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"numeric", (String)"numeric", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"dp", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"bytea", (String)"bytea", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"name", (String)"name", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"oid", (String)"oid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"gobject", (String)"geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"circle", (String)"circle", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"path", (String)"path", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"box", (String)"box", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"polygon", (String)"polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"lseg", (String)"lseg", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"point", (String)"point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"line", (String)"line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"cidr", (String)"cidr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"inet", (String)"inet", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"macaddr", (String)"macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"tsvector", (String)"tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"tsquery", (String)"tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"trigger", (String)"trigger", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"range", (String)"range", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"txid_snapshot", (String)"txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"void", (String)"void", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"record", (String)"record", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"enum", (String)"enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"xml", (String)"xml", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"float4", (String)"float4", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"int2vector", (String)"int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"json", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"jsonb", (String)"jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"regclass", (String)"regclass", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"regdictionary", (String)"regdictionary", (SqlLanguageDialectEx)this);
    }

    public PgDialectBase(@NotNull String id) {
        if (id == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        SqlFunctionDefinition definition2;
        SqlReferenceExpression ref2;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        SqlExpression qualifier = (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class)) == null ? null : ref2.getQualifierExpression();
        boolean isFunctionCall = place.getParent() instanceof SqlFunctionCallExpression;
        SqlFunctionDefinition sqlFunctionDefinition = definition2 = name2 == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name2);
        if (definition2 != null) {
            for (SqlFunctionDefinition.Prototype prototype : definition2.getPrototypes()) {
                SqlType type;
                if (prototype.getParams().length != 1 || processor.executeTarget((DasSymbol)definition2, type = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType((SqlFunctionDefinition.Prototype)prototype, (SqlReferenceExpression)ref2, (PsiElement)qualifier, (PsiElement)ref2), null, ResolveState.initial())) continue;
                return false;
            }
        }
        SqlTypeSystemBase typeSystem = this.getTypeSystem();
        if (PgDialectBase.inPl(place) && this.getQualifier(place) == null) {
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn.name, (String)name2, (boolean)resolve2) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn, typeSystem.booleanType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn.name, (String)name2, (boolean)resolve2) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn, typeSystem.integerType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn.name, (String)name2, (boolean)resolve2) && !processor.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private static boolean raiseStatement(@NotNull PsiElement element) {
        SqlStatement statement;
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        return (statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) != null && statement.getNode().getElementType() == PgElementTypes.Misc.PG_RAISE_STATEMENT;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref2) {
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(5);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        if (ref2 == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        PsiElement place = ref2.getElement();
        if (processor.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params2 = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params2 == null ? Collections.emptyList() : params2.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getSqlType(), SqlTableType.class);
                if (type == null) {
                    return true;
                }
                Set expected = processor.getInitialExpectedTypes();
                processor.setExpectedKinds(Collections.singleton(ObjectKind.COLUMN));
                boolean res2 = SqlImplUtil.processDeclarationsInType((SqlTableType)type, (SqlScopeProcessor)processor, (ResolveState)state2, (PsiElement)place);
                processor.setExpectedKinds(expected);
                if (!res2) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor, state2, ref2);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        DasSymbol qualifierSymbol;
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        if (ref2 == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.VARIABLE}) && qualifier instanceof SqlReferenceExpression && ((qualifierSymbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) == ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias || qualifierSymbol == ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias)) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref2), null, Boolean.valueOf(false), state2);
        }
        if (!processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor.getReferenceName() == null && qualifier.getSqlType() == SqlType.UNKNOWN) {
            return true;
        }
        if (qualifier.getSqlType().getCategory() == SqlType.Category.RECORD) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref2), (SqlType)SqlType.UNKNOWN, Boolean.valueOf(false), state2);
        }
        SqlScopeProcessorBase filteringProcessor = PgDialectBase.filterSingleArgumentRoutines(processor);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref2, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants((SqlScopeProcessor)filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor, state2, ref2, qualifier);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return (T)super.getParentDbTypes(result2, type);
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        PgDateTimeLanguageHelper pgDateTimeLanguageHelper = PgDateTimeLanguageHelper.INSTANCE;
        if (pgDateTimeLanguageHelper == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        return pgDateTimeLanguageHelper;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (strict) {
            return false;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.AGGREGATE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(type) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    private static SqlScopeProcessorBase filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessorBase processor = new SqlScopeProcessorBase(sqlProcessor.getReferenceName(), (SqlLanguageDialectEx)sqlProcessor.getDialect(), sqlProcessor.getDataSources(), sqlProcessor.getPlace()){

            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state2) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine((DasObject)symbol.getDasObject()) || sqlProcessor.executeTarget(symbol, sqlType, forcedCaseSens, state2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PgDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setExpectedKinds(Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessorBase sqlScopeProcessorBase = processor;
        if (sqlScopeProcessorBase == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        return sqlScopeProcessorBase;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PgDialectBase.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas2 = SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.first), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames((DbDataSource)dataSource), SqlDialectImplUtilCore.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas2, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.second), (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])schemas2))));
        if (treePattern == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        return treePattern;
    }

    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            PgDialectBase.$$$reportNull$$$0(16);
        }
        return expression.getReferenceElementType() == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE || super.isMultiIdReference(expression);
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            PgDialectBase.$$$reportNull$$$0(17);
        }
        if (text == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        return SqlLexer.isValidRawCopyToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean requiresAsForAliasAt(@NotNull PsiElement element) {
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlInsertStatement.class}) != null;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper(this);
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = PgDialectBase.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = PgDialectBase.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            DasObject parent2;
            if (namespace.getKind() == ObjectKind.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent2 = namespace.getDasParent()) != null && parent2.getKind() == ObjectKind.DATABASE) {
                dbName = ObjectName.quoted((String)parent2.getName());
            }
        }
        if (scName == null) {
            scName = PgDialect.LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Nullable
    protected static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig((DbDataSource)dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName((RawConnectionConfig)config), (Object)SqlDialectImplUtilCore.getUserName((RawConnectionConfig)config))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyInstanceData {
        private final ReservedEntity myNewTableAlias;
        private final ReservedEntity myOldTableAlias;
        private final Map<String, ReservedEntity> myTriggerStringImplicits;
        private final ReservedEntity myTriggerNArgsColumn;
        private final ReservedEntity myTriggerArgVColumn;
        private final ReservedEntity myFoundColumn;
        private final ReservedEntity mySqlStateColumn;
        private final ReservedEntity mySqlErrmColumn;

        private LazyInstanceData() {
            this.myNewTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "new", ObjectKind.TABLE);
            this.myOldTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "old", ObjectKind.TABLE);
            this.myTriggerStringImplicits = SqlDialectImplUtilCore.buildEntities((Dbms)PgDialectBase.this.getDbms(), (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event"});
            this.myTriggerNArgsColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_nargs", ObjectKind.COLUMN);
            this.myTriggerArgVColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_argv", ObjectKind.COLUMN);
            this.myFoundColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "FOUND", ObjectKind.COLUMN);
            this.mySqlStateColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLSTATE", ObjectKind.COLUMN);
            this.mySqlErrmColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLERRM", ObjectKind.COLUMN);
        }
    }
}

