/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgSelectFromProcedureInspection
extends SqlInspectionBase {
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isPostgres()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, (SqlLanguageDialect)dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression o2) {
                this.processExpression(o2.getExpression(), o2.getColumnAliasList());
            }

            public void visitSqlFromClause(SqlFromClause o2) {
                super.visitSqlFromClause(o2);
                SqlExpression expression = o2.getFromExpression();
                this.processExpression(expression, Collections.emptyList());
            }

            private void processExpression(SqlExpression expression, List<SqlDefinition> aliases) {
                SqlFunctionCallExpression function;
                if (expression instanceof SqlFunctionCallExpression) {
                    this.processFunctionCall((SqlFunctionCallExpression)expression, aliases);
                } else if (expression instanceof SqlExplicitTableExpression && (function = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlFunctionCallExpression.class)) != null) {
                    this.processFunctionCall(function, aliases);
                }
            }

            private void processFunctionCall(SqlFunctionCallExpression functionCall, List<SqlDefinition> aliases) {
                boolean needTypedAliasDefinition = PgSelectFromProcedureInspection.needTypedAliasDefinition(functionCall);
                if (needTypedAliasDefinition && aliases.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)functionCall, DatabaseBundle.message((String)"inspection.message.function.call.must.have.typed.alias.definition", (Object[])new Object[0]), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return;
                }
                for (SqlDefinition alias : aliases) {
                    if (alias.getKind() != ObjectKind.COLUMN) continue;
                    SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class);
                    if (needTypedAliasDefinition && type == null) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, DatabaseBundle.message((String)"inspection.message.alias.must.have.type", (Object[])new Object[0]), (LocalQuickFix)new MyAddTypeQuickFix(alias), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                    if (needTypedAliasDefinition || type == null) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, DatabaseBundle.message((String)"inspection.message.alias.can.have.type", (Object[])new Object[0]), (LocalQuickFix)new MyRemoveTypeQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static boolean needTypedAliasDefinition(@Nullable DataType returnType) {
        if (returnType == null) {
            return false;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)returnType.getSpecification(), (CharSequence)"record")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)returnType.typeName, (CharSequence)"table")) {
            String arg = returnType.vagueArg;
            return arg != null && StringUtil.endsWithIgnoreCase((String)arg, (String)" record");
        }
        return false;
    }

    private static boolean needTypedAliasDefinition(@NotNull SqlFunctionCallExpression functionCall) {
        SqlReferenceExpression nameElement;
        if (functionCall == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(3);
        }
        if ((nameElement = functionCall.getNameElement()) == null) {
            return false;
        }
        String functionName = nameElement.getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"dblink")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"pg_stat_file")) {
            return false;
        }
        DasSymbol symbol = nameElement.resolveSymbol();
        if (symbol instanceof DasRoutine) {
            DataType type;
            DasRoutine routine2 = (DasRoutine)symbol;
            for (DasArgument info : DasUtil.getParameters((DasRoutine)routine2)) {
                ArgumentDirection type2 = info.getArgumentDirection();
                if (type2 != ArgumentDirection.OUT && type2 != ArgumentDirection.INOUT) continue;
                return false;
            }
            DasArgument retArg = routine2.getReturnArgument();
            DataType dataType = type = retArg == null ? null : retArg.getDataType();
            if (PgSelectFromProcedureInspection.needTypedAliasDefinition(type)) {
                return true;
            }
        } else if (symbol instanceof SqlFunctionDefinition) {
            for (SqlFunctionDefinition.Prototype prototype : ((SqlFunctionDefinition)symbol).getPrototypes()) {
                DataType returnType = prototype.getReturnType().getDataType();
                if (!PgSelectFromProcedureInspection.needTypedAliasDefinition(returnType)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needTypedAliasDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyAddTypeQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private MyAddTypeQuickFix(SqlDefinition alias) {
            super((PsiElement)alias);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"add.type.element", (Object[])new Object[0]);
            if (string == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement alias, @NotNull PsiElement endElement) {
            if (project == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(3);
            }
            if (alias == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (alias instanceof SqlDefinition) {
                SqlNameElement name2 = ((SqlDefinition)alias).getNameElement();
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
                Document document = instance.getDocument(file);
                if (name2 != null && document != null) {
                    int offset = name2.getTextRange().getEndOffset();
                    String defaultType = "int";
                    document.insertString(offset, (CharSequence)(" " + defaultType));
                    instance.commitDocument(document);
                    if (editor != null) {
                        int startOffset = offset + 1;
                        editor.getCaretModel().moveToOffset(startOffset);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().setSelection(startOffset, startOffset + defaultType.length());
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRemoveTypeQuickFix
    implements LocalQuickFix {
        private MyRemoveTypeQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DatabaseBundle.message((String)"intention.family.name.remove.type.element", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlTypeElement type;
            PsiElement alias;
            if (project == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(2);
            }
            if ((alias = descriptor.getPsiElement()) instanceof SqlDefinition && (type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class)) != null) {
                type.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

