/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public final class ConverterSupport {
    private static final Formatter TIMESTAMP_FORMATTER = new CompositeFormatter(FormatterCreator.newZonedTimestampFormat(Dbms.POSTGRES, new TimestampDelegate(), null, 6), FormatterCreator.newIsoFormatter(new TimestampDelegate()));
    private static final Formatter DATE_FORMATTER = FormatterCreator.newEraDateFormatter(new DateDelegate(), null, null);
    private static final Formatter TIME_FORMATTER = new CompositeFormatter(FormatterCreator.newZonedTimeFormat(new TimeDelegate(), 6), FormatterCreator.newTimeFormat(new TimeDelegate()));
    private static final FakeRangeFormatter NUMBER_RANGE_FORMATTER = new FakeRangeFormatter(FormatterCreator.newDecimalFormat());
    private static final FakeRangeFormatter DATE_RANGE_FORMATTER = new FakeRangeFormatter(DATE_FORMATTER);
    private static final FakeRangeFormatter TIMESTAMP_RANGE_FORMATTER = new FakeRangeFormatter(TIMESTAMP_FORMATTER);

    private ConverterSupport() {
    }

    @NotNull
    public static Formatter getTimestampFormatter() {
        Formatter formatter = TIMESTAMP_FORMATTER;
        if (formatter == null) {
            ConverterSupport.$$$reportNull$$$0(0);
        }
        return formatter;
    }

    @NotNull
    public static Formatter getTimeFormatter() {
        Formatter formatter = TIME_FORMATTER;
        if (formatter == null) {
            ConverterSupport.$$$reportNull$$$0(1);
        }
        return formatter;
    }

    @NotNull
    public static Formatter getDateFormatter() {
        Formatter formatter = DATE_FORMATTER;
        if (formatter == null) {
            ConverterSupport.$$$reportNull$$$0(2);
        }
        return formatter;
    }

    @NotNull
    public static Formatter getNumberRangeFormatter() {
        FakeRangeFormatter fakeRangeFormatter = NUMBER_RANGE_FORMATTER;
        if (fakeRangeFormatter == null) {
            ConverterSupport.$$$reportNull$$$0(3);
        }
        return fakeRangeFormatter;
    }

    @NotNull
    public static Formatter getDateRangeFormatter() {
        FakeRangeFormatter fakeRangeFormatter = DATE_RANGE_FORMATTER;
        if (fakeRangeFormatter == null) {
            ConverterSupport.$$$reportNull$$$0(4);
        }
        return fakeRangeFormatter;
    }

    @NotNull
    public static Formatter getTimestampRangeFormatter() {
        FakeRangeFormatter fakeRangeFormatter = TIMESTAMP_RANGE_FORMATTER;
        if (fakeRangeFormatter == null) {
            ConverterSupport.$$$reportNull$$$0(5);
        }
        return fakeRangeFormatter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/data/types/ConverterSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestampFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberRangeFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateRangeFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestampRangeFormatter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TimeDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimeDelegate() {
            super(OffsetTime::from, temporal -> LocalTime.from(temporal).atOffset(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value2) {
            if (value2 == null) {
                TimeDelegate.$$$reportNull$$$0(0);
            }
            if (!(value2 instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value2.getClass()));
            }
            return value2 instanceof LocalTime ? ((LocalTime)value2).atOffset(DataGridFormattersUtilCore.getLocalTimeOffset()).withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset()) : (TemporalAccessor)value2;
        }

        @Override
        protected TemporalAccessor createFromTemporal(@NotNull TemporalAccessor value2) {
            if (value2 == null) {
                TimeDelegate.$$$reportNull$$$0(1);
            }
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/ConverterSupport$TimeDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toTemporalAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromTemporal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TimestampDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimestampDelegate() {
            super(OffsetDateTime::from, temporal -> LocalDateTime.from(temporal).atOffset(DataGridFormattersUtilCore.getDefaultOffset()), temporal -> LocalDate.from(temporal).atStartOfDay().atOffset(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value2) {
            if (value2 == null) {
                TimestampDelegate.$$$reportNull$$$0(0);
            }
            if (!(value2 instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value2.getClass()));
            }
            return value2 instanceof LocalDateTime ? ((LocalDateTime)value2).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset()) : (TemporalAccessor)value2;
        }

        @Override
        protected TemporalAccessor createFromTemporal(@NotNull TemporalAccessor value2) {
            if (value2 == null) {
                TimestampDelegate.$$$reportNull$$$0(1);
            }
            return value2 instanceof ZonedDateTime ? ((ZonedDateTime)value2).toOffsetDateTime() : value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/ConverterSupport$TimestampDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toTemporalAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromTemporal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

