/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtilCore;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.TestOnly;

public final class DatabaseDriverImpl
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    public static final String DRIVER_DIR = "jdbc-drivers";
    public static final String PROPERTY_DRIVER_PATH = "datagrip.driver.path";
    public static final String FIXED_CHANNEL = "fixed";
    @Nullable
    private static String ourDownloadPath;
    private final boolean myPredefined;
    private final String myId;
    private String myBaseId;
    private boolean myAbstract;
    private String myName;
    private String myComment;
    private String myDriverClass;
    private String mySqlDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    private Dbms myForcedDbms;
    private final Map<String, String> myVmEnv = new LinkedHashMap<String, String>();
    private final List<UrlTemplate> myUrlTemplates = new ArrayList<UrlTemplate>();
    private final Map<String, String> myDriverProperties = new LinkedHashMap<String, String>();
    private final Map<DatabaseDriverCore.Option<?>, String> myOptions = new LinkedHashMap();
    private String myJrePath;
    private String myInitScript;
    private String myKeepAliveQuery;
    private final List<DatabaseDriver.ArtifactRef> myArtifacts = new ArrayList<DatabaseDriver.ArtifactRef>();
    private DatabaseDriverCore.Bounds myBounds;
    private final Set<Constraint> myConstraints = new LinkedHashSet<Constraint>();
    private final List<SimpleClasspathElement> myAdditionalClasspathElements = new ArrayList<SimpleClasspathElement>();
    private final List<SimpleClasspathElement> myNativeLibraryPaths = new ArrayList<SimpleClasspathElement>();
    private final Ref<Parsers> myParsers = Ref.create();

    @NotNull
    public static @SystemDependent String getDownloadPath() {
        if (ourDownloadPath == null) {
            String propertyValue = System.getProperty(PROPERTY_DRIVER_PATH);
            ourDownloadPath = propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : PathManager.getConfigPath() + File.separator + DRIVER_DIR;
        }
        String string = ourDownloadPath;
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, false);
        this.myName = name;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Parsers getParsers() {
        Ref<Parsers> ref = this.myParsers;
        // MONITORENTER : ref
        if (this.myParsers.isNull()) {
            this.myParsers.set((Object)new Parsers(this.myUrlTemplates));
        }
        Parsers parsers = (Parsers)this.myParsers.get();
        // MONITOREXIT : ref
        if (parsers != null) return parsers;
        DatabaseDriverImpl.$$$reportNull$$$0(1);
        return parsers;
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.getParsers().templatesErrors;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        return StringUtil.isNotEmpty((String)this.myName) ? this.myName : (StringUtil.isNotEmpty((String)this.myId) ? this.myId : "???");
    }

    @Override
    @Nullable
    public String getComment() {
        return this.myComment;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(4);
        }
        this.myName = name;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.getParsers().jdbcUrlParsers;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public DatabaseDriverCore.Bounds getConnectionBounds() {
        return this.myBounds;
    }

    @Nullable
    public String getJrePath() {
        return this.myJrePath;
    }

    public void setJrePath(@Nullable String jrePath) {
        this.myJrePath = jrePath;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.getParsers().supportedLocations;
        if (enumSet == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(6);
        }
        return enumSet;
    }

    @Override
    public LocalDataSource createDataSource(@Nullable String newName) {
        LocalDataSource result2 = LocalDataSource.fromDriver(this, this.getSampleUrl(), false);
        this.setDefaultProperties(result2, true);
        result2.setName(StringUtil.notNullize((String)newName));
        return result2;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result2, boolean override) {
        if (result2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(7);
        }
        if (override) {
            result2.setInitScript(this.myInitScript);
        } else {
            result2.setInitScript(StringUtil.join(Arrays.asList(this.myInitScript, result2.getInitScript()), (String)"\n"));
        }
        result2.setDriverClass(this.myDriverClass);
        result2.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result2.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
        result2.setSchemaControl(DatabaseDriver.OPTION_SCHEMA_CONTROL.get(this));
        result2.setSourceLoading(DatabaseDriver.OPTION_SOURCE_LOADING.get(this));
        result2.setAuthProviderId(DatabaseAuthProvider.getDefault(result2).getId());
    }

    @Override
    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = driverClass;
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(9);
        }
        this.myUrlTemplates.clear();
        this.myUrlTemplates.addAll(templates);
        Ref<Parsers> ref = this.myParsers;
        synchronized (ref) {
            this.myParsers.set(null);
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(10);
        }
        return JdbcUrlParserUtilCore.select(this.getJDBCUrlParsers(), url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser2 : this.getJDBCUrlParsers()) {
            if (!parser2.getName().equals("default")) continue;
            sparser = parser2;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.getJDBCUrlParsers());
        }
        if (sparser == null) {
            return "";
        }
        JdbcUrlParser parser3 = sparser.createStateful();
        for (String p2 : parser3.getParameters()) {
            String def = parser3.getParameterDefValue(p2);
            parser3.setParameter(p2, StringUtil.notNullize((String)def));
        }
        String string = parser3.getUrlText();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public String getSqlDialect() {
        return this.mySqlDialect;
    }

    public void setSqlDialect(String dialect) {
        if (Objects.equals(dialect, this.getSqlDialect())) {
            return;
        }
        this.mySqlDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(12);
        }
        return icon;
    }

    public void setIcon(@Nullable Icon icon) {
        if (this.myIcon == icon || this.myIcon == null && icon == DatabaseIcons.UserDriver) {
            return;
        }
        this.myIcon = icon;
        Dbms dbms = DbImplUtilCore.getDbms(this);
        if (dbms == Dbms.UNKNOWN && this.myIcon != DatabaseIcons.UserDriver || dbms != Dbms.UNKNOWN && this.myIcon != dbms.getIcon()) {
            Icon icon2 = icon = icon instanceof RetrievableIcon ? ((RetrievableIcon)icon).retrieveIcon() : icon;
            if (icon != null && !(icon instanceof IconLoader.CachedImageIcon)) {
                throw new AssertionError((Object)icon.getClass().getName());
            }
            this.myIconName = icon == null ? null : ((IconLoader.CachedImageIcon)icon).getOriginalPath();
        }
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriverCore.Option<T> option) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(13);
        }
        String value2 = this.myOptions.get(option);
        return option.fromString(value2);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriverCore.Option<T> option, T value2) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(14);
        }
        if (value2 == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value2));
        }
    }

    @Override
    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Override
    @Nullable
    public Dbms getForcedDbms() {
        return this.myForcedDbms;
    }

    public void setForcedDbms(@Nullable Dbms dbms) {
        this.myForcedDbms = dbms;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @Override
    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map2 = this.myVmEnv;
        if (map2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(15);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(16);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Nullable
    public String getInitScript() {
        return this.myInitScript;
    }

    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript;
    }

    @Nullable
    public String getKeepAliveQuery() {
        return this.myKeepAliveQuery;
    }

    public void setKeepAliveQuery(@Nullable String keepAliveQuery) {
        this.myKeepAliveQuery = keepAliveQuery;
    }

    @Override
    @NotNull
    public List<DatabaseDriver.ArtifactRef> getArtifacts() {
        List<DatabaseDriver.ArtifactRef> list = this.myArtifacts;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void setArtifacts(@NotNull List<DatabaseDriver.ArtifactRef> artifacts) {
        if (artifacts == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(18);
        }
        this.myArtifacts.clear();
        this.myArtifacts.addAll(artifacts);
    }

    @Override
    public List<SimpleClasspathElement> getNativeLibraryPaths() {
        return this.myNativeLibraryPaths;
    }

    public void setNativeLibraryPaths(@NotNull List<SimpleClasspathElement> paths) {
        if (paths == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(19);
        }
        this.myNativeLibraryPaths.clear();
        this.myNativeLibraryPaths.addAll(paths);
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        return JBIterable.from(this.myArtifacts).flatten(a2 -> ((ArtifactRefImpl)a2).getElements()).append(this.myAdditionalClasspathElements).toList();
    }

    @Nullable
    public static String getDriverBaseId(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(20);
        }
        return StringUtil.nullize((String)state.getAttributeValue("based-on"));
    }

    void setAbstract(boolean a2) {
        this.myAbstract = a2;
    }

    public boolean isAbstract() {
        return this.myAbstract;
    }

    public void loadState(@NotNull Element config, boolean merge2, boolean overrideName, int format) {
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(21);
        }
        this.loadState(config, merge2, overrideName, format, null);
    }

    public void loadState(@NotNull Element config, boolean merge2, boolean overrideName, int format, @Nullable PluginDescriptor descriptor2) {
        Element keepAliveQueryElement;
        String optionName;
        ArrayList<DatabaseDriver.ArtifactRef> prev;
        Element vmOptionsElement;
        Element env;
        Element constraints;
        String name;
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(22);
        }
        PathMacroManager substitutor = DatabaseDriverImpl.getPathSubstitutor();
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge2);
        }
        this.myBaseId = DatabaseDriverImpl.getOverride(DatabaseDriverImpl.getDriverBaseId(config), this.myBaseId, merge2);
        this.myAbstract = "true".equals(config.getAttributeValue("abstract")) || this.myAbstract;
        this.myDriverClass = DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge2);
        this.myJrePath = DatabaseDriverImpl.getOverride(config.getAttributeValue("jre-path"), this.myJrePath, merge2);
        Element bounds = config.getChild("connection-bounds");
        if (!merge2) {
            this.myBounds = null;
        }
        if (bounds != null) {
            String readOnly = bounds.getAttributeValue("in-read-only");
            String boundTo = bounds.getAttributeValue("bound-to");
            LinkedHashSet<Object> rewriteParameters = new LinkedHashSet<Object>();
            for (Element param : bounds.getChildren("rewrite-parameter")) {
                name = param.getAttributeValue("name");
                boolean inUrl = "true".equals(param.getAttributeValue("in-url"));
                if (!StringUtil.isNotEmpty((String)name)) continue;
                rewriteParameters.add(Pair.create((Object)name, (Object)inUrl));
            }
            String defaultValue = bounds.getAttributeValue("default-value");
            if (!merge2 || this.myBounds == null) {
                if (this.myBounds == null) {
                    this.myBounds = new DatabaseDriverCore.Bounds();
                }
                this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                this.myBounds.defaultValue = defaultValue;
            } else {
                if (readOnly != null) {
                    this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                }
                if (boundTo != null) {
                    ObjectKind objectKind = this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                }
                if (!rewriteParameters.isEmpty()) {
                    rewriteParameters.addAll(this.myBounds.rewriteParameters);
                    this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                }
                if (defaultValue != null) {
                    this.myBounds.defaultValue = defaultValue;
                }
            }
        }
        if (!merge2) {
            this.myConstraints.clear();
        }
        if ((constraints = config.getChild("constraints")) != null) {
            this.myConstraints.clear();
            for (Element constraint : constraints.getChildren("constraint")) {
                Dbms dbms;
                String dbmsName = constraint.getAttributeValue("dbms");
                Dbms dbms2 = dbms = dbmsName == null ? null : Dbms.byName(dbmsName);
                if (dbms == null && dbmsName != null) continue;
                this.myConstraints.add(new Constraint(dbms, Version.of(constraint.getAttributeValue("from")), Version.of(constraint.getAttributeValue("to"))));
            }
        }
        this.mySqlDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.mySqlDialect, merge2);
        this.myForcedDbms = DatabaseDriverImpl.getOverride(Dbms.byName(config.getAttributeValue("forced-dbms")), this.myForcedDbms, merge2);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge2);
        if (!StringUtil.isEmpty((String)this.myIconName)) {
            ClassLoader loader = descriptor2 == null ? null : descriptor2.getPluginClassLoader();
            this.myIcon = loader == null ? IconLoader.findIcon((String)this.myIconName, DatabaseDriverImpl.class) : IconLoader.findIcon((String)this.myIconName, (ClassLoader)loader);
        } else {
            Dbms dbms = DbImplUtilCore.getDbms(this);
            this.myIcon = dbms != Dbms.UNKNOWN ? dbms.getIcon() : null;
        }
        Element remarks = config.getChild("remarks");
        if (remarks != null) {
            this.myComment = remarks.getTextTrim();
        }
        ArrayList<UrlTemplate> templates = new ArrayList<UrlTemplate>();
        if (merge2) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Object element2 : config.getChildren("url-template")) {
            name = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("template"), element2.getValue());
            if (!StringUtil.isEmpty((String)template)) {
                Iterator t = new UrlTemplate(name, template);
                if ("true".equals(element2.getAttributeValue("disable"))) {
                    templates.remove(t);
                    continue;
                }
                templates.add((UrlTemplate)((Object)t));
                continue;
            }
            templates.clear();
        }
        this.setURLTemplates(templates);
        if (!merge2) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        if ((vmOptionsElement = config.getChild("vm-options")) != null) {
            Element element3 = vmOptionsElement;
            this.myVmOptions = DatabaseDriverImpl.getOverride(element3.getTextTrim(), this.myVmOptions, merge2);
        }
        List artifacts = config.getChildren("artifact");
        ArrayList<DatabaseDriver.ArtifactRef> arrayList = prev = this.myArtifacts.isEmpty() ? Collections.emptyList() : new ArrayList<DatabaseDriver.ArtifactRef>(this.myArtifacts);
        if (!merge2) {
            this.myArtifacts.clear();
        }
        for (Element element4 : artifacts) {
            ArtifactRefImpl ref;
            String rolling;
            if (element4.getAttributes().isEmpty()) {
                this.myArtifacts.clear();
                continue;
            }
            String use = element4.getAttributeValue("use");
            if ((use != null || format < 201) && !"true".equals(use)) continue;
            String id = (String)ObjectUtils.chooseNotNull((Object)element4.getAttributeValue("id"), (Object)element4.getAttributeValue("name"));
            if (id == null && prev.size() == 1) {
                id = ((DatabaseDriver.ArtifactRef)prev.get(0)).getId();
            }
            Version version = Version.of(element4.getAttributeValue("version"));
            String channel = element4.getAttributeValue("channel");
            if (channel == null && (rolling = element4.getAttributeValue("rolling")) != null) {
                String string = channel = !Boolean.FALSE.toString().equals(rolling) ? "stable" : FIXED_CHANNEL;
            }
            if (FIXED_CHANNEL.equals(channel)) {
                channel = null;
            } else if (channel == null) {
                channel = "stable";
            }
            if ((ref = (ArtifactRefImpl)DatabaseDriverImpl.createArtifactRef(id, version, channel)) == null) continue;
            for (Element lib : element4.getChildren("library")) {
                if (substitutor != null) {
                    substitutor.expandPaths(lib);
                }
                ref.appendLegacy(SimpleClasspathElementFactory.createElements(null, (Element)lib));
            }
            Iterator it2 = prev.iterator();
            while (it2.hasNext()) {
                DatabaseDriver.ArtifactRef prevA = (DatabaseDriver.ArtifactRef)it2.next();
                if (!prevA.getId().equals(ref.getId())) continue;
                it2.remove();
                this.myArtifacts.remove(prevA);
            }
            this.myArtifacts.add(ref);
        }
        if (!merge2) {
            this.myOptions.clear();
        }
        for (Element element4 : config.getChildren("option")) {
            optionName = element4.getAttributeValue("name");
            String value2 = element4.getAttributeValue("value");
            DatabaseDriverCore.Option option = DatabaseDriverCore.Option.byName(optionName);
            if (option == null || value2 == null || value2.equals(option.getDefault().toString())) continue;
            this.myOptions.put(option, value2);
        }
        if (!merge2) {
            this.myDriverProperties.clear();
        }
        for (Element element4 : config.getChildren("property")) {
            optionName = element4.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element4.getAttributeValue("value"));
        }
        if (!merge2) {
            this.myAdditionalClasspathElements.clear();
            this.myNativeLibraryPaths.clear();
        }
        for (Element element4 : config.getChildren("library")) {
            ArrayList additional = new ArrayList();
            ArrayList<SimpleClasspathElement> natives = new ArrayList<SimpleClasspathElement>();
            if (substitutor != null) {
                substitutor.expandPaths(element4);
            }
            for (SimpleClasspathElement e : SimpleClasspathElementFactory.createElements(null, (Element)element4)) {
                boolean nativeLib = "true".equals(element4.getAttributeValue("native"));
                if (format < 201 && !nativeLib) {
                    nativeLib = ContainerUtil.exists((Iterable)e.getClassesRootUrls(), r -> (r.startsWith("sqlserver") || r.startsWith("jtds")) && r.endsWith("-win-auth.jar"));
                }
                (nativeLib ? natives : additional).add(e);
            }
            this.myAdditionalClasspathElements.addAll(additional);
            this.myNativeLibraryPaths.addAll(natives);
        }
        Element initScriptElement = config.getChild("init-script");
        if (initScriptElement != null) {
            this.myInitScript = DatabaseDriverImpl.getOverride(initScriptElement.getTextTrim(), this.myInitScript, merge2);
        }
        if ((keepAliveQueryElement = config.getChild("keep-alive-query")) != null) {
            this.myKeepAliveQuery = DatabaseDriverImpl.getOverride(keepAliveQueryElement.getTextTrim(), this.myKeepAliveQuery, merge2);
        }
    }

    @Nullable
    private static PathMacroManager getPathSubstitutor() {
        Application app = ApplicationManager.getApplication();
        return app == null ? null : PathMacroManager.getInstance((ComponentManager)app);
    }

    @Nullable
    public String getBaseId() {
        return this.myBaseId;
    }

    public Element getState(@Nullable DatabaseDriverImpl base) {
        Set<Constraint> preConstraints;
        DatabaseDriverCore.Bounds preBounds;
        Object tplElement;
        String driverClass;
        Element result2 = new Element("driver");
        result2.setAttribute("id", this.myId);
        if (this.myBaseId != null && (base == null || base.getId().equals(this.myBaseId))) {
            result2.setAttribute("based-on", this.myBaseId);
        }
        if (base == null && this.myAbstract) {
            result2.setAttribute("abstract", "true");
        }
        if (base == null || !Objects.equals(StringUtil.nullize((String)base.getName()), StringUtil.nullize((String)this.myName))) {
            result2.setAttribute("name", StringUtil.notNullize((String)this.myName));
        }
        if (!(this.mySqlDialect == null || base != null && Objects.equals(base.getSqlDialect(), this.mySqlDialect))) {
            result2.setAttribute("dialect", this.mySqlDialect);
        }
        if (this.myForcedDbms != null) {
            result2.setAttribute("forced-dbms", this.myForcedDbms.getName());
        }
        String string = driverClass = base == null ? null : StringUtil.nullize((String)base.getDriverClass());
        if (!StringUtil.isEmpty((String)this.myDriverClass) && !Objects.equals(StringUtil.nullize((String)this.myDriverClass), driverClass)) {
            result2.setAttribute("driver-class", this.myDriverClass);
        }
        if (StringUtil.isNotEmpty((String)this.myJrePath)) {
            result2.setAttribute("jre-path", this.myJrePath);
        }
        if (base == null && StringUtil.isNotEmpty((String)this.myIconName) || base != null && !Objects.equals(base.myIconName, this.myIconName)) {
            result2.setAttribute("icon", this.myIconName);
        }
        if (base == null && !StringUtil.isEmpty((String)this.myComment) || base != null && !Objects.equals(base.myComment, this.myComment)) {
            result2.addContent(new Element("remarks").addContent(this.myComment));
        }
        HashSet<UrlTemplate> predefTemplates = base == null ? Collections.emptySet() : new HashSet<UrlTemplate>(base.myUrlTemplates);
        for (UrlTemplate template : predefTemplates) {
            if (StringUtil.isEmpty((String)template.getTemplate()) || this.myUrlTemplates.contains(template)) continue;
            tplElement = new Element("url-template");
            tplElement.setAttribute("name", template.getName());
            tplElement.setAttribute("template", template.getTemplate());
            tplElement.setAttribute("disable", "true");
            result2.addContent((Element)tplElement);
        }
        for (UrlTemplate template : this.myUrlTemplates) {
            if (StringUtil.isEmpty((String)template.getTemplate()) || predefTemplates.contains(template)) continue;
            tplElement = new Element("url-template");
            tplElement.setAttribute("name", template.getName());
            tplElement.setAttribute("template", template.getTemplate());
            result2.addContent((Element)tplElement);
        }
        DatabaseDriverCore.Bounds bounds = preBounds = base == null ? null : base.getConnectionBounds();
        if (this.myBounds != null && !Comparing.equal((Object)this.myBounds, (Object)preBounds)) {
            Element bounds2 = new Element("connection-bounds");
            if (preBounds == null) {
                preBounds = new DatabaseDriverCore.Bounds();
            }
            if (!Comparing.equal((Object)this.myBounds.inReadOnlyMode, (Object)preBounds.inReadOnlyMode)) {
                bounds2.setAttribute("in-read-only", Boolean.toString(this.myBounds.inReadOnlyMode));
            }
            if (!Comparing.equal((Object)this.myBounds.boundTo, (Object)preBounds.boundTo)) {
                bounds2.setAttribute("bound-to", this.myBounds.boundTo.code());
            }
            if (!Comparing.equal(this.myBounds.rewriteParameters, preBounds.rewriteParameters)) {
                for (Pair pair : this.myBounds.rewriteParameters) {
                    Element element2 = new Element("rewrite-parameter");
                    element2.setAttribute("name", (String)pair.first);
                    if (((Boolean)pair.second).booleanValue()) {
                        element2.setAttribute("in-url", "true");
                    }
                    bounds2.addContent(element2);
                }
            }
            if (!Objects.equals(this.myBounds.defaultValue, preBounds.defaultValue)) {
                bounds2.setAttribute("default-value", StringUtil.notNullize((String)this.myBounds.defaultValue));
            }
            result2.addContent(bounds2);
        }
        Set<Constraint> set = preConstraints = base == null ? null : base.getConstraints();
        if (!Comparing.equal(this.myConstraints, preConstraints) && !this.myConstraints.isEmpty()) {
            Element constraints = new Element("constraints");
            for (Constraint constraint : this.myConstraints) {
                Element c2 = new Element("constraint");
                if (constraint.dbms != null) {
                    c2.setAttribute("dbms", constraint.dbms.getName());
                }
                if (constraint.from != null) {
                    c2.setAttribute("from", constraint.from.toString());
                }
                if (constraint.to != null) {
                    c2.setAttribute("to", constraint.to.toString());
                }
                constraints.addContent(c2);
            }
            result2.addContent(constraints);
        }
        if (base == null || !this.myArtifacts.equals(base.getArtifacts())) {
            Collection<DatabaseDriver.ArtifactRef> artifacts;
            if (base == null) {
                artifacts = this.myArtifacts;
            } else {
                LinkedHashMap<String, DatabaseDriver.ArtifactRef> linkedHashMap = new LinkedHashMap<String, DatabaseDriver.ArtifactRef>();
                for (DatabaseDriver.ArtifactRef artifact : this.myArtifacts) {
                    linkedHashMap.put(artifact.getId(), artifact);
                }
                if (ContainerUtil.find(base.myArtifacts, ba -> !extra.containsKey(ba.getId())) != null) {
                    artifacts = this.myArtifacts;
                    result2.addContent(new Element("artifact"));
                } else {
                    for (DatabaseDriver.ArtifactRef ba2 : base.myArtifacts) {
                        if (!ba2.equals(linkedHashMap.get(ba2.getId()))) continue;
                        linkedHashMap.remove(ba2.getId());
                    }
                    artifacts = linkedHashMap.values();
                }
            }
            for (DatabaseDriver.ArtifactRef artifactRef : artifacts) {
                Element artifactElement = new Element("artifact");
                artifactElement.setAttribute("id", artifactRef.getId());
                artifactElement.setAttribute("name", artifactRef.getId());
                String channel = artifactRef.getChannel();
                if (!"stable".equals(channel)) {
                    artifactElement.setAttribute("channel", StringUtil.notNullize((String)channel, (String)FIXED_CHANNEL));
                    artifactElement.setAttribute("rolling", Boolean.toString(channel != null));
                }
                artifactElement.setAttribute("use", Boolean.TRUE.toString());
                if (artifactRef.getArtifactVersion() != null) {
                    artifactElement.setAttribute("version", artifactRef.getArtifactVersion().toString());
                } else {
                    DatabaseDriverImpl.serializeClassPathElements(artifactElement, ((ArtifactRefImpl)artifactRef).getElements(), null);
                }
                result2.addContent(artifactElement);
            }
        }
        for (DatabaseDriverCore.Option option : this.myOptions.keySet()) {
            Object object = ObjectUtils.notNull(base == null ? null : base.getOption(option), option.getDefault());
            String strValue = this.myOptions.get(option);
            Object value2 = option.fromString(strValue);
            if (Objects.equals(value2, object)) continue;
            Element e2 = new Element("option");
            e2.setAttribute("name", option.getName());
            e2.setAttribute("value", strValue);
            result2.addContent(e2);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e3 = new Element("vm-options");
            e3.setText(this.myVmOptions);
            result2.addContent(e3);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String string2 : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", string2);
                prop.setAttribute("value", this.myVmEnv.get(string2));
                env.addContent(prop);
            }
            result2.addContent(env);
        }
        Map<Object, Object> predefProps = base == null ? Collections.emptyMap() : base.getDriverProperties();
        for (Map.Entry<String, String> entry : this.myDriverProperties.entrySet()) {
            if (Objects.equals(predefProps.get(entry.getKey()), entry.getValue())) continue;
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", entry.getKey());
            optionElement.setAttribute("value", entry.getValue());
            result2.addContent(optionElement);
        }
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myAdditionalClasspathElements, null);
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myNativeLibraryPaths, "native");
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            Element element3 = new Element("init-script");
            element3.setText(this.myInitScript);
            result2.addContent(element3);
        }
        if (StringUtil.isNotEmpty((String)this.myKeepAliveQuery)) {
            Element element4 = new Element("keep-alive-query");
            element4.setText(this.myKeepAliveQuery);
            result2.addContent(element4);
        }
        return result2;
    }

    private static void serializeClassPathElements(Element result2, List<SimpleClasspathElement> classpathElements, String extra) {
        PathMacroManager substitutor = DatabaseDriverImpl.getPathSubstitutor();
        for (SimpleClasspathElement cpe : classpathElements) {
            Element libraryElement = new Element("library");
            try {
                cpe.serialize(libraryElement);
                if (substitutor != null) {
                    substitutor.collapsePaths(libraryElement);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            if (extra != null) {
                libraryElement.setAttribute(extra, "true");
            }
            result2.addContent(libraryElement);
        }
    }

    private static <T> T getIfNotNull(T value2, T defaultValue) {
        return value2 == null || value2 instanceof String && StringUtil.isEmpty((String)((String)value2)) ? defaultValue : value2;
    }

    private static <T> T getOverride(T value2, T oldValue, boolean merge2) {
        return merge2 ? DatabaseDriverImpl.getIfNotNull(value2, oldValue) : value2;
    }

    @Override
    public void setAdditionalClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myAdditionalClasspathElements.clear();
        this.myAdditionalClasspathElements.addAll(classpathElements);
    }

    @Override
    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements() {
        List<SimpleClasspathElement> list = this.myAdditionalClasspathElements;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @NotNull
    public DatabaseDriverImpl copy(@Nullable String newName, boolean withId) {
        DatabaseDriverImpl result2 = new DatabaseDriverImpl(withId ? this.myId : null, (String)ObjectUtils.chooseNotNull((Object)newName, (Object)this.myName), null, null);
        result2.loadState(this.getState(null), false, false, Integer.MAX_VALUE);
        DatabaseDriverImpl databaseDriverImpl = result2;
        if (databaseDriverImpl == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(24);
        }
        return databaseDriverImpl;
    }

    public boolean equalConfiguration(DatabaseDriverImpl o, boolean ignoreClassPath) {
        if (!Objects.equals(StringUtil.nullize((String)this.myName), StringUtil.nullize((String)o.myName))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!this.myArtifacts.equals(o.myArtifacts)) {
            return false;
        }
        if (!ignoreClassPath && !this.myAdditionalClasspathElements.equals(o.myAdditionalClasspathElements)) {
            return false;
        }
        if (!ignoreClassPath && !this.myNativeLibraryPaths.equals(o.myNativeLibraryPaths)) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.mySqlDialect), StringUtil.nullize((String)o.mySqlDialect))) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myDriverClass), StringUtil.nullize((String)o.myDriverClass))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myBounds, (Object)o.myBounds)) {
            return false;
        }
        if (!Objects.equals(this.myJrePath, o.myJrePath)) {
            return false;
        }
        if (!Objects.equals(this.myForcedDbms, o.myForcedDbms)) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        for (DatabaseDriverCore.Option<?> option : DatabaseDriverCore.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o.getOption(option))) continue;
            return false;
        }
        if (!this.myUrlTemplates.equals(o.myUrlTemplates)) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myVmOptions), StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!ContainerUtil.diff(this.myVmEnv, o.myVmEnv).isEmpty()) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myInitScript), StringUtil.nullize((String)o.myInitScript))) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myKeepAliveQuery), StringUtil.nullize((String)o.myKeepAliveQuery))) {
            return false;
        }
        return Comparing.equal((Object)this.myIcon, (Object)o.myIcon);
    }

    public boolean equalConfiguration(DatabaseDriverImpl o) {
        return this.equalConfiguration(o, false);
    }

    public String toString() {
        return DatabaseDriverImpl.class.getSimpleName() + "{myId='" + this.myId + "', myName='" + this.myName + "'}";
    }

    @TestOnly
    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(25);
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.getDriverClass()).append("\n");
        sb.append("Dialect - ").append(this.getSqlDialect()).append("\n");
        sb.append("IconName - ").append(this.myIconName).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        sb.append("DriverProperties").append("\n");
        for (Map.Entry entry : this.getDriverProperties().entrySet()) {
            sb.append(" * ").append((String)entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        if (this.myArtifacts.isEmpty()) {
            sb.append("ArtifactName - null\n");
        }
        for (DatabaseDriver.ArtifactRef artifactRef : this.myArtifacts) {
            sb.append("ArtifactName - ").append(artifactRef.getId()).append("\n");
            for (SimpleClasspathElement element2 : ((ArtifactRefImpl)artifactRef).getElements()) {
                sb.append(" * ").append(element2.getPresentableName()).append("\n");
            }
        }
        sb.append("Bounds - ");
        if (this.myBounds != null) {
            sb.append("boundTo: ").append(this.myBounds.boundTo);
            sb.append("defaultValue: ").append(this.myBounds.defaultValue);
            sb.append("inReadOnlyMode: ").append(this.myBounds.inReadOnlyMode);
            sb.append("rewriteParameters:");
            for (Pair pair : this.myBounds.rewriteParameters) {
                sb.append(" ").append((String)pair.first);
                if (!((Boolean)pair.second).booleanValue()) continue;
                sb.append(":in-url");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n");
        sb.append("ClasspathElements").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getAdditionalClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            sb.append("initScript: ").append(this.myInitScript).append("\n");
        }
    }

    @NotNull
    public Set<Constraint> getConstraints() {
        Set<Constraint> set = this.myConstraints;
        if (set == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    public List<SimpleClasspathElement> getArtifactClasspathElements() {
        List list = JBIterable.from(this.myArtifacts).flatten(a2 -> ((ArtifactRefImpl)a2).getElements()).toList();
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    public static DatabaseDriver.ArtifactRef createArtifactRef(@Nullable String id, @Nullable Version version, String channel) {
        return StringUtil.isEmpty((String)id) ? null : new ArtifactRefImpl(id, version, channel);
    }

    public static boolean matches(@NotNull DatabaseDriver.ArtifactRef ref, @NotNull DatabaseArtifactList.ArtifactVersion v) {
        if (ref == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(28);
        }
        if (v == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(29);
        }
        return DatabaseDriverImpl.matches(ref, v.artifact) && Objects.equals(ref.getArtifactVersion(), v.version);
    }

    public static boolean matches(@NotNull DatabaseDriver.ArtifactRef ref, @NotNull DatabaseArtifactList.Artifact a2) {
        if (ref == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(30);
        }
        if (a2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(31);
        }
        return a2.isId(ref.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJDBCUrlParsers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLocations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalClasspathElements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactClasspathElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setURLTemplates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setArtifacts";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setNativeLibraryPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDriverBaseId";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Constraint {
        @Nullable
        public final Dbms dbms;
        @Nullable
        public final Version from;
        @Nullable
        public final Version to;

        Constraint(@Nullable Dbms dbms, @Nullable Version from, @Nullable Version to) {
            this.dbms = dbms;
            this.from = from;
            this.to = to;
        }

        public boolean matches(@NotNull Dbms dbms, @Nullable Version version) {
            if (dbms == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            if (this.dbms != null && dbms != this.dbms) {
                return false;
            }
            if (version == null) {
                return true;
            }
            if (this.from != null && version.less(this.from)) {
                return false;
            }
            return this.to == null || !version.isOrGreater(this.to);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constraint that = (Constraint)o;
            return Objects.equals(this.dbms, that.dbms) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.dbms, this.from, this.to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dataSource/DatabaseDriverImpl$Constraint", "matches"));
        }
    }

    private static class Parsers {
        final List<StatelessJdbcUrlParser> jdbcUrlParsers = new ArrayList<StatelessJdbcUrlParser>();
        final EnumSet<StatelessJdbcUrlParser.LocationType> supportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);
        final List<Pair<UrlTemplate, String>> templatesErrors = new ArrayList<Pair<UrlTemplate, String>>();

        Parsers(List<UrlTemplate> templates) {
            for (UrlTemplate template : templates) {
                try {
                    StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.INSTANCE);
                    this.jdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
                }
                catch (StatelessTextDecomposition.InvalidTemplateException e) {
                    Application application = ApplicationManager.getApplication();
                    if (application == null || application.isUnitTestMode()) {
                        throw new RuntimeException(e);
                    }
                    this.templatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e.getMessage()));
                }
            }
            for (StatelessJdbcUrlParser p2 : this.jdbcUrlParsers) {
                this.supportedLocations.addAll(p2.getPossibleLocations());
            }
        }
    }

    private static final class ArtifactRefImpl
    implements DatabaseDriver.ArtifactRef {
        private final String myChannel;
        private final String myId;
        private final Version myVersion;
        private final List<SimpleClasspathElement> myLegacyElements;

        private ArtifactRefImpl(@NotNull String id, @Nullable Version version, String channel) {
            if (id == null) {
                ArtifactRefImpl.$$$reportNull$$$0(0);
            }
            this.myLegacyElements = new ArrayList<SimpleClasspathElement>();
            this.myId = id;
            this.myVersion = version;
            this.myChannel = channel;
        }

        public void appendLegacy(@NotNull List<SimpleClasspathElement> items2) {
            if (items2 == null) {
                ArtifactRefImpl.$$$reportNull$$$0(1);
            }
            if (items2.isEmpty()) {
                return;
            }
            this.myLegacyElements.addAll(items2);
        }

        @NotNull
        public List<SimpleClasspathElement> getElements() {
            if (this.myVersion == null) {
                List<SimpleClasspathElement> list = this.myLegacyElements;
                if (list == null) {
                    ArtifactRefImpl.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<SimpleClasspathElement> list = DatabaseArtifactManager.getClasspathElements(this.myId, this.myVersion);
            if (list == null) {
                ArtifactRefImpl.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                ArtifactRefImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactRefImpl ref = (ArtifactRefImpl)o;
            if (!Objects.equals(this.myChannel, ref.myChannel)) {
                return false;
            }
            if (!this.myId.equals(ref.myId)) {
                return false;
            }
            if (!Objects.equals(this.myVersion, ref.myVersion)) {
                return false;
            }
            return Objects.equals(this.myLegacyElements, ref.myLegacyElements);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.myChannel);
            result2 = 31 * result2 + this.myId.hashCode();
            result2 = 31 * result2 + Objects.hashCode(this.myVersion);
            result2 = 31 * result2 + Objects.hashCode(this.myLegacyElements);
            return result2;
        }

        @Override
        @Nullable
        public Version getArtifactVersion() {
            return this.myVersion;
        }

        @Override
        public String getChannel() {
            return this.myChannel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendLegacy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

