/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlPropertiesPanel
implements Disposable {
    public static final int ROW_LENGTH = 6;
    private final Map<String, TypesRegistry.ParamEditor> myFields;
    private final DataInterchange myDataInterchange;
    private final boolean myAuthSupported;
    private final boolean myEmpty;
    private final JComponent myHeadComponent;
    private final JComponent myTailComponent;
    private static final List<String> TO_REMOVE = Arrays.asList("user", "password");
    private static final List<String> HEADS = Arrays.asList("host", "port", "project", "SID", "tns_name", "service", "instance", "driver", "file", "path", "localdb_pipe");
    private static final List<String> TAILS = Arrays.asList("database", "schema");

    public UrlPropertiesPanel(@NotNull StatelessParametersHolder parametersHolder, @NotNull DataInterchange dataInterchange, final @NotNull Runnable focusCallback) {
        if (parametersHolder == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(1);
        }
        if (focusCallback == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(2);
        }
        this.myFields = new HashMap<String, TypesRegistry.ParamEditor>();
        this.myDataInterchange = dataInterchange;
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                focusCallback.run();
            }

            @Override
            public void focusLost(FocusEvent e) {
                focusCallback.run();
            }
        };
        ArrayList<String> parameters = new ArrayList<String>(parametersHolder.getParameters());
        this.myDataInterchange.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TypesRegistry.ParamEditor editor = UrlPropertiesPanel.this.myFields.get(evt.getPropertyName());
                String value2 = StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class)));
                if (editor != null && !editor.getText().equals(value2)) {
                    editor.setText(value2);
                }
            }
        }, this);
        this.myAuthSupported = JdbcUrlParserUtil.isAuthSupported(parametersHolder);
        Couple<List<String>> params = UrlPropertiesPanel.processParameters(parameters);
        this.myHeadComponent = this.createComponent((List)params.first, parametersHolder, focusListener);
        this.myTailComponent = this.createComponent((List)params.second, parametersHolder, focusListener);
        for (Map.Entry<String, TypesRegistry.ParamEditor> entry : this.myFields.entrySet()) {
            entry.getValue().setChangeListener(() -> this.myDataInterchange.putProperty((String)entry.getKey(), ((TypesRegistry.ParamEditor)entry.getValue()).getText()));
        }
        this.myEmpty = this.myHeadComponent == null && this.myTailComponent == null;
    }

    @Nullable
    private JComponent createComponent(@NotNull List<String> params, @NotNull StatelessParametersHolder parametersHolder, FocusListener focusListener) {
        List<List<TypesRegistry.ParamEditor>> layoutData;
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(3);
        }
        if (parametersHolder == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(4);
        }
        if ((layoutData = UrlPropertiesPanel.getLayout(parametersHolder, params, this.myDataInterchange, this.myFields)).isEmpty()) {
            return null;
        }
        for (List<TypesRegistry.ParamEditor> entries : layoutData) {
            for (TypesRegistry.ParamEditor paramEditor : entries) {
                Disposer.register((Disposable)this, (Disposable)paramEditor);
                paramEditor.addFocusListener(focusListener);
            }
        }
        JPanel comp = new JPanel((LayoutManager)new GridLayoutManager(layoutData.size(), 6));
        int row = 0;
        for (List list : layoutData) {
            int column2 = 0;
            for (TypesRegistry.ParamEditor editor : list) {
                int span;
                if (editor.getCaption() != null) {
                    JBLabel label = new JBLabel(editor.getCaption());
                    if (column2 != 0) {
                        label.setBorder(UrlPropertiesPanel.innerLabelBorder());
                    }
                    comp.add((Component)label, UrlPropertiesPanel.createLabelConstraints(row, column2, label.getPreferredSize().getWidth()));
                }
                if (column2 == 0) {
                    ++column2;
                    span = list.size() < 2 && editor.getFieldSize() != FieldSize.SMALL ? 5 : 3;
                } else if (editor.getCaption() != null) {
                    ++column2;
                    span = 1;
                } else {
                    span = 2;
                }
                comp.add((Component)editor.getComponent(), UrlPropertiesPanel.createSimpleConstraints(row, column2, span));
                column2 += span;
            }
            ++row;
        }
        return comp;
    }

    @NotNull
    public static Border innerLabelBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyLeft((int)10);
        if (jBEmptyBorder == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(5);
        }
        return jBEmptyBorder;
    }

    public void dispose() {
    }

    @Nullable
    public JComponent getHeadComponent() {
        return this.myHeadComponent;
    }

    @Nullable
    public JComponent getTailComponent() {
        return this.myTailComponent;
    }

    public static GridConstraints createLabelConstraints(int row, int col, double width) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, 0, 3, (int)width, false);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int rowSpan, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, rowSpan, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createRowConstraints(int row) {
        return UrlPropertiesPanel.createConstraints(row, 0, 6, 1, 1, -1, false);
    }

    public static GridConstraints createAlignedConstraints(int row, int col, int colSpan, int anchor2) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, anchor2, 0, -1, false);
    }

    public static void drawLayout(GridLayoutManager l, Component comp, Graphics g, Color c2) {
        g.setColor(c2);
        for (int x : l.getVerticalGridLines()) {
            g.drawLine(x, 0, x, comp.getHeight());
        }
        for (int y : l.getHorizontalGridLines()) {
            g.drawLine(0, y, comp.getWidth(), y);
        }
    }

    public static GridConstraints createConstraints(int row, int col, int colSpan, int anchor2, int fill, int prefWidth, boolean rubber) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, colSpan, anchor2, fill, prefWidth, rubber);
    }

    public static GridConstraints createConstraints(int row, int col, int rowSpan, int colSpan, int anchor2, int fill, int prefWidth, boolean rubber) {
        Dimension nonPref = new Dimension(-1, -1);
        Dimension pref = new Dimension(prefWidth == -1 ? 100 : prefWidth, -1);
        return new GridConstraints(row, col, rowSpan, colSpan, anchor2, fill, UrlPropertiesPanel.getPolicy(rubber), 0, nonPref, pref, nonPref, 0, true);
    }

    public static int getPolicy(boolean rubber) {
        return rubber ? 7 : 0;
    }

    private static boolean isPair(@Nullable String param1, @Nullable String param2, Map<String, TypesRegistry.ParamEditor> fields) {
        if (param1 == null || param2 == null) {
            return false;
        }
        if (param1.equals("host") && param2.equals("port")) {
            return true;
        }
        return fields.get(param2).getFieldSize() == FieldSize.SMALL;
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    @NotNull
    private static Couple<List<String>> processParameters(@NotNull List<String> params) {
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(6);
        }
        ArrayList<String> head = new ArrayList<String>();
        ArrayList tail = new ArrayList();
        for (String param : params) {
            Boolean h = UrlPropertiesPanel.isHead(param);
            if (h == null) continue;
            (h != false ? head : tail).add(param);
        }
        ContainerUtil.sort(head, Comparator.comparing(p2 -> UrlPropertiesPanel.priority(HEADS, p2)));
        ContainerUtil.sort(tail, Comparator.comparing(p2 -> UrlPropertiesPanel.priority(TAILS, p2)));
        Couple couple = Couple.of(head, tail);
        if (couple == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(7);
        }
        return couple;
    }

    private static int priority(List<String> list, String o) {
        int idx = list.indexOf(o);
        return idx == -1 ? Integer.MAX_VALUE : idx;
    }

    private static Boolean isHead(@Nullable String param) {
        if (TO_REMOVE.contains(param)) {
            return null;
        }
        return HEADS.contains(param);
    }

    public boolean isAuthSupported() {
        return this.myAuthSupported;
    }

    private static List<List<TypesRegistry.ParamEditor>> getLayout(@NotNull StatelessParametersHolder parser2, @NotNull List<String> params, @NotNull DataInterchange interchange, @NotNull Map<String, TypesRegistry.ParamEditor> fields) {
        if (parser2 == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(8);
        }
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(9);
        }
        if (interchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(10);
        }
        if (fields == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(11);
        }
        ArrayList<TypesRegistry.ParamEditor> editors = new ArrayList<TypesRegistry.ParamEditor>();
        HashMap<TypesRegistry.ParamEditor, String> paramNames = new HashMap<TypesRegistry.ParamEditor, String>();
        for (String param : params) {
            TypesRegistry.TypeDescriptor descriptor2;
            String type = parser2.getParameterType(param);
            if (type == null || type.startsWith("#") || (descriptor2 = TypesRegistry.INSTANCE.get(type)) == null) continue;
            editors.addAll(descriptor2.createSatellites(interchange));
            TypesRegistry.ParamEditor field = descriptor2.createField(param, parser2.getParameterConfig(param), interchange);
            editors.add(field);
            fields.put(param, field);
            paramNames.put(field, param);
        }
        ArrayList<List<TypesRegistry.ParamEditor>> res2 = new ArrayList<List<TypesRegistry.ParamEditor>>();
        for (TypesRegistry.ParamEditor editor : editors) {
            boolean append;
            ArrayList<TypesRegistry.ParamEditor> curRow = (ArrayList<TypesRegistry.ParamEditor>)ContainerUtil.getLastItem(res2);
            TypesRegistry.ParamEditor prev = (TypesRegistry.ParamEditor)ContainerUtil.getLastItem((List)curRow);
            assert (prev == null || curRow != null);
            boolean bl = append = prev != null && curRow.size() < 2 && UrlPropertiesPanel.isPair((String)paramNames.get(prev), (String)paramNames.get(editor), fields);
            if (curRow == null || !append) {
                curRow = new ArrayList<TypesRegistry.ParamEditor>(1);
                res2.add(curRow);
            }
            curRow.add(editor);
        }
        return res2;
    }

    @Nullable
    public String getActiveParameter() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        for (Map.Entry<String, TypesRegistry.ParamEditor> entry : this.myFields.entrySet()) {
            if (!entry.getValue().getComponent().isAncestorOf(owner)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public DataInterchange getDataInterchange() {
        DataInterchange dataInterchange = this.myDataInterchange;
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(12);
        }
        return dataInterchange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataInterchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusCallback";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "innerLabelBorder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataInterchange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

