/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.editor.GotoRowAction;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridPositionWidget
implements StatusBarWidget,
Consumer<MouseEvent>,
StatusBarWidget.TextPresentation,
StatusBarWidget.Multiframe,
FileEditorManagerListener {
    public static final String POSITION_WIDGET_HELPER_KEY = "ResultViewPositionWidgetHelper";
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE);
    private static final String ID = "GridPosition";
    private final Project myProject;
    private DataGrid myGrid;
    private PositionWidgetHelper myHelper;

    public GridPositionWidget(@NotNull Project project) {
        if (project == null) {
            GridPositionWidget.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        GridPositionWidget gridPositionWidget = this;
        if (gridPositionWidget == null) {
            GridPositionWidget.$$$reportNull$$$0(1);
        }
        return gridPositionWidget;
    }

    public void install(final @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridPositionWidget.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection2.subscribe(TOPIC, (Object)new Listener(){

            @Override
            public void changed(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridPositionWidget.this.set(grid, statusBar);
            }

            @Override
            public void closed() {
                GridPositionWidget.this.set(null, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridPositionWidget$1", "changed"));
            }
        });
        connection2.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataGrid grid = GridPositionWidget.this.getDataGrid(statusBar);
                GridPositionWidget.this.set(grid, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/datagrid/GridPositionWidget$2", "selectionChanged"));
            }
        });
        this.set(this.getDataGrid(statusBar), statusBar);
    }

    public void dispose() {
    }

    public void consume(MouseEvent event) {
        if (!this.isReady()) {
            return;
        }
        GotoRowAction.showGoToDialog(this.myGrid);
    }

    @Nullable
    public String getTooltipText() {
        return !this.isReady() ? null : UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]);
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        GridPositionWidget gridPositionWidget = this;
        if (gridPositionWidget == null) {
            GridPositionWidget.$$$reportNull$$$0(3);
        }
        return gridPositionWidget;
    }

    @NotNull
    public String getText() {
        if (this.myHelper == null) {
            return "";
        }
        String string = this.myHelper.getText();
        if (string == null) {
            GridPositionWidget.$$$reportNull$$$0(4);
        }
        return string;
    }

    public float getAlignment() {
        return 1.0f;
    }

    public StatusBarWidget copy() {
        return new GridPositionWidget(this.myProject);
    }

    @Nullable
    private DataGrid getDataGrid(@NotNull StatusBar bar) {
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((StatusBar)bar);
        return fileEditor instanceof TableEditorBase ? ((TableEditorBase)fileEditor).getDataGrid() : null;
    }

    private boolean isReady() {
        return this.myGrid != null && !this.myGrid.isEditing() && this.myGrid.getVisibleRowsCount() * this.myGrid.getVisibleColumns().size() > 0;
    }

    private void set(@Nullable DataGrid grid, @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridPositionWidget.$$$reportNull$$$0(6);
        }
        if (grid != null && !this.isOurGrid(grid, statusBar)) {
            return;
        }
        this.myGrid = grid;
        this.myHelper = grid == null ? null : (PositionWidgetHelper)ObjectUtils.tryCast((Object)grid.getResultView().getComponent().getClientProperty(POSITION_WIDGET_HELPER_KEY), PositionWidgetHelper.class);
        statusBar.updateWidget(this.ID());
    }

    private boolean isOurGrid(@NotNull DataGrid grid, @NotNull StatusBar bar) {
        if (grid == null) {
            GridPositionWidget.$$$reportNull$$$0(7);
        }
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(8);
        }
        return GridPositionWidget.isOurComponent((JComponent)((Object)grid.getComponent()), this.myProject, bar);
    }

    private static boolean isOurComponent(@NotNull JComponent component, @NotNull Project project, @NotNull StatusBar bar) {
        if (component == null) {
            GridPositionWidget.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GridPositionWidget.$$$reportNull$$$0(10);
        }
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(11);
        }
        return WindowManager.getInstance().getStatusBar((Component)component, project) == bar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClickConsumer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOurGrid";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isOurComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PositionWidgetHelper {
        @NlsContexts.Label
        public String getText();
    }

    static class Factory
    extends StatusBarEditorBasedWidgetFactory {
        Factory() {
        }

        @NotNull
        public String getId() {
            return GridPositionWidget.ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = DatabaseBundle.message("status.bar.grid.position.widget.display.name", new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new GridPositionWidget(project);
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            if (widget == null) {
                Factory.$$$reportNull$$$0(2);
            }
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return this.getFileEditor(statusBar) instanceof TableEditorBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridPositionWidget$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widget";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridPositionWidget$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void changed(@NotNull DataGrid var1);

        public void closed();
    }
}

