/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSelectionImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public interface SelectionModel<Row, Column> {
    public static final String SELECTION_MODEL_KEY = "SelectionModel";

    @NotNull
    public static <Row, Column> SelectionModel<Row, Column> get(@NotNull DataGrid grid, @NotNull ResultView resultView) {
        SelectionModel manager;
        if (grid == null) {
            SelectionModel.$$$reportNull$$$0(0);
        }
        if (resultView == null) {
            SelectionModel.$$$reportNull$$$0(1);
        }
        if ((manager = (SelectionModel)ObjectUtils.tryCast((Object)resultView.getComponent().getClientProperty(SELECTION_MODEL_KEY), SelectionModel.class)) == null) {
            manager = new DummySelectionModel(grid, resultView);
            resultView.getComponent().putClientProperty(SELECTION_MODEL_KEY, manager);
        }
        SelectionModel selectionModel = manager;
        if (selectionModel == null) {
            SelectionModel.$$$reportNull$$$0(2);
        }
        return selectionModel;
    }

    @NotNull
    public GridSelection<Row, Column> store();

    public void restore(@NotNull GridSelection<Row, Column> var1);

    @NotNull
    public GridSelection<Row, Column> fit(@NotNull GridSelection<Row, Column> var1);

    @NotNull
    public GridSelectionTracker getTracker();

    public void setSelection(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2);

    public void setSelection(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

    public void setRowSelection(@NotNull ModelIndexSet<Row> var1, boolean var2);

    public void setRowSelection(@NotNull ModelIndex<Row> var1, boolean var2);

    public void addRowSelection(@NotNull ModelIndexSet<Row> var1);

    public void setColumnSelection(@NotNull ModelIndexSet<Column> var1, boolean var2);

    public void setColumnSelection(@NotNull ModelIndex<Column> var1, boolean var2);

    public boolean isSelectionEmpty();

    public boolean isSelected(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

    public boolean isSelected(@NotNull ViewIndex<Row> var1, @NotNull ViewIndex<Column> var2);

    public boolean isSelectedColumn(@NotNull ModelIndex<Column> var1);

    public boolean isSelectedRow(@NotNull ModelIndex<Row> var1);

    public int getSelectedRowCount();

    public int getSelectedColumnCount();

    public void selectWholeRow();

    public void selectWholeColumn();

    @NotNull
    public ModelIndex<Row> getSelectedRow();

    @NotNull
    default public ModelIndex<Row> getLeadSelectionRow() {
        ModelIndex<Row> modelIndex = this.getSelectedRow();
        if (modelIndex == null) {
            SelectionModel.$$$reportNull$$$0(3);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndexSet<Row> getSelectedRows();

    @NotNull
    public ModelIndex<Column> getSelectedColumn();

    @NotNull
    default public ModelIndex<Column> getLeadSelectionColumn() {
        ModelIndex<Column> modelIndex = this.getSelectedColumn();
        if (modelIndex == null) {
            SelectionModel.$$$reportNull$$$0(4);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndexSet<Column> getSelectedColumns();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/SelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/SelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionRow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DummySelectionModel
    implements SelectionModel<DataConsumer.Row, DataConsumer.Column> {
        private final DataGrid myGrid;
        private final GridSelectionTracker myTracker;

        DummySelectionModel(@NotNull DataGrid grid, @NotNull ResultView view2) {
            if (grid == null) {
                DummySelectionModel.$$$reportNull$$$0(0);
            }
            if (view2 == null) {
                DummySelectionModel.$$$reportNull$$$0(1);
            }
            this.myGrid = grid;
            this.myTracker = new GridSelectionTracker(grid, view2);
        }

        @Override
        @NotNull
        public GridSelection<DataConsumer.Row, DataConsumer.Column> store() {
            return new GridSelectionImpl(ModelIndexSet.forRows(this.myGrid, new int[0]), ModelIndexSet.forColumns(this.myGrid, new int[0]));
        }

        @Override
        public void restore(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(2);
            }
        }

        @Override
        @NotNull
        public GridSelection<DataConsumer.Row, DataConsumer.Column> fit(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(3);
            }
            return new GridSelectionImpl(selection.getSelectedRows(), selection.getSelectedColumns());
        }

        @Override
        @NotNull
        public GridSelectionTracker getTracker() {
            GridSelectionTracker gridSelectionTracker = this.myTracker;
            if (gridSelectionTracker == null) {
                DummySelectionModel.$$$reportNull$$$0(4);
            }
            return gridSelectionTracker;
        }

        @Override
        public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> selection, boolean selectAtLeastOneCell) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void setSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
            if (rows == null) {
                DummySelectionModel.$$$reportNull$$$0(6);
            }
            if (columns == null) {
                DummySelectionModel.$$$reportNull$$$0(7);
            }
        }

        @Override
        public void setSelection(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                DummySelectionModel.$$$reportNull$$$0(8);
            }
            if (column2 == null) {
                DummySelectionModel.$$$reportNull$$$0(9);
            }
        }

        @Override
        public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> selection, boolean selectAtLeastOneCell) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(10);
            }
        }

        @Override
        public void addRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> selection) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(11);
            }
        }

        @Override
        public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> selection, boolean selectAtLeastOneCell) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(12);
            }
        }

        @Override
        public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> selection, boolean selectAtLeastOneCell) {
            if (selection == null) {
                DummySelectionModel.$$$reportNull$$$0(13);
            }
        }

        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                DummySelectionModel.$$$reportNull$$$0(14);
            }
            if (column2 == null) {
                DummySelectionModel.$$$reportNull$$$0(15);
            }
            return false;
        }

        @Override
        public boolean isSelected(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column2) {
            if (row == null) {
                DummySelectionModel.$$$reportNull$$$0(16);
            }
            if (column2 == null) {
                DummySelectionModel.$$$reportNull$$$0(17);
            }
            return false;
        }

        @Override
        public boolean isSelectedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
            if (column2 == null) {
                DummySelectionModel.$$$reportNull$$$0(18);
            }
            return false;
        }

        @Override
        public boolean isSelectedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                DummySelectionModel.$$$reportNull$$$0(19);
            }
            return false;
        }

        @Override
        public int getSelectedRowCount() {
            return 0;
        }

        @Override
        public int getSelectedColumnCount() {
            return 0;
        }

        @Override
        public void selectWholeRow() {
        }

        @Override
        public void selectWholeColumn() {
        }

        @Override
        @NotNull
        public ModelIndex<DataConsumer.Row> getSelectedRow() {
            ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(this.myGrid, -1);
            if (modelIndex == null) {
                DummySelectionModel.$$$reportNull$$$0(20);
            }
            return modelIndex;
        }

        @Override
        @NotNull
        public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
            ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myGrid, new int[0]);
            if (modelIndexSet == null) {
                DummySelectionModel.$$$reportNull$$$0(21);
            }
            return modelIndexSet;
        }

        @Override
        @NotNull
        public ModelIndex<DataConsumer.Column> getSelectedColumn() {
            ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(this.myGrid, -1);
            if (modelIndex == null) {
                DummySelectionModel.$$$reportNull$$$0(22);
            }
            return modelIndex;
        }

        @Override
        @NotNull
        public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
            ModelIndexSet<DataConsumer.Column> modelIndexSet = ModelIndexSet.forColumns(this.myGrid, new int[0]);
            if (modelIndexSet == null) {
                DummySelectionModel.$$$reportNull$$$0(23);
            }
            return modelIndexSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 4: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/SelectionModel$DummySelectionModel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 8: 
                case 14: 
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: 
                case 15: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/SelectionModel$DummySelectionModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTracker";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedRow";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedRows";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedColumn";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "restore";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fit";
                    break;
                }
                case 4: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                case 5: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setRowSelection";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelection";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addRowSelection";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumnSelection";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelectedColumn";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelectedRow";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

