/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionColorLayer
implements ColorLayer {
    private final TableResultPanel myGrid;

    public SelectionColorLayer(@NotNull TableResultPanel grid) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(3);
        }
        return grid.getSelectionModel().isSelectedRow(row) && !SelectionColorLayer.isHoveredRow(row, grid) ? this.getSelectedCellColor(grid, color) : color;
    }

    private static boolean isHoveredRow(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(5);
        }
        return SelectionColorLayer.isHoveredRow(row.toView(grid), grid);
    }

    public static boolean isHoveredRow(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull DataGrid grid) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(6);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(8);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(9);
        }
        return grid.getSelectionModel().isSelectedRow(row) ? SelectionColorLayer.getSelectedRowColor(grid, color) : this.getHeaderColor(color);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column2, @NotNull DataGrid grid, @Nullable Color color) {
        if (column2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(10);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(11);
        }
        return grid.getSelectionModel().isSelectedColumn(column2) ? SelectionColorLayer.getSelectedColumnColor(grid, color) : this.getHeaderColor(color);
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @NotNull
    private Color getHeaderColor(@Nullable Color color) {
        Color color2 = color == null ? DbUIUtil.softHighlightOf(this.myGrid.getResultView().getComponent().getBackground()) : color;
        if (color2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(12);
        }
        return color2;
    }

    @NotNull
    private Color getSelectedCellColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(13);
        }
        Color color2 = color == null ? (Color)ObjectUtils.chooseNotNull((Object)grid.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW), (Object)this.myGrid.getResultView().getComponent().getBackground()) : DbUIUtil.softHighlightOf(color);
        if (color2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(14);
        }
        return color2;
    }

    @NotNull
    private static Color getSelectedRowColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(15);
        }
        Color color2 = color == null ? SelectionColorLayer.getCurrentColor(grid) : DbUIUtil.softHighlightOf(color);
        if (color2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(16);
        }
        return color2;
    }

    @NotNull
    private static Color getSelectedColumnColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(17);
        }
        Color color2 = color == null ? SelectionColorLayer.getCurrentColor(grid) : color;
        if (color2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(18);
        }
        return color2;
    }

    @NotNull
    private static Color getCurrentColor(@NotNull DataGrid grid) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(19);
        }
        Color rowColor = grid.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW);
        Color selectedColumnBackground = (Color)ObjectUtils.chooseNotNull((Object)rowColor, (Object)UIUtil.getDecoratedRowColor());
        return new JBColor(selectedColumnBackground, selectedColumnBackground);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/color/SelectionColorLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/color/SelectionColorLayer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderColor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCellColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRowColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumnColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHoveredRow";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderBackground";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderBackground";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCellColor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRowColor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedColumnColor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

