/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDataPreviewComponent
extends DataPreviewComponent<Object> {
    private static final int PAGE_SIZE = 500;
    private final ImportEditorContext myContext;
    private final LocalDataSource myProducerDataSource;
    private final SearchPath myPath;
    private final String myQueryText;
    private ImportPanel myImportPanel;

    public DatabaseDataPreviewComponent(@NotNull ImportEditorContext context, @NotNull LocalDataSource producerDataSource, @Nullable SearchPath path, @NotNull String queryText2) {
        if (context == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(0);
        }
        if (producerDataSource == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(1);
        }
        if (queryText2 == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(2);
        }
        super(context.getBuilder());
        this.myContext = context;
        this.myProducerDataSource = producerDataSource;
        this.myPath = path;
        this.myQueryText = queryText2;
    }

    @Override
    public void setImportPanel(@NotNull ImportPanel importPanel) {
        if (importPanel == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(3);
        }
        this.myImportPanel = importPanel;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener listener2) {
        if (listener2 == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(4);
        }
    }

    @Override
    @NotNull
    public CompletionStage<DataGrid> notifyChanged(@Nullable Object object) {
        if (this.getGrid() != null) {
            CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(this.getGrid());
            if (completableFuture == null) {
                DatabaseDataPreviewComponent.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        CompletableFuture<DataGrid> future = new CompletableFuture<DataGrid>();
        Project project = this.myContext.getProject();
        GridDataHookUpManager instance = GridDataHookUpManager.getInstance(project);
        Disposable disposable2 = this.myContext.getDisposable();
        final DatabaseGridDataHookUp hookUp = instance.createReadOnlyDatabaseHookUp(this.myProducerDataSource, disposable2, this.myQueryText, (DatabaseDepartment)DGDepartment.DATA_IMPORT);
        if (this.myPath != null) {
            hookUp.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(hookUp, this.myPath, false));
        }
        final DataGrid grid = DataGridUtil.createPreviewDataGrid(Objects.requireNonNull(project), hookUp);
        Disposer.register((Disposable)disposable2, (Disposable)grid);
        hookUp.addRequestListener(new MyRequestListener(future, disposable2, grid), disposable2);
        hookUp.getPageModel().setPageSize(500);
        new UiNotifyConnector.Once((Component)((Object)Objects.requireNonNull(this.myImportPanel)), new Activatable(){

            public void showNotify() {
                hookUp.getLoader().loadFirstPage(new GridRequestSource(new DataGridRequestPlace(grid)));
            }
        });
        this.setGrid(grid);
        CompletableFuture<DataGrid> completableFuture = future;
        if (completableFuture == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(7);
        }
        return observer instanceof DatabaseTableEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setImportPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private final CompletableFuture<DataGrid> myFuture;
        private final Disposable myDisposable;
        private final DataGrid myGrid;

        private MyRequestListener(@NotNull CompletableFuture<DataGrid> future, @NotNull Disposable disposable2, @NotNull DataGrid grid) {
            if (future == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            if (disposable2 == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
            if (grid == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
            this.myFuture = future;
            this.myDisposable = disposable2;
            this.myGrid = grid;
        }

        @Override
        public void error(@NotNull GridRequestSource source, @Nullable String message2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable Throwable th) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(3);
            }
            this.complete();
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(4);
            }
            this.complete();
        }

        private void complete() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)this.myDisposable)) {
                    this.myFuture.complete(this.myGrid);
                }
            }, ModalityState.current());
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

