/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0017\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u000b"}, d2={"countDigits", "", "bigInteger", "Ljava/math/BigInteger;", "fitsIntoXlsxNumber", "", "value", "", "trimAndCountDigits", "(Ljava/lang/Number;)Ljava/lang/Integer;", "trimRightZeros", "intellij.database.connectivity"})
public final class XlsxValuesExtractorKt {
    private static final boolean fitsIntoXlsxNumber(Number value2) {
        Integer count = XlsxValuesExtractorKt.trimAndCountDigits(value2);
        return count != null && count <= 15;
    }

    private static final Integer trimAndCountDigits(Number value2) {
        try {
            BigDecimal bigDecimal = new BigDecimal(value2.toString()).stripTrailingZeros();
            try {
                BigInteger bigInteger;
                BigInteger bigInteger2 = bigInteger = bigDecimal.toBigIntegerExact();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"bigInteger");
                return XlsxValuesExtractorKt.countDigits(XlsxValuesExtractorKt.trimRightZeros(bigInteger2));
            }
            catch (ArithmeticException arithmeticException) {
                return bigDecimal.precision();
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final BigInteger trimRightZeros(BigInteger bigInteger) {
        BigInteger num = bigInteger;
        while (Intrinsics.areEqual((Object)num.remainder(BigInteger.TEN), (Object)BigInteger.ZERO) && Intrinsics.areEqual((Object)num, (Object)BigInteger.ZERO) ^ true) {
            Intrinsics.checkNotNullExpressionValue((Object)num.divide(BigInteger.TEN), (String)"num.divide(BigInteger.TEN)");
        }
        return num;
    }

    private static final int countDigits(BigInteger bigInteger) {
        BigInteger num = bigInteger;
        int count = 0;
        while (Intrinsics.areEqual((Object)num, (Object)BigInteger.ZERO) ^ true) {
            Intrinsics.checkNotNullExpressionValue((Object)num.divide(BigInteger.TEN), (String)"num.divide(BigInteger.TEN)");
            ++count;
        }
        return count;
    }

    public static final /* synthetic */ boolean access$fitsIntoXlsxNumber(Number value2) {
        return XlsxValuesExtractorKt.fitsIntoXlsxNumber(value2);
    }
}

