/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicMetaReference<S extends BasicElement, T extends BasicElement> {
    public final BasicMetaReferenceId<T> id;
    public BasicMetaObject<?> scope;
    public final BasicMetaObject<? extends T>[] targets;
    public final Function<S, T> resolver;
    public final BasicMetaPropertyId<?>[] dependencies;

    public BasicMetaReference(BasicMetaReferenceId<T> id, int targetsSize, Function<S, T> resolver, BasicMetaPropertyId<?>[] dependencies) {
        this.id = id;
        this.scope = BasicMetaObject.DEAD_BEEF;
        this.targets = new BasicMetaObject[targetsSize];
        Arrays.fill(this.targets, BasicMetaObject.DEAD_BEEF);
        this.resolver = resolver;
        this.dependencies = dependencies;
    }

    @Nullable
    public T resolve(S source) {
        return (T)((BasicElement)this.resolver.fun(source));
    }

    @NotNull
    public JBIterable<Family<T>> candidateFamilies(BasicElement source) {
        JBIterable<BasicElement> roots = this.getRoots(source);
        if (roots == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicMetaReference.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }
        HashSet inter = new HashSet();
        for (BasicMetaObject<T> basicMetaObject : this.targets) {
            for (BasicMetaObject<?> o = basicMetaObject.getParent(); o != null && o != this.scope; o = o.getParent()) {
                inter.add(o);
            }
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)BasicMetaReference.familiesTraverser().withRoots((Iterable)roots.flatten(BasicMixinElement::getFamilies))).expand(f -> inter.contains(f.getMetaObject()))).filter(f -> ArrayUtil.indexOf((Object[])this.targets, f.getMetaObject()) != -1)).traverse().map(f -> f);
        if (jBIterable == null) {
            BasicMetaReference.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    private static JBTreeTraverser<Family<?>> familiesTraverser() {
        JBTreeTraverser jBTreeTraverser = JBTreeTraverser.from(f -> f.jbi().flatten(BasicMixinElement::getFamilies));
        if (jBTreeTraverser == null) {
            BasicMetaReference.$$$reportNull$$$0(2);
        }
        return jBTreeTraverser;
    }

    @Nullable
    private JBIterable<BasicElement> getRoots(BasicElement source) {
        BasicMetaObject<?> meta = source.getMetaObject();
        if (JBIterable.generate(meta, BasicMetaObject::getParent).find(m -> m == this.scope) != null) {
            return JBIterable.generate((Object)source, BasicMixinElement::getParent).filter(o -> o.getMetaObject() == this.scope);
        }
        HashSet expand = new HashSet();
        for (BasicMetaObject<?> m2 = this.scope.getParent(); m2 != null; m2 = m2.getParent()) {
            expand.add(m2);
            if (m2 == meta) break;
        }
        if (!expand.contains(meta)) {
            return null;
        }
        return ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)BasicMetaReference.familiesTraverser().withRoots(source.getFamilies())).expand(o -> expand.contains(o.getMetaObject()))).filter(o -> o.getMetaObject() == this.scope)).traverse().flatten((Function)Functions.id());
    }

    @NotNull
    public JBIterable<T> candidates(BasicElement source) {
        JBIterable jBIterable = this.candidateFamilies(source).flatten((Function)Functions.id());
        if (jBIterable == null) {
            BasicMetaReference.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public <U extends BasicElement> BasicMetaReference<S, U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaReference.$$$reportNull$$$0(4);
        }
        if (clazz.isAssignableFrom(this.id.getValueClass())) {
            return this;
        }
        return null;
    }

    public <U extends BasicElement> BasicMetaReference<S, U> asId(@NotNull BasicMetaReferenceId<U> id) {
        if (id == null) {
            BasicMetaReference.$$$reportNull$$$0(5);
        }
        if (this.id == id) {
            return this.tryCast(id.getValueClass());
        }
        return null;
    }

    public String toString() {
        return this.id.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "candidateFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "familiesTraverser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "candidates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

