/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.AddColumnAction;
import com.intellij.database.run.actions.DeleteColumnsAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class CloneColumnAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            CloneColumnAction.$$$reportNull$$$0(0);
        }
        boolean singleColumnSelected = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && DeleteColumnsAction.getColumns(dataGrid).size() == 1;
        boolean canAddRow = DataGridUtil.canMutateColumns((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY));
        e.getPresentation().setEnabledAndVisible(singleColumnSelected && canAddRow && !DataGridUtil.getDbms(dataGrid).is(Dbms.MONGO));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ModelIndexSet<DataConsumer.Column> columns;
        if (e == null) {
            CloneColumnAction.$$$reportNull$$$0(1);
        }
        ModelIndexSet<DataConsumer.Column> modelIndexSet = columns = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null ? DeleteColumnsAction.getColumns(dataGrid) : null;
        if (columns == null || columns.size() != 1) {
            return;
        }
        ModelIndex selectedColumn = (ModelIndex)columns.asIterable().first();
        if (selectedColumn != null && selectedColumn.isValid(dataGrid)) {
            CloneColumnAction.cloneColumn(dataGrid, selectedColumn);
        }
    }

    public static void cloneColumn(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> selectedColumn) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            CloneColumnAction.$$$reportNull$$$0(2);
        }
        if (selectedColumn == null) {
            CloneColumnAction.$$$reportNull$$$0(3);
        }
        if ((mutator = DataGridUtil.getColumnsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.cloneColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), selectedColumn));
            return;
        }
        mutator.cloneColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), selectedColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/CloneColumnAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cloneColumn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

