/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionLogger
extends MeasuringDataAuditor {
    protected final LogView<?> myView;

    public SessionLogger(@NotNull LogView<?> view2) {
        if (view2 == null) {
            SessionLogger.$$$reportNull$$$0(0);
        }
        this.myView = view2;
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            SessionLogger.$$$reportNull$$$0(2);
        }
        super.jobSubmitted(request, producer);
        if (!this.skipJob(request)) {
            this.showView(request);
        }
    }

    protected boolean skipJob(@NotNull DataRequest request) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    public void print(@NotNull DataRequest.Context context, @NlsSafe @Nullable String message2) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)message2)) {
            return;
        }
        this.myView.getHistoryLogger().print(context, message2);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myView.getProject());
        if (statusBar != null) {
            statusBar.setInfo(message2, this.myView.getController().id());
        }
    }

    @Override
    public void warn(@NotNull DataRequest.Context context, @Nullable String message2) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(5);
        }
        this.myView.getHistoryLogger().warn(context, message2);
        this.bringAttentionToOutput(context, LogView.OutputType.QUERY_OUTPUT);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(6);
        }
        super.error(context, message2, th);
        Pair<@Nls String, Throwable> report = this.getLogMessageAndThrowable(message2, th);
        this.myView.getHistoryLogger().error(context, (String)report.first, (Throwable)report.second);
        this.bringAttentionToOutput(context, LogView.OutputType.ERROR);
    }

    @Override
    public void beforeStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(7);
        }
        super.beforeStatement(context);
        this.myView.addRequestToHistory(context);
    }

    @Override
    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, @Nullable LogView.OutputType outputType) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(8);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            Object owner = this.myView.getTarget();
            if (!owner.isValid()) {
                return;
            }
            boolean focusOnError = this.shouldFocusOnError(context);
            boolean wasShowing = this.myView.isShowing();
            boolean isError = outputType == LogView.OutputType.ERROR;
            Runnable runnable = () -> {
                boolean focus;
                if (!owner.isValid()) {
                    return;
                }
                Content content = this.myView.getOutputContent();
                if (content == null) {
                    return;
                }
                this.myView.getUi().setBouncing(content, true);
                boolean bl = focus = !wasShowing || isError && focusOnError;
                if (!focus) {
                    return;
                }
                this.myView.getUi().selectAndFocus(content, false, false);
                this.myView.getHistoryLogger().scrollToEnd();
            };
            if (this.shouldShowOnAttention(context)) {
                this.myView.show(this.shouldActivate(context.request), false, outputType).onSuccess(__ -> UIUtil.invokeLaterIfNeeded((Runnable)runnable));
                return;
            }
            runnable.run();
        });
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(9);
        }
        MeasuringDataAuditor.Stat queryStat = this.getStat(context);
        boolean hasErrors = queryStat.errorCount > 0L;
        NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
        String query = context.getQuery();
        String text2 = DatabaseBundle.message("notification.content.choice.request.href.choice.failed.completed", StringUtil.trimMiddle((String)query, (int)60), query.isEmpty() ? 0 : 1, hasErrors ? 0 : 1);
        SessionLogger.fireBackToConsoleNotification(this.myView, type, text2);
    }

    @NotNull
    protected Pair<String, Throwable> getLogMessageAndThrowable(@Nls @Nullable String message2, @Nullable Throwable throwable) {
        Pair pair = Pair.create((Object)message2, (Object)throwable);
        if (pair == null) {
            SessionLogger.$$$reportNull$$$0(10);
        }
        return pair;
    }

    protected boolean shouldFocusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(11);
        }
        return true;
    }

    protected boolean shouldShowOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(12);
        }
        return false;
    }

    private static void fireBackToConsoleNotification(@NotNull LogView<?> view2, @NotNull NotificationType type, @NlsContexts.NotificationContent @NotNull String text2) {
        if (view2 == null) {
            SessionLogger.$$$reportNull$$$0(13);
        }
        if (type == null) {
            SessionLogger.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            SessionLogger.$$$reportNull$$$0(15);
        }
        String title = view2.getTitle();
        final WeakReference viewRef = new WeakReference(view2);
        DatabaseNotifications.DATABASE_LONG_RUNNING_GROUP.createNotification(title, text2, type).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                LogView view2;
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((view2 = (LogView)viewRef.get()) != null) {
                    view2.show(true, false);
                } else {
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/audit/SessionLogger$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(view2.getProject());
        SystemNotifications.getInstance().notify("SessionLogger", title, StringUtil.stripHtml((String)text2, (boolean)true));
    }

    private void showView(@NotNull DataRequest request) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(16);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ModalityUiUtil.invokeLaterIfNeeded(() -> {
            if (!this.myView.getTarget().isValid()) {
                return;
            }
            if (this.myView.getContent().getManager() == null) {
                this.myView.show(this.shouldActivate(request), false, LogView.OutputType.LOG);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    protected boolean shouldActivate(@NotNull DataRequest request) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(17);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/audit/SessionLogger";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/audit/SessionLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessageAndThrowable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jobSubmitted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipJob";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionToOutput";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionByNotification";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldFocusOnError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowOnAttention";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireBackToConsoleNotification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showView";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

