/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.FormattedModeHandlerKt;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eR \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "enabled", "", "formatCache", "Lcom/intellij/database/run/ui/FormattedModeHandler$FormatCache;", "isEnabled", "minimize", "", "file", "Lcom/intellij/psi/PsiFile;", "reformat", "setEnabled", "v", "supportsCurrentValue", "Companion", "FormatCache", "intellij.database.impl"})
public final class FormattedModeHandler {
    private boolean enabled;
    private FormatCache formatCache;
    private final DataGrid grid;
    private final Document document;
    private final Project project;
    private final Function1<Function0<Unit>, Unit> disableUpdateListener;
    @NotNull
    public static final String FORMATTED_MODE_DISABLED = "EditMaximizedView.FORMATTED_MODE_DISABLED";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean v) {
        PropertiesComponent.getInstance().setValue(FORMATTED_MODE_DISABLED, !v);
        this.enabled = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean supportsCurrentValue() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.document);
        if (!(virtualFile instanceof LightVirtualFile)) {
            virtualFile = null;
        }
        LightVirtualFile lightVirtualFile = (LightVirtualFile)virtualFile;
        if (lightVirtualFile == null) return false;
        LightVirtualFile file = lightVirtualFile;
        Object value2 = FormattedModeHandlerKt.getSelectedValue(this.grid);
        if (!(value2 instanceof Map) && !(value2 instanceof List)) {
            if (!(value2 instanceof String)) return false;
            String string = (String)value2;
            boolean bl = false;
            if (StringUtil.containsLineBreak((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString())) return false;
        }
        if (file.getLanguage() instanceof JsonLanguage) return true;
        if (file.getLanguage() instanceof XMLLanguage) return true;
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)MongoJSLanguage.INSTANCE))) return false;
        return true;
    }

    public final void reformat() {
        if (!this.enabled || !this.supportsCurrentValue()) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this){
            final /* synthetic */ FormattedModeHandler this$0;

            public final void run() {
                PsiDocumentManager.getInstance((Project)FormattedModeHandler.access$getProject$p(this.this$0)).commitDocument(FormattedModeHandler.access$getDocument$p(this.this$0));
                Object value2 = FormattedModeHandlerKt.getSelectedValue(FormattedModeHandler.access$getGrid$p(this.this$0));
                MinimizedFormat minimizedFormat = FormattedModeHandlerKt.access$detectFormat(FormattedModeHandler.access$getGrid$p(this.this$0), value2, FormattedModeHandler.access$getProject$p(this.this$0), FormattedModeHandler.access$getDocument$p(this.this$0));
                if (minimizedFormat == null) {
                    return;
                }
                MinimizedFormat format = minimizedFormat;
                FormattedModeHandler.access$setFormatCache$p(this.this$0, this.this$0.new FormatCache(format));
                format.reformat((Function1<? super Function0<Unit>, Unit>)FormattedModeHandler.access$getDisableUpdateListener$p(this.this$0));
            }
            {
                this.this$0 = formattedModeHandler2;
            }
        });
    }

    @NotNull
    public final String minimize(@NotNull PsiFile file) {
        String string;
        MinimizedFormat format;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FormatCache formatCache = this.formatCache;
        MinimizedFormat minimizedFormat = format = formatCache != null ? formatCache.get() : null;
        if (format == null || !this.enabled || !this.supportsCurrentValue()) {
            String string2 = file.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.text");
        } else {
            string = format.restore(file);
        }
        return string;
    }

    public FormattedModeHandler(@NotNull DataGrid grid, @NotNull Document document, @NotNull Project project, @NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        this.grid = grid;
        this.document = document;
        this.project = project;
        this.disableUpdateListener = disableUpdateListener;
        if (!PropertiesComponent.getInstance().getBoolean(FORMATTED_MODE_DISABLED)) {
            this.enabled = true;
        }
    }

    public static final /* synthetic */ Project access$getProject$p(FormattedModeHandler $this) {
        return $this.project;
    }

    public static final /* synthetic */ Document access$getDocument$p(FormattedModeHandler $this) {
        return $this.document;
    }

    public static final /* synthetic */ FormatCache access$getFormatCache$p(FormattedModeHandler $this) {
        return $this.formatCache;
    }

    public static final /* synthetic */ void access$setFormatCache$p(FormattedModeHandler $this, FormatCache formatCache) {
        $this.formatCache = formatCache;
    }

    public static final /* synthetic */ Function1 access$getDisableUpdateListener$p(FormattedModeHandler $this) {
        return $this.disableUpdateListener;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler$FormatCache;", "", "format", "Lcom/intellij/database/run/ui/MinimizedFormat;", "(Lcom/intellij/database/run/ui/FormattedModeHandler;Lcom/intellij/database/run/ui/MinimizedFormat;)V", "column", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "getColumn", "()Lcom/intellij/database/datagrid/ModelIndex;", "getFormat", "()Lcom/intellij/database/run/ui/MinimizedFormat;", "row", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "getRow", "get", "intellij.database.impl"})
    private final class FormatCache {
        @NotNull
        private final ModelIndex<DataConsumer.Row> row;
        @NotNull
        private final ModelIndex<DataConsumer.Column> column;
        @NotNull
        private final MinimizedFormat format;

        @NotNull
        public final ModelIndex<DataConsumer.Row> getRow() {
            return this.row;
        }

        @NotNull
        public final ModelIndex<DataConsumer.Column> getColumn() {
            return this.column;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final MinimizedFormat get() {
            SelectionModel selectionModel = FormattedModeHandler.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
            if (!Intrinsics.areEqual(this.row, selectionModel.getLeadSelectionRow())) return null;
            SelectionModel selectionModel2 = FormattedModeHandler.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
            if (!Intrinsics.areEqual(this.column, selectionModel2.getLeadSelectionColumn())) return null;
            MinimizedFormat minimizedFormat = this.format;
            return minimizedFormat;
        }

        @NotNull
        public final MinimizedFormat getFormat() {
            return this.format;
        }

        public FormatCache(MinimizedFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            this.format = format;
            SelectionModel selectionModel = FormattedModeHandler.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
            ModelIndex modelIndex = selectionModel.getLeadSelectionRow();
            Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
            this.row = modelIndex;
            SelectionModel selectionModel2 = FormattedModeHandler.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
            ModelIndex modelIndex2 = selectionModel2.getLeadSelectionColumn();
            Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
            this.column = modelIndex2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler$Companion;", "", "()V", "FORMATTED_MODE_DISABLED", "", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

