/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ValueParserCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/ValueParserCache;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "column", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "getColumn", "()Lcom/intellij/database/datagrid/ModelIndex;", "setColumn", "(Lcom/intellij/database/datagrid/ModelIndex;)V", "currentParser", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "defaultParser", "row", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "getRow", "setRow", "clearCache", "", "getValueParser", "intellij.database.impl"})
public final class ValueParserCache {
    @NotNull
    private ModelIndex<DataConsumer.Row> row;
    @NotNull
    private ModelIndex<DataConsumer.Column> column;
    private final GridCellEditorFactory.ValueParser defaultParser;
    private GridCellEditorFactory.ValueParser currentParser;
    private final DataGrid grid;

    @NotNull
    public final ModelIndex<DataConsumer.Row> getRow() {
        return this.row;
    }

    public final void setRow(@NotNull ModelIndex<DataConsumer.Row> modelIndex) {
        Intrinsics.checkNotNullParameter(modelIndex, (String)"<set-?>");
        this.row = modelIndex;
    }

    @NotNull
    public final ModelIndex<DataConsumer.Column> getColumn() {
        return this.column;
    }

    public final void setColumn(@NotNull ModelIndex<DataConsumer.Column> modelIndex) {
        Intrinsics.checkNotNullParameter(modelIndex, (String)"<set-?>");
        this.column = modelIndex;
    }

    @NotNull
    public final GridCellEditorFactory.ValueParser getValueParser(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        if (Intrinsics.areEqual(this.row, row) ^ true || Intrinsics.areEqual(this.column, column2) ^ true) {
            this.row = row;
            this.column = column2;
            ResultView resultView = this.grid.getResultView();
            Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"grid.resultView");
            GridCellEditorFactoryProvider gridCellEditorFactoryProvider = resultView.getEditorFactoryProvider();
            GridCellEditorFactory factory = gridCellEditorFactoryProvider != null ? gridCellEditorFactoryProvider.getEditorFactory(this.grid, row, column2) : null;
            Object object = factory;
            if (object == null || (object = object.getValueParser(this.grid, row, column2)) == null) {
                object = this.defaultParser;
            }
            this.currentParser = object;
        }
        return this.currentParser;
    }

    public final void clearCache() {
        ModelIndex modelIndex = ModelIndex.forRow(this.grid, -1);
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"ModelIndex.forRow(grid, -1)");
        this.row = modelIndex;
        ModelIndex modelIndex2 = ModelIndex.forColumn(this.grid, -1);
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"ModelIndex.forColumn(grid, -1)");
        this.column = modelIndex2;
    }

    public ValueParserCache(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        ModelIndex modelIndex = ModelIndex.forRow(this.grid, -1);
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"ModelIndex.forRow(grid, -1)");
        this.row = modelIndex;
        ModelIndex modelIndex2 = ModelIndex.forColumn(this.grid, -1);
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"ModelIndex.forColumn(grid, -1)");
        this.column = modelIndex2;
        this.currentParser = this.defaultParser = (GridCellEditorFactory.ValueParser)defaultParser.1.INSTANCE;
    }
}

