/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridPanelWithEditor
extends JPanel
implements EditorColorsListener,
DataProvider {
    protected final Project myProject;
    protected final DataGrid myGrid;
    protected final EditorEx myEditor;

    GridPanelWithEditor(@NotNull Project project, @NotNull DataGrid grid, final @NotNull String prefix, final @NotNull String defaultText, @NotNull Document document) {
        if (project == null) {
            GridPanelWithEditor.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridPanelWithEditor.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            GridPanelWithEditor.$$$reportNull$$$0(2);
        }
        if (defaultText == null) {
            GridPanelWithEditor.$$$reportNull$$$0(3);
        }
        if (document == null) {
            GridPanelWithEditor.$$$reportNull$$$0(4);
        }
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myGrid = grid;
        this.myEditor = this.createEditor(document);
        GridPanelWithEditor.updateEditorPrefix(this.myEditor, prefix, defaultText);
        Disposer.register((Disposable)this.myGrid, () -> EditorFactory.getInstance().releaseEditor((Editor)this.myEditor));
        GridDataHookUp hookUp = this.myGrid.getDataHookup();
        if (hookUp instanceof DataBusGridDataHookUp) {
            ((DataBusGridDataHookUp)hookUp).getLoader().updateQueryText();
        }
        final JBLabel clearFieldLabel = new JBLabel(AllIcons.Actions.Close);
        clearFieldLabel.setOpaque(false);
        clearFieldLabel.setVisible(document.getTextLength() != 0);
        clearFieldLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridPanelWithEditor.this.clearText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridPanelWithEditor$1", "mouseReleased"));
            }
        });
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                int oldLength = event.getOldLength();
                int newLength = event.getNewLength();
                if (oldLength == 0 || newLength == 0 || oldLength == defaultText.length() || newLength == defaultText.length()) {
                    clearFieldLabel.setVisible(event.getDocument().getTextLength() != 0);
                    GridPanelWithEditor.updateEditorPrefix(GridPanelWithEditor.this.myEditor, prefix, defaultText);
                }
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                clearFieldLabel.setVisible(document.getTextLength() != 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myGrid);
        this.add((Component)clearFieldLabel, "East");
        this.add((Component)this.myEditor.getComponent(), "Center");
    }

    @NotNull
    public String getText() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            GridPanelWithEditor.$$$reportNull$$$0(5);
        }
        return string;
    }

    abstract void clearText();

    protected void setHighlighter() {
        GridDataHookUp hookUp = this.myGrid.getDataHookup();
        DbDataSource dataSource2 = hookUp instanceof DataBusGridDataHookUp ? ((DataBusGridDataHookUp)hookUp).getDataSource() : null;
        SqlLanguageDialect filterLanguage = dataSource2 != null ? DbSqlUtilCore.getSqlDialect(dataSource2) : GridHelper.get(DataGridUtil.getDbms(this.myGrid)).getFilterLanguage();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)filterLanguage, (Project)this.myProject, null);
        LexerEditorHighlighter lexerHighlighter = new LexerEditorHighlighter(highlighter, (EditorColorsScheme)this.myGrid.getColorsScheme());
        this.myEditor.setHighlighter((EditorHighlighter)lexerHighlighter);
    }

    @NotNull
    private EditorEx createEditor(@NotNull Document document) {
        if (document == null) {
            GridPanelWithEditor.$$$reportNull$$$0(6);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
        editor.putUserData(EditorTextField.SUPPLEMENTARY_KEY, (Object)true);
        editor.setOneLineMode(true);
        editor.getSettings().setCaretRowShown(false);
        editor.getSettings().setShowIntentionBulb(false);
        EditorTextField.setupTextFieldEditor((EditorEx)editor);
        editor.getComponent().setFocusable(false);
        editor.getComponent().setOpaque(false);
        editor.getComponent().setBorder((Border)JBUI.Borders.empty((int)0, (int)7));
        GridPanelWithEditor.setScheme(editor, (EditorColorsScheme)this.myGrid.getColorsScheme());
        editor.setEmbeddedIntoDialogWrapper(true);
        editor.getContentComponent().setOpaque(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            GridPanelWithEditor.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    public void onError(@NotNull Throwable error2) {
        if (error2 == null) {
            GridPanelWithEditor.$$$reportNull$$$0(8);
        }
        JComponent component = this.myEditor.getContentComponent();
        DataSourceUiUtil.showErrorBalloon(error2, component, GridPanelWithEditor.getFilterEditorCaretPoint(this.myEditor), true, false);
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return IdeBackgroundUtil.withEditorBackground((Graphics)g, (JComponent)this);
    }

    @Override
    public Color getBackground() {
        return this.myEditor == null ? super.getBackground() : this.myEditor.getBackgroundColor();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getComponent(), true));
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean b2 = this.myEditor.getContentComponent().requestFocusInWindow();
        if (!this.myEditor.isDisposed()) {
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        return b2;
    }

    public boolean handleError(GridRequestSource source, Throwable error2) {
        GridPanelWithEditorRequestPlace place = (GridPanelWithEditorRequestPlace)ObjectUtils.tryCast((Object)source.place, GridPanelWithEditorRequestPlace.class);
        if (place == null || place.myPanel != this) {
            return false;
        }
        this.onError(error2);
        return true;
    }

    @NotNull
    protected static Point getFilterEditorCaretPoint(@NotNull EditorEx editor) {
        if (editor == null) {
            GridPanelWithEditor.$$$reportNull$$$0(9);
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        Point point = editor.visualPositionToXY(caretPosition);
        point.translate(0, editor.getContentComponent().getHeight());
        Point point2 = point;
        if (point2 == null) {
            GridPanelWithEditor.$$$reportNull$$$0(10);
        }
        return point2;
    }

    private static void updateEditorPrefix(@NotNull EditorEx editor, @NotNull String prefix, @NotNull String defaultText) {
        if (editor == null) {
            GridPanelWithEditor.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            GridPanelWithEditor.$$$reportNull$$$0(12);
        }
        if (defaultText == null) {
            GridPanelWithEditor.$$$reportNull$$$0(13);
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        TextAttributes attributes2 = scheme.getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT).clone();
        TextAttributes keywordAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.KEYWORD).clone();
        DocumentEx document = editor.getDocument();
        if (document.getTextLength() == 0 || defaultText.equals(document.getText()) || GridPanelWithEditor.isComment(document.getText())) {
            keywordAttributes.setForegroundColor(attributes2.getForegroundColor());
        }
        editor.setPrefixTextAndAttributes(prefix, keywordAttributes);
    }

    protected static boolean isComment(@NotNull String text2) {
        if (text2 == null) {
            GridPanelWithEditor.$$$reportNull$$$0(14);
        }
        return text2.startsWith("--") || text2.startsWith("#") || text2.startsWith("//") || text2.startsWith("/*");
    }

    private static void setScheme(@NotNull EditorEx editor, @NotNull EditorColorsScheme scheme) {
        if (editor == null) {
            GridPanelWithEditor.$$$reportNull$$$0(15);
        }
        if (scheme == null) {
            GridPanelWithEditor.$$$reportNull$$$0(16);
        }
        editor.setColorsScheme(scheme);
        editor.setBackgroundColor(editor.getBackgroundColor());
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        GridPanelWithEditor.setScheme(this.myEditor, (EditorColorsScheme)this.myGrid.getColorsScheme());
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridPanelWithEditor.$$$reportNull$$$0(17);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return TextEditorProvider.getInstance().getTextEditor((Editor)this.myEditor);
        }
        return null;
    }

    @NotNull
    @NlsContexts.PopupContent
    abstract String getInvalidTextErrorMessage();

    abstract void showHistoryPopup();

    @NotNull
    static CustomShortcutSet getShowHistoryShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(40, 512));
    }

    @NotNull
    static JBPopup createHistoryPopup(@NotNull List<String> history, @NotNull Project project, @NotNull Editor editor, @NotNull Runnable apply2) {
        if (history == null) {
            GridPanelWithEditor.$$$reportNull$$$0(18);
        }
        if (project == null) {
            GridPanelWithEditor.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            GridPanelWithEditor.$$$reportNull$$$0(20);
        }
        if (apply2 == null) {
            GridPanelWithEditor.$$$reportNull$$$0(21);
        }
        JBList historyList = new JBList((Collection)ContainerUtil.filter(history, value2 -> !value2.isEmpty()));
        Runnable itemChosenCallback = () -> GridPanelWithEditor.lambda$createHistoryPopup$4((JList)historyList, project, editor, apply2);
        JBPopup jBPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)historyList).setMovable(false).setRequestFocus(true).setItemChoosenCallback(itemChosenCallback).createPopup();
        if (jBPopup == null) {
            GridPanelWithEditor.$$$reportNull$$$0(22);
        }
        return jBPopup;
    }

    public void apply() {
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        if (model != null && this.myGrid.isSafeToReload()) {
            this.myGrid.getDataHookup().getLoader().applyFilterAndSorting(new GridRequestSource(new GridPanelWithEditorRequestPlace(this)));
        }
    }

    private static /* synthetic */ void lambda$createHistoryPopup$4(JList historyList, Project project, Editor editor, Runnable apply2) {
        String selectedFilter = (String)historyList.getSelectedValue();
        if (selectedFilter != null) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                Document document = editor.getDocument();
                document.replaceString(0, document.getTextLength(), (CharSequence)selectedFilter);
                CaretModel caretModel = editor.getCaretModel();
                if (caretModel.getOffset() >= document.getTextLength()) {
                    caretModel.moveToOffset(document.getTextLength());
                }
            });
            apply2.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridPanelWithEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterEditorCaretPoint";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createHistoryPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilterEditorCaretPoint";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridPanelWithEditorRequestPlace
    implements GridRequestSource.GridRequestPlace {
        final GridPanelWithEditor myPanel;

        GridPanelWithEditorRequestPlace(@NotNull GridPanelWithEditor panel2) {
            if (panel2 == null) {
                GridPanelWithEditorRequestPlace.$$$reportNull$$$0(0);
            }
            this.myPanel = panel2;
        }

        @NotNull
        public CoreGrid getGrid() {
            DataGrid dataGrid = this.myPanel.myGrid;
            if (dataGrid == null) {
                GridPanelWithEditorRequestPlace.$$$reportNull$$$0(1);
            }
            return dataGrid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$GridPanelWithEditorRequestPlace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$GridPanelWithEditorRequestPlace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class HistoryIcon
    extends JBLabel {
        HistoryIcon(Icon icon) {
            if (icon == null) {
                HistoryIcon.$$$reportNull$$$0(0);
            }
            super(icon);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GridPanelWithEditor.this.showHistoryPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridPanelWithEditor$HistoryIcon$1", "mousePressed"));
                }
            });
            new HelpTooltip().setTitle(DatabaseBundle.message("action.ShowHistoryAction.tooltip", new Object[0])).setShortcut(KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)GridPanelWithEditor.getShowHistoryShortcut())).setLocation(HelpTooltip.Alignment.BOTTOM).installOn((JComponent)((Object)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/database/run/ui/grid/GridPanelWithEditor$HistoryIcon", "<init>"));
        }
    }

    static class ShowHistoryAction
    extends FilterFieldAction {
        ShowHistoryAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridPanelWithEditor> getPanel) {
            if (getPanel == null) {
                ShowHistoryAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("action.ShowHistoryAction.text", new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridPanelWithEditor panel2) {
            if (panel2 == null) {
                ShowHistoryAction.$$$reportNull$$$0(1);
            }
            panel2.showHistoryPopup();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$ShowHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ApplyAction
    extends FilterFieldAction {
        public ApplyAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridPanelWithEditor> getPanel) {
            if (getPanel == null) {
                ApplyAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("action.ApplyAction.text", new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridPanelWithEditor panel2) {
            if (panel2 == null) {
                ApplyAction.$$$reportNull$$$0(1);
            }
            if (ApplyAction.isValidTextEntered((Document)panel2.myEditor.getDocument(), panel2.myGrid.getDataHookup().getProject())) {
                panel2.apply();
            } else {
                ApplyAction.showInvalidFilterCriteriaBalloon(panel2, panel2.getInvalidTextErrorMessage());
            }
        }

        private static boolean isValidTextEntered(Document document, Project project) {
            String filter2 = document.getText();
            if (StringUtil.isEmptyOrSpaces((String)filter2) || GridPanelWithEditor.isComment(filter2)) {
                return true;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return psi == null || psi.getLanguage().getID().equals("GenericSQL") || !PsiTreeUtil.hasErrorElements((PsiElement)psi);
        }

        private static void showInvalidFilterCriteriaBalloon(@NotNull GridPanelWithEditor panel2, @NotNull @NlsContexts.PopupContent String message2) {
            if (panel2 == null) {
                ApplyAction.$$$reportNull$$$0(2);
            }
            if (message2 == null) {
                ApplyAction.$$$reportNull$$$0(3);
            }
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.WARNING, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
            Point point = GridPanelWithEditor.getFilterEditorCaretPoint(panel2.myEditor);
            balloon.show(new RelativePoint((Component)panel2.myEditor.getComponent(), point), Balloon.Position.below);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$ApplyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showInvalidFilterCriteriaBalloon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class CancelAction
    extends FilterFieldAction {
        CancelAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridPanelWithEditor> getPanel) {
            if (getPanel == null) {
                CancelAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("action.CancelAction.text", new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridPanelWithEditor panel2) {
            if (panel2 == null) {
                CancelAction.$$$reportNull$$$0(1);
            }
            IdeFocusManager.findInstanceByComponent((Component)((Object)panel2.myGrid.getComponent())).requestFocus((Component)panel2.myGrid.getPreferredFocusedComponent(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$CancelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class FilterFieldAction
    extends DumbAwareAction {
        @NotNull
        private final @NotNull Function<@NotNull DataGrid, @Nullable GridPanelWithEditor> myGetPanel;

        FilterFieldAction(@Nullable @NlsActions.ActionText String text2, @NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridPanelWithEditor> getPanel) {
            if (getPanel == null) {
                FilterFieldAction.$$$reportNull$$$0(0);
            }
            super(text2);
            this.myGetPanel = getPanel;
        }

        public void update(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                FilterFieldAction.$$$reportNull$$$0(1);
            }
            GridPanelWithEditor panel2 = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridPanelWithEditor)this.myGetPanel.fun((Object)grid);
            e.getPresentation().setEnabled(panel2 != null && LookupManager.getActiveLookup((Editor)panel2.myEditor) == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridPanelWithEditor panel2;
            if (e == null) {
                FilterFieldAction.$$$reportNull$$$0(2);
            }
            GridPanelWithEditor gridPanelWithEditor = panel2 = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridPanelWithEditor)this.myGetPanel.fun((Object)grid);
            if (panel2 == null) {
                return;
            }
            this.actionPerformed(panel2);
        }

        protected abstract void actionPerformed(@NotNull GridPanelWithEditor var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridPanelWithEditor$FilterFieldAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

