/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public abstract class GridRowHeader
extends JComponent {
    private static final int MIN_PREFERRED_WIDTH = 15;
    private final CellRendererPane myRendererPane;
    private int myPreferredWidth;

    protected GridRowHeader(@NotNull JTable table) {
        if (table == null) {
            GridRowHeader.$$$reportNull$$$0(0);
        }
        this.myRendererPane = new CellRendererPane();
        this.myPreferredWidth = 1;
        this.add(this.myRendererPane);
        this.initListeners(table);
    }

    @NotNull
    public abstract RowHeaderCellRenderer getCellRenderer();

    @NotNull
    public abstract JTable getTable();

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.myPreferredWidth, this.getTable().getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        final Graphics2D g2 = (Graphics2D)g;
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paintComponent(g);
        final JTable table = this.getTable();
        final Rectangle clip = g.getClipBounds();
        final int rowMargin = table.getRowMargin();
        final BasicStroke gridLineStroke = new BasicStroke(rowMargin);
        CellRenderingUtils.processVisibleRows(table, g, new CellRenderingUtils.RowProcessor(){

            @Override
            public boolean process(int row, int y) {
                int rowHeight = table.getRowHeight(row);
                int cellHeight = Math.max(0, rowHeight - rowMargin);
                Component cellRenderer = GridRowHeader.this.getCellRenderer().getRendererComponent(row, true);
                GridRowHeader.this.myRendererPane.paintComponent(g2, cellRenderer, GridRowHeader.this, 0, y, GridRowHeader.this.getWidth(), cellHeight, true);
                int gridY = y + cellHeight + rowMargin / 2;
                Stroke backupStroke = g2.getStroke();
                Color backupColor = g2.getColor();
                g2.setStroke(gridLineStroke);
                g2.setColor(table.getGridColor());
                g2.drawLine(clip.x, gridY, clip.x + clip.width, gridY);
                g2.setStroke(backupStroke);
                g2.setColor(backupColor);
                return true;
            }
        });
    }

    private void initListeners(JTable table) {
        table.getModel().addTableModelListener(e -> this.updatePreferredSize());
        this.addPropertyChangeListener("rowHeight", e -> this.updatePreferredSize());
        table.addComponentListener(new ComponentAdapter(){
            int myPreviousTableHeight;

            @Override
            public void componentResized(ComponentEvent e) {
                Component c2 = e.getComponent();
                if (this.myPreviousTableHeight != c2.getHeight()) {
                    GridRowHeader.this.updatePreferredSize(GridRowHeader.this.getPreferredSize().width, false);
                    this.myPreviousTableHeight = c2.getHeight();
                }
            }
        });
    }

    public void updatePreferredSize() {
        Insets insets = this.getInsets();
        this.updatePreferredSize(insets.left + insets.right + this.calcPreferredWidthWithoutInsets(), true);
    }

    protected void updatePreferredSize(int preferredWidth, boolean checkMinWidth) {
        if (checkMinWidth && preferredWidth < 15) {
            preferredWidth = 15;
        }
        Dimension prevSize = this.getPreferredSize();
        this.myPreferredWidth = preferredWidth;
        Dimension newSize = this.getPreferredSize();
        this.firePropertyChange("preferredSize", prevSize, newSize);
    }

    protected int calcPreferredWidthWithoutInsets() {
        int maxCellRendererWidth = 0;
        for (int row = 0; row < this.getTable().getModel().getRowCount(); ++row) {
            Component renderer = this.getCellRenderer().getRendererComponent(row, false);
            Dimension preferredSize = renderer.getPreferredSize();
            if (preferredSize.width <= maxCellRendererWidth) continue;
            maxCellRendererWidth = preferredSize.width;
        }
        return Math.max(1, maxCellRendererWidth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridRowHeader", "<init>"));
    }

    public static interface RowHeaderCellRenderer {
        public Component getRendererComponent(int var1, boolean var2);
    }
}

