/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.OptionalValueParser;
import com.intellij.database.run.ui.grid.editors.UniversalFormatter;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoObjectIdEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    public static final Pattern OBJECT_ID_PATTERN = Pattern.compile("[0-9a-fA-F]{24}");
    private final OptionalValueParser<MongoJdbcHelper.MongoObjectIdValue> myParser = text2 -> {
        Matcher matcher = OBJECT_ID_PATTERN.matcher(text2 = text2.trim());
        return matcher.matches() ? new MongoJdbcHelper.MongoObjectIdValue(text2) : null;
    };

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(2);
        }
        return DataGridUtil.getDbms(grid).is(Dbms.MONGO) ? MongoObjectIdEditorFactory.getSuitability(GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2)) : 0;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(4);
        }
        return DataGridUtil.getDbms(grid).is(Dbms.MONGO) ? MongoObjectIdEditorFactory.getSuitability(domain.simpleName()) : 0;
    }

    private static int getSuitability(@Nullable String typeName) {
        return StringUtil.equalsIgnoreCase((CharSequence)"ObjectId", (CharSequence)typeName) ? 10 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(5);
        }
        if (domain == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(6);
        }
        return new ValueParserWrapper<MongoJdbcHelper.MongoObjectIdValue>(this.myParser, true, DataGridUtil.getDefaultNullValue(grid, null), (Function1<? super String, ? extends UnparsedValue>)((Function1)text2 -> new UnparsedValue((String)text2, domain)));
    }

    @Override
    @NotNull
    protected Formatter getFormatInner(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            MongoObjectIdEditorFactory.$$$reportNull$$$0(9);
        }
        final DataConsumer.Column column2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        return new UniversalFormatter(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(grid.getObjectFormatter().objectToString(obj, column2, DataGridUtil.getDbms(grid), ObjectFormatterMode.DISPLAY));
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                MongoJdbcHelper.MongoObjectIdValue parsed = MongoObjectIdEditorFactory.this.myParser.parse(source);
                if (parsed != null) {
                    pos.setIndex(source.length());
                    return parsed;
                }
                pos.setErrorIndex(0);
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/MongoObjectIdEditorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitability";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

