/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.schemaEditor.AutoSelectListener;
import com.intellij.database.schemaEditor.DbObjectSinglePropEditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSeqIdPropEditor<E extends BasicElement>
extends DbObjectSinglePropEditor<E, SequenceIdentity> {
    private final JComponent myPanel;
    private final JTextField myMin;
    private final JTextField myMax;
    private final JTextField myStep;

    protected DbSeqIdPropEditor(@NotNull BasicMetaProperty<E, SequenceIdentity> property, @NlsContexts.Label @Nullable String title) {
        if (property == null) {
            DbSeqIdPropEditor.$$$reportNull$$$0(0);
        }
        super(property, null);
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
        this.myMin = this.addField(DatabaseBundle.message("label.min", new Object[0]), 0);
        this.myMax = this.addField(DatabaseBundle.message("label.max", new Object[0]), 2);
        this.myStep = this.addField(DatabaseBundle.message("label.step", new Object[0]), 4);
    }

    private JTextField addField(@NlsContexts.Label String title, int base) {
        JBLabel lbl = new JBLabel(title);
        this.myPanel.add((Component)lbl, UrlPropertiesPanel.createLabelConstraints(0, base, lbl.getPreferredSize().width));
        JTextField field = new JTextField();
        this.myPanel.add((Component)field, UrlPropertiesPanel.createSimpleConstraints(0, base + 1, 1));
        field.addFocusListener(AutoSelectListener.INSTANCE);
        return field;
    }

    @Override
    public void applyImpl(@Nullable E edited, @NotNull E e) {
        if (e == null) {
            DbSeqIdPropEditor.$$$reportNull$$$0(1);
        }
        BigInteger min = DbSeqIdPropEditor.getVal(this.myMin);
        BigInteger max = DbSeqIdPropEditor.getVal(this.myMax);
        BigInteger step = DbSeqIdPropEditor.getVal(this.myStep);
        SequenceIdentity prev = edited == null ? null : (SequenceIdentity)this.myProperty.get(edited);
        BigInteger next = prev == null ? null : prev.next;
        this.myProperty.set(e, SequenceIdentity.of(min, next, step, max));
    }

    @Nullable
    private static BigInteger getVal(JTextField field) {
        String text2 = field.getText();
        if (StringUtil.isEmpty((String)text2)) {
            return null;
        }
        try {
            BigInteger val = new BigInteger(text2);
            DbUIUtil.setError(field, null);
            return val;
        }
        catch (Throwable th) {
            DbUIUtil.setError(field, th.getMessage());
            return null;
        }
    }

    @Override
    public void resetImpl(@NotNull E e) {
        SequenceIdentity se;
        if (e == null) {
            DbSeqIdPropEditor.$$$reportNull$$$0(2);
        }
        BigInteger min = (se = (SequenceIdentity)this.myProperty.get(e)) == null ? null : se.min;
        BigInteger max = se == null ? null : se.max;
        BigInteger increment = se == null ? null : se.increment;
        this.myMin.setText(min == null ? "" : min.toString());
        this.myMax.setText(max == null ? "" : max.toString());
        this.myStep.setText(increment == null ? "" : increment.toString());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DbSeqIdPropEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbSeqIdPropEditor.$$$reportNull$$$0(4);
        }
        return fieldSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbSeqIdPropEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbSeqIdPropEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

