/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.Binding;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.FileScriptConsumer;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptedScriptConsumer
implements FileScriptConsumer<String> {
    private final File myRoot;
    private final Layout myLayout;
    private final PairConsumer<File, ScriptingResult> fileWriter;
    private int myCount;
    private static final Binding<Layout> LAYOUT = new Binding("LAYOUT");

    public ScriptedScriptConsumer(File root2, Layout layout, PairConsumer<File, ScriptingResult> writer) {
        this.myRoot = root2;
        this.myLayout = layout;
        this.fileWriter = writer;
    }

    @Override
    public boolean ignoreDependencies() {
        return this.myLayout.ignoreDependencies;
    }

    @Override
    @Nullable
    public String distribute(@NotNull BasicElement element2) {
        if (element2 == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(0);
        }
        return this.myLayout.getBaseName(element2);
    }

    @Override
    public void consume(@NotNull ScriptingResult result2, String tag) {
        if (result2 == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(1);
        }
        File file = this.getFile(tag);
        this.fileWriter.consume((Object)file, (Object)result2);
    }

    @Override
    @NotNull
    public File getFile(String tag) {
        return new File(this.myRoot, this.myLayout.getFileName(tag, this.myCount++));
    }

    @Nullable
    public static ScriptedScriptConsumer createScriptedConsumer(@NotNull Project project, @NotNull File scriptFile, @NotNull File root2, @NotNull PairConsumer<File, ScriptingResult> writer) throws IdeScriptException {
        IdeScriptEngine engine;
        if (project == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(2);
        }
        if (scriptFile == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(3);
        }
        if (root2 == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(5);
        }
        if ((engine = ExtensionScriptsUtil.getEngineFor(project, DatabasePluginId.get(), scriptFile)) == null) {
            return null;
        }
        Layout layout = new Layout();
        ExtensionScriptsUtil.setBindings(engine).bind(LAYOUT, layout);
        ExtensionScriptsUtil.evalScript(project, engine, scriptFile);
        return new ScriptedScriptConsumer(root2, layout, writer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/script/generator/ScriptedScriptConsumer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "distribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "consume";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createScriptedConsumer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Layout {
        public boolean ignoreDependencies;
        private Function<BaseNameContext, @Nullable String> myBaseName = ctx -> null;
        private Function<FileNameContext, @NotNull String> myFileName = ctx -> ctx.baseName + ".sql";
        private final BaseNameContext myBaseNameContext = new BaseNameContext();
        private final FileNameContext myFileNameContext = new FileNameContext();

        private Layout() {
        }

        public void baseName(Function<BaseNameContext, String> bn) {
            this.myBaseName = bn;
        }

        public void fileName(Function<FileNameContext, String> fn) {
            this.myFileName = fn;
        }

        @Nullable
        private String getBaseName(@NotNull DasObject obj) {
            if (obj == null) {
                Layout.$$$reportNull$$$0(0);
            }
            this.myBaseNameContext.object = obj;
            String res2 = (String)this.myBaseName.fun((Object)this.myBaseNameContext);
            this.myBaseNameContext.object = null;
            return res2;
        }

        @NotNull
        private String getFileName(@NotNull String baseName, int count) {
            if (baseName == null) {
                Layout.$$$reportNull$$$0(1);
            }
            this.myFileNameContext.baseName = baseName;
            this.myFileNameContext.count = count;
            String string = (String)this.myFileName.fun((Object)this.myFileNameContext);
            if (string == null) {
                Layout.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/generator/ScriptedScriptConsumer$Layout";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/generator/ScriptedScriptConsumer$Layout";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBaseName";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class FileNameContext {
            public String baseName;
            public int count;
        }

        public static class BaseNameContext {
            public DasObject object;
        }
    }
}

