/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0006\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0007\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"getCodeStyleName", "", "ds", "Lcom/intellij/database/model/DasDataSource;", "getSqlCodeStyle", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/psi/DbDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/sql/database/SqlDataSource;", "intellij.database.core.impl"})
public final class ScriptingTaskBuilderKt {
    @Nullable
    public static final String getCodeStyleName(@NotNull DasDataSource ds) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DasDataSource dasDataSource = ds;
        if (dasDataSource instanceof DbDataSource) {
            DatabaseSystem databaseSystem = ((DbDataSource)ds).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)databaseSystem, (String)"ds.delegate");
            string = ScriptingTaskBuilderKt.getCodeStyleName(databaseSystem);
        } else {
            string = dasDataSource instanceof LocalDataSource ? ((LocalDataSource)ds).getCodeStyleName() : (dasDataSource instanceof SqlDataSource ? ((SqlDataSource)ds).getCodeStyleName() : null);
        }
        return string;
    }

    @NotNull
    public static final SqlCodeStyleSettings getSqlCodeStyle(@NotNull DbDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)ds.getProject(), (String)ScriptingTaskBuilderKt.getCodeStyleName(ds), (SqlLanguageDialect)DbSqlUtilCore.getSqlDialect(ds));
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(ds.projec\u2026ilCore.getSqlDialect(ds))");
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static final SqlCodeStyleSettings getSqlCodeStyle(@NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings(null, (String)ds.getCodeStyleName(), (SqlLanguageDialect)DbSqlUtilCore.getSqlDialect(ds));
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(null, ds.\u2026ilCore.getSqlDialect(ds))");
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static final SqlCodeStyleSettings getSqlCodeStyle(@NotNull Project project, @NotNull SqlDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (String)ScriptingTaskBuilderKt.getCodeStyleName((DasDataSource)ds), (SqlLanguageDialect)DbSqlUtilCore.getSqlDialect(project, (DasDataSource)ds));
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(project, \u2026tSqlDialect(project, ds))");
        return sqlCodeStyleSettings;
    }
}

