/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public enum Case {
    MIXED(false),
    LOWER(false),
    UPPER(false),
    TITLE(false),
    EXACT(true);

    public final boolean sensitive;

    private Case(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public String apply(String s2) {
        switch (this) {
            case EXACT: 
            case MIXED: {
                return s2;
            }
            case LOWER: {
                return StringUtil.toLowerCase((String)s2);
            }
            case UPPER: {
                return StringUtil.toUpperCase((String)s2);
            }
            case TITLE: {
                return StringUtil.toTitleCase((String)StringUtil.toLowerCase((String)s2));
            }
        }
        throw new AssertionError((Object)this);
    }

    @Contract(value="_,!null->!null")
    public static Case fromString(@Nullable String str, @Nullable Case def) {
        if (str == null) {
            return def;
        }
        for (Case mode : Case.values()) {
            if (!Comparing.equal((String)str, (String)mode.name(), (boolean)false)) continue;
            return mode;
        }
        return def;
    }

    public static Case guessForName(@Nullable String str, Boolean isQuoted, Case plainMode, Case quotedMode) {
        if (str == null) {
            return plainMode;
        }
        if (Boolean.TRUE.equals(isQuoted)) {
            return quotedMode;
        }
        if (Boolean.FALSE.equals(isQuoted)) {
            return plainMode;
        }
        Case strMode = Case.forString(str);
        if (strMode != MIXED && (plainMode == strMode || quotedMode == strMode)) {
            return strMode;
        }
        if (plainMode == EXACT || quotedMode == EXACT) {
            return EXACT;
        }
        if (plainMode == MIXED || quotedMode == MIXED) {
            return MIXED;
        }
        return plainMode;
    }

    @Nullable
    public static Case forString(@Nullable String str) {
        Case result2 = null;
        if (str == null) {
            return null;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            Case cur2;
            boolean lowerCase;
            char c2 = str.charAt(i2);
            boolean upperCase = Character.isUpperCase(c2);
            if (upperCase == (lowerCase = Character.isLowerCase(c2))) continue;
            Case case_ = cur2 = upperCase ? UPPER : LOWER;
            if (result2 == null) {
                result2 = cur2;
                continue;
            }
            if (result2 == cur2) continue;
            if (result2 == UPPER && i2 == 1) {
                result2 = TITLE;
                continue;
            }
            if (result2 == TITLE && cur2 == LOWER) continue;
            result2 = MIXED;
            break;
        }
        return result2;
    }
}

