/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredDdlBuilder
extends DdlBuilder {
    protected EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
    protected final LinkedList<TextAttributes> myStack = new LinkedList();
    protected boolean myQuoteState;

    public ColoredDdlBuilder(StringBuilder sb) {
        super(sb);
    }

    public ColoredDdlBuilder() {
    }

    @NotNull
    public ColoredDdlBuilder pushStyle(TextAttributesKey key) {
        ColoredDdlBuilder coloredDdlBuilder = this.pushStyle(this.scheme.getAttributes(key));
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(0);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder pushStyle(@Nullable TextAttributes attributes2) {
        this.myStack.addLast(attributes2);
        if (attributes2 != null) {
            this.setAttributes(attributes2, true);
        }
        ColoredDdlBuilder coloredDdlBuilder = this;
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(1);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder popStyle() {
        TextAttributes attributes2 = this.myStack.removeLast();
        if (attributes2 != null) {
            this.setAttributes(attributes2, false);
        }
        ColoredDdlBuilder coloredDdlBuilder = this;
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(2);
        }
        return coloredDdlBuilder;
    }

    protected void setAttributes(@Nullable TextAttributes attributes2, boolean enabled) {
        if (attributes2 == null) {
            return;
        }
        int fontType = attributes2.getFontType();
        Color fg = attributes2.getForegroundColor();
        if (enabled) {
            if (fg != null) {
                this.append("<font").append(" color=\"#").append(ColorUtil.toHex((Color)fg)).append("\"");
                Color bg = attributes2.getBackgroundColor();
                if (bg != null) {
                    this.append(" bgcolor=\"#").append(ColorUtil.toHex((Color)bg)).append("\"");
                }
                this.append(">");
            }
            if ((fontType & 2) != 0) {
                this.append("<i>");
            }
            if ((fontType & 1) != 0) {
                this.append("<b>");
            }
        } else {
            if ((fontType & 1) != 0) {
                this.append("</b>");
            }
            if ((fontType & 2) != 0) {
                this.append("</i>");
            }
            if (fg != null) {
                this.append("</font>");
            }
        }
    }

    @Override
    @NotNull
    public ColoredDdlBuilder plain(@NotNull String text2) {
        if (text2 == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(3);
        }
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.plain(text2);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(4);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder plain(@NotNull String text2, @Nullable TextAttributesKey key) {
        if (text2 == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(5);
        }
        ColoredDdlBuilder coloredDdlBuilder = this.pushStyle(key).plain(text2).popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(6);
        }
        return coloredDdlBuilder;
    }

    @Override
    public DdlBuilder newLine() {
        return super.newLine();
    }

    @Override
    @NotNull
    public DdlBuilder newStatement() {
        DdlBuilder ddlBuilder = super.newStatement();
        if (ddlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected ColoredDdlBuilder append(@NotNull String text2) {
        if (text2 == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(8);
        }
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.append(text2);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(9);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder keyword(@NotNull String keyword) {
        if (keyword == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(10);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.keyword(keyword);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(11);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder symbol(@NotNull String symbol) {
        if (symbol == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(12);
        }
        if ("'".equals(symbol)) {
            boolean bl = this.myQuoteState = !this.myQuoteState;
            if (this.myQuoteState) {
                this.pushStyle(DefaultLanguageHighlighterColors.STRING);
            }
            super.symbol(symbol);
            if (!this.myQuoteState) {
                this.popStyle();
            }
            ColoredDdlBuilder coloredDdlBuilder = this;
            if (coloredDdlBuilder == null) {
                ColoredDdlBuilder.$$$reportNull$$$0(13);
            }
            return coloredDdlBuilder;
        }
        Object key = ".".equals(symbol) ? DefaultLanguageHighlighterColors.DOT : (",".equals(symbol) ? DefaultLanguageHighlighterColors.COMMA : ("(".equals(symbol) || ")".equals(symbol) ? DefaultLanguageHighlighterColors.PARENTHESES : (";".equals(symbol) ? DefaultLanguageHighlighterColors.SEMICOLON : null)));
        this.pushStyle((TextAttributesKey)key);
        super.symbol(symbol);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(14);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder comment(@NotNull String s2) {
        if (s2 == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(15);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.LINE_COMMENT);
        super.comment(s2);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(16);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder type(@NotNull String type) {
        if (type == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(17);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.type(type);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(18);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder type(@NotNull DasTypedObject typedInfo) {
        if (typedInfo == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(19);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.type(typedInfo);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(20);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder literal(@NotNull String literal) {
        if (literal == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(21);
        }
        TextAttributesKey key = literal.indexOf(39) > -1 || literal.indexOf(34) > -1 ? DefaultLanguageHighlighterColors.STRING : DefaultLanguageHighlighterColors.NUMBER;
        this.pushStyle(key);
        super.literal(literal);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(22);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder ref(@Nullable DasObject object, String name) {
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.ref(object, name);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(23);
        }
        return coloredDdlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ColoredDdlBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pushStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "popStyle";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ColoredDdlBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "plain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "keyword";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "symbol";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "comment";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "literal";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "plain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "keyword";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "symbol";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "comment";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "literal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

